/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/jdkport/OkioSinkOutputStream;", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "sink", "Lokio/BufferedSink;", "<init>", "(Lokio/BufferedSink;)V", "buffer", "Lokio/Buffer;", "(Lokio/Buffer;)V", "closed", "", "write", "", "b", "", "flush", "close", "core"})
public final class OkioSinkOutputStream
extends OutputStream {
    @Nullable
    private final BufferedSink sink;
    @Nullable
    private final Buffer buffer;
    private boolean closed;

    public OkioSinkOutputStream(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sink = sink;
        this.buffer = null;
    }

    public OkioSinkOutputStream(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.sink = null;
        this.buffer = buffer;
    }

    @Override
    public void write(int b) {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.sink != null) {
            this.sink.writeByte(b);
        } else if (this.buffer != null) {
            this.buffer.writeByte(b);
        }
    }

    @Override
    public void flush() {
        block1: {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink == null) break block1;
            bufferedSink.flush();
        }
    }

    @Override
    public void close() {
        block1: {
            if (this.closed) break block1;
            this.closed = true;
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink != null) {
                bufferedSink.close();
            }
        }
    }
}

