/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.EOFException;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import okio.BufferedSource;
import org.gnit.lucenekmp.jdkport.InputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/jdkport/OkioSourceInputStream;", "Lorg/gnit/lucenekmp/jdkport/InputStream;", "source", "Lokio/BufferedSource;", "<init>", "(Lokio/BufferedSource;)V", "getSource", "()Lokio/BufferedSource;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "read", "", "b", "", "off", "len", "available", "core"})
public final class OkioSourceInputStream
extends InputStream {
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final KLogger logger;

    public OkioSourceInputStream(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.logger = KotlinLogging.INSTANCE.logger(OkioSourceInputStream::logger$lambda$0);
    }

    @NotNull
    public final BufferedSource getSource() {
        return this.source;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @Override
    public int read() {
        int n;
        try {
            n = this.source.readByte() & 0xFF;
        }
        catch (EOFException e) {
            n = -1;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (len == 0) {
            return 0;
        }
        this.logger.debug(() -> OkioSourceInputStream.read$lambda$1(off, len));
        try {
            int result = this.source.read(b, off, len);
            this.logger.debug(() -> OkioSourceInputStream.read$lambda$2(result));
            n2 = result;
        }
        catch (EOFException e) {
            this.logger.debug(() -> OkioSourceInputStream.read$lambda$3(e));
            n2 = -1;
        }
        int bytesRead = n2;
        if (bytesRead != -1) {
            if (bytesRead > 0) {
                this.logger.debug(() -> OkioSourceInputStream.read$lambda$5(b, off, bytesRead));
                this.logger.debug(() -> OkioSourceInputStream.read$lambda$7(b, off, bytesRead));
            } else {
                this.logger.debug(() -> OkioSourceInputStream.read$lambda$8(bytesRead));
            }
            return bytesRead;
        }
        this.logger.debug(OkioSourceInputStream::read$lambda$9);
        if (this.source.exhausted()) {
            this.logger.debug(OkioSourceInputStream::read$lambda$10);
            n = -1;
        } else {
            this.logger.debug(OkioSourceInputStream::read$lambda$11);
            n = 0;
        }
        return n;
    }

    @Override
    public int available() {
        BufferedSource bufferedSource = this.source;
        Buffer buffer = bufferedSource instanceof Buffer ? (Buffer)bufferedSource : null;
        return buffer != null ? (int)buffer.size() : 0;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object read$lambda$1(int $off, int $len) {
        return "KIOSourceInputStream.read(byte[], " + $off + ", " + $len + ") called";
    }

    private static final Object read$lambda$2(int $result) {
        return "source.read returned " + $result;
    }

    private static final Object read$lambda$3(EOFException $e) {
        return "EOFException caught in read " + $e.getMessage();
    }

    private static final CharSequence read$lambda$5$lambda$4(byte it) {
        return UByte.toString-impl((byte)UByte.constructor-impl((byte)it));
    }

    private static final Object read$lambda$5(byte[] $b, int $off, int $bytesRead) {
        return "KIOSourceInputStream.read() filled bytes: " + CollectionsKt.joinToString$default((Iterable)ArraysKt.slice((byte[])$b, (IntRange)RangesKt.until((int)$off, (int)($off + $bytesRead))), (CharSequence)", ", null, null, (int)0, null, OkioSourceInputStream::read$lambda$5$lambda$4, (int)30, null);
    }

    private static final CharSequence read$lambda$7$lambda$6(byte it) {
        return String.valueOf(it);
    }

    private static final Object read$lambda$7(byte[] $b, int $off, int $bytesRead) {
        return "Byte values as integers: " + CollectionsKt.joinToString$default((Iterable)ArraysKt.slice((byte[])$b, (IntRange)RangesKt.until((int)$off, (int)($off + $bytesRead))), (CharSequence)", ", null, null, (int)0, null, OkioSourceInputStream::read$lambda$7$lambda$6, (int)30, null);
    }

    private static final Object read$lambda$8(int $bytesRead) {
        return "KIOSourceInputStream.read() returned " + $bytesRead + " (no bytes read)";
    }

    private static final Object read$lambda$9() {
        return "source.read returned -1, checking if source is truly exhausted.";
    }

    private static final Object read$lambda$10() {
        return "Source is exhausted. Returning -1 for EOF.";
    }

    private static final Object read$lambda$11() {
        return "Source is not exhausted. Returning 0 as no bytes are currently available.";
    }
}

