/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetEncoder;
import org.gnit.lucenekmp.jdkport.OutputStream;
import org.gnit.lucenekmp.jdkport.StreamEncoder;
import org.gnit.lucenekmp.jdkport.Writer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\"\u0010\u001b\u001a\u00020\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0012\u0010\u001b\u001a\u00020\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/jdkport/OutputStreamWriter;", "Lorg/gnit/lucenekmp/jdkport/Writer;", "out", "Lorg/gnit/lucenekmp/jdkport/OutputStream;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;Lorg/gnit/lucenekmp/jdkport/Charset;)V", "enc", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "(Lorg/gnit/lucenekmp/jdkport/OutputStream;Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;)V", "se", "Lorg/gnit/lucenekmp/jdkport/StreamEncoder;", "encoding", "", "getEncoding", "()Ljava/lang/String;", "flushBuffer", "", "write", "c", "", "cbuf", "", "off", "len", "str", "append", "csq", "", "start", "end", "flush", "close", "core"})
public class OutputStreamWriter
extends Writer {
    @NotNull
    private final StreamEncoder se;

    public OutputStreamWriter(@NotNull OutputStream out, @NotNull Charset cs) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.se = StreamEncoder.Companion.forOutputStreamWriter(out, cs);
    }

    public OutputStreamWriter(@NotNull OutputStream out, @NotNull CharsetEncoder enc) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)enc, (String)"enc");
        this.se = StreamEncoder.Companion.forOutputStreamWriter(out, enc);
    }

    @Nullable
    public final String getEncoding() {
        return this.se.getEncoding();
    }

    public final void flushBuffer() throws IOException {
        this.se.flushBuffer();
    }

    @Override
    public void write(int c) throws IOException {
        this.se.write(c);
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.se.write(cbuf, off, len);
    }

    @Override
    public void write(@NotNull String str, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.se.write(str, off, len);
    }

    @Override
    @NotNull
    public Writer append(@Nullable CharSequence csq, int start, int end) {
        CharSequence csq2 = csq;
        if (csq2 == null) {
            csq2 = "null";
        }
        return this.append(csq2.subSequence(start, end));
    }

    @Override
    @NotNull
    public Writer append(@Nullable CharSequence csq) {
        if (csq instanceof CharBuffer) {
            this.se.write((CharBuffer)csq);
        } else {
            this.se.write(String.valueOf(csq));
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.se.flush();
    }

    @Override
    public void close() {
        this.se.close();
    }
}

