/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.Job;
import org.gnit.lucenekmp.jdkport.JavaLangAccess;
import org.gnit.lucenekmp.jdkport.SharedThreadContainerKt;
import org.gnit.lucenekmp.jdkport.ThreadContainer;
import org.gnit.lucenekmp.jdkport.ThreadContainers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001\u001aB\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bJ\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/jdkport/SharedThreadContainer;", "Lorg/gnit/lucenekmp/jdkport/ThreadContainer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "name", "", "<init>", "(Ljava/lang/String;)V", "parentRef", "virtualThreads", "", "Lkotlinx/coroutines/Job;", "key", "", "closed", "", "owner", "parent", "onStart", "", "thread", "onExit", "threads", "Lkotlin/sequences/Sequence;", "start", "close", "Companion", "core"})
public final class SharedThreadContainer
extends ThreadContainer
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private volatile ThreadContainer parentRef;
    @Nullable
    private volatile Set<Job> virtualThreads;
    @Nullable
    private volatile Object key;
    private volatile boolean closed;
    @NotNull
    private static final JavaLangAccess JLA = JavaLangAccess.INSTANCE;

    private SharedThreadContainer(String name) {
        super(true);
        this.name = name;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public Job owner() {
        return null;
    }

    @Override
    @Nullable
    public ThreadContainer parent() {
        return this.parentRef;
    }

    @Override
    public void onStart(@NotNull Job thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        if (SharedThreadContainerKt.isVirtual(thread)) {
            Set vthreads = this.virtualThreads;
            if (vthreads == null) {
                this.virtualThreads = vthreads = (Set)new LinkedHashSet();
            }
            vthreads.add((Job)thread);
        }
    }

    @Override
    public void onExit(@NotNull Job thread) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            if (!SharedThreadContainerKt.isVirtual(thread)) break block1;
            Set<Job> set = this.virtualThreads;
            if (set != null) {
                set.remove(thread);
            }
        }
    }

    @Override
    @NotNull
    public Sequence<Job> threads() {
        Sequence platformThreads = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])JLA.getAllThreads()), arg_0 -> SharedThreadContainer.threads$lambda$0(this, arg_0));
        Set<Job> vthreads = this.virtualThreads;
        return vthreads == null ? platformThreads : SequencesKt.plus((Sequence)platformThreads, (Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)vthreads), SharedThreadContainer::threads$lambda$1));
    }

    public final void start(@NotNull Job thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        if (!(!this.closed)) {
            throw new IllegalStateException("Check failed.");
        }
        JLA.start(thread, this);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            Object object = this.key;
            Intrinsics.checkNotNull((Object)object);
            ThreadContainers.INSTANCE.deregisterContainer(object);
        }
    }

    private static final boolean threads$lambda$0(SharedThreadContainer this$0, Job t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return JLA.threadContainer(t) == this$0;
    }

    private static final boolean threads$lambda$1(Job it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isActive();
    }

    public /* synthetic */ SharedThreadContainer(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/jdkport/SharedThreadContainer$Companion;", "", "<init>", "()V", "JLA", "Lorg/gnit/lucenekmp/jdkport/JavaLangAccess;", "create", "Lorg/gnit/lucenekmp/jdkport/SharedThreadContainer;", "parent", "Lorg/gnit/lucenekmp/jdkport/ThreadContainer;", "name", "", "core"})
    @SourceDebugExtension(value={"SMAP\nSharedThreadContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedThreadContainer.kt\norg/gnit/lucenekmp/jdkport/SharedThreadContainer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SharedThreadContainer create(@NotNull ThreadContainer parent, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (!(parent.owner() == null)) {
                boolean bl = false;
                String string = "parent has owner";
                throw new IllegalArgumentException(string.toString());
            }
            SharedThreadContainer container = new SharedThreadContainer(name, null);
            container.parentRef = parent;
            container.key = ThreadContainers.INSTANCE.registerContainer(container);
            return container;
        }

        @NotNull
        public final SharedThreadContainer create(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.create(ThreadContainers.INSTANCE.root(), name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

