/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0005\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u000eJ\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0096\u0002J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0016\u0010\u001b\u001a\u00060\u0001j\u0002`\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u001b\u001a\u00060\u0001j\u0002`\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0014\u0010\u001b\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\u001f\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010!J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0016J&\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\bJ\b\u0010,\u001a\u00020\u000bH\u0016J\u0011\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u0000H\u0096\u0002R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lorg/gnit/lucenekmp/jdkport/StringBuffer;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "", "", "<init>", "()V", "capacity", "", "(I)V", "str", "", "(Ljava/lang/String;)V", "seq", "(Ljava/lang/CharSequence;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "length", "getLength", "()I", "get", "", "index", "subSequence", "startIndex", "endIndex", "append", "csq", "start", "end", "c", "obj", "", "insert", "setCharAt", "", "ch", "getChars", "srcBegin", "srcEnd", "dst", "", "dstBegin", "toString", "compareTo", "other", "core"})
public final class StringBuffer
implements Appendable,
CharSequence,
Comparable<StringBuffer> {
    @NotNull
    private final StringBuilder builder;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int capacity) {
        this.builder = new StringBuilder();
    }

    public StringBuffer(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(str.length() + 16);
        this.builder.append(str);
    }

    public StringBuffer(@NotNull CharSequence seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        this(((Object)seq).toString());
    }

    public int getLength() {
        return this.builder.length();
    }

    public char get(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.length());
        }
        return this.builder.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex > this.length() || startIndex > endIndex) {
            throw new IndexOutOfBoundsException("Invalid subsequence range [" + startIndex + ", " + endIndex + ") for length " + this.length());
        }
        CharSequence charSequence = this.builder.subSequence(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
        return charSequence;
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence csq) {
        this.builder.append(csq);
        return this;
    }

    @Override
    @NotNull
    public Appendable append(@Nullable CharSequence csq, int start, int end) {
        this.builder.append(csq, start, end);
        return this;
    }

    @Override
    @NotNull
    public Appendable append(char c) {
        this.builder.append(c);
        return this;
    }

    @NotNull
    public final StringBuffer append(@Nullable Object obj) {
        this.builder.append(obj);
        return this;
    }

    @NotNull
    public final StringBuffer insert(int index, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.length());
        }
        this.builder.insert(index, str);
        return this;
    }

    public final void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.length());
        }
        this.builder.setCharAt(index, ch);
    }

    public final void getChars(int srcBegin, int srcEnd, @NotNull char[] dst, int dstBegin) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (srcBegin < 0 || srcEnd > this.length() || srcBegin > srcEnd) {
            throw new IndexOutOfBoundsException("Invalid source indices: srcBegin=" + srcBegin + ", srcEnd=" + srcEnd + ", length=" + this.length());
        }
        int count = srcEnd - srcBegin;
        if (dstBegin < 0 || dstBegin + count > dst.length) {
            throw new IndexOutOfBoundsException("Invalid destination indices: dstBegin=" + dstBegin + ", count=" + count + ", dst.size=" + dst.length);
        }
        for (int i = 0; i < count; ++i) {
            dst[dstBegin + i] = this.builder.charAt(srcBegin + i);
        }
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int compareTo(@NotNull StringBuffer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toString().compareTo(other.toString());
    }
}

