/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.ObjectsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002#$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0013J\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0013J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0013J\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/jdkport/Surrogate;", "", "<init>", "()V", "MIN_HIGH", "", "getMIN_HIGH", "()C", "MAX_HIGH", "getMAX_HIGH", "MIN_LOW", "getMIN_LOW", "MAX_LOW", "getMAX_LOW", "MIN", "getMIN", "MAX", "getMAX", "UCS4_MIN", "", "getUCS4_MIN", "()I", "UCS4_MAX", "getUCS4_MAX", "isHigh", "", "c", "isLow", "is", "neededFor", "uc", "high", "low", "toUCS4", "d", "Parser", "Generator", "core"})
public final class Surrogate {
    @NotNull
    public static final Surrogate INSTANCE = new Surrogate();
    private static final char MIN_HIGH = (char)55296;
    private static final char MAX_HIGH = (char)56319;
    private static final char MIN_LOW = (char)56320;
    private static final char MAX_LOW = (char)57343;
    private static final char MIN = (char)55296;
    private static final char MAX = (char)57343;
    private static final int UCS4_MIN = 65536;
    private static final int UCS4_MAX = 0x10FFFF;

    private Surrogate() {
    }

    public final char getMIN_HIGH() {
        return MIN_HIGH;
    }

    public final char getMAX_HIGH() {
        return MAX_HIGH;
    }

    public final char getMIN_LOW() {
        return MIN_LOW;
    }

    public final char getMAX_LOW() {
        return MAX_LOW;
    }

    public final char getMIN() {
        return MIN;
    }

    public final char getMAX() {
        return MAX;
    }

    public final int getUCS4_MIN() {
        return UCS4_MIN;
    }

    public final int getUCS4_MAX() {
        return UCS4_MAX;
    }

    public final boolean isHigh(int c) {
        return MIN_HIGH <= c && c <= MAX_HIGH;
    }

    public final boolean isLow(int c) {
        return MIN_LOW <= c && c <= MAX_LOW;
    }

    public final boolean is(int c) {
        return MIN <= c && c <= MAX;
    }

    public final boolean neededFor(int uc) {
        return Character.Companion.isSupplementaryCodePoint(uc);
    }

    public final char high(int uc) {
        if (!Character.Companion.isSupplementaryCodePoint(uc)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Character.Companion.highSurrogate(uc);
    }

    public final char low(int uc) {
        if (!Character.Companion.isSupplementaryCodePoint(uc)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Character.Companion.lowSurrogate(uc);
    }

    public final int toUCS4(char c, char d) {
        if (!(Character.Companion.isHighSurrogate(c) && ObjectsKt.isLowSurrogate(d))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Character.Companion.toCodePoint(c, d);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/jdkport/Surrogate$Generator;", "", "<init>", "()V", "error", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "generate", "", "uc", "len", "dst", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "da", "", "dp", "dl", "core"})
    public static final class Generator {
        @Nullable
        private CoderResult error = CoderResult.Companion.getOVERFLOW();

        @NotNull
        public final CoderResult error() {
            if (this.error == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            CoderResult coderResult = this.error;
            Intrinsics.checkNotNull((Object)coderResult);
            return coderResult;
        }

        public final int generate(int uc, int len, @NotNull CharBuffer dst) {
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            if (Character.Companion.isBmpCodePoint(uc)) {
                char c = (char)uc;
                if (CharsKt.isSurrogate((char)c)) {
                    this.error = CoderResult.Companion.malformedForLength(len);
                    return -1;
                }
                if (dst.remaining() < 1) {
                    this.error = CoderResult.Companion.getOVERFLOW();
                    return -1;
                }
                dst.put(c);
                this.error = null;
                return 1;
            }
            if (Character.Companion.isValidCodePoint(uc)) {
                if (dst.remaining() < 2) {
                    this.error = CoderResult.Companion.getOVERFLOW();
                    return -1;
                }
                dst.put(Character.Companion.highSurrogate(uc));
                dst.put(Character.Companion.lowSurrogate(uc));
                this.error = null;
                return 2;
            }
            this.error = CoderResult.Companion.unmappableForLength(len);
            return -1;
        }

        public final int generate(int uc, int len, @NotNull char[] da, int dp, int dl) {
            Intrinsics.checkNotNullParameter((Object)da, (String)"da");
            if (Character.Companion.isBmpCodePoint(uc)) {
                char c = (char)uc;
                if (CharsKt.isSurrogate((char)c)) {
                    this.error = CoderResult.Companion.malformedForLength(len);
                    return -1;
                }
                if (dl - dp < 1) {
                    this.error = CoderResult.Companion.getOVERFLOW();
                    return -1;
                }
                da[dp] = c;
                this.error = null;
                return 1;
            }
            if (Character.Companion.isValidCodePoint(uc)) {
                if (dl - dp < 2) {
                    this.error = CoderResult.Companion.getOVERFLOW();
                    return -1;
                }
                da[dp] = Character.Companion.highSurrogate(uc);
                da[dp + 1] = Character.Companion.lowSurrogate(uc);
                this.error = null;
                return 2;
            }
            this.error = CoderResult.Companion.unmappableForLength(len);
            return -1;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/jdkport/Surrogate$Parser;", "", "<init>", "()V", "character", "", "error", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "isPair", "", "increment", "unmappableResult", "parse", "c", "", "in", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "ia", "", "ip", "il", "core"})
    public static final class Parser {
        private int character;
        @Nullable
        private CoderResult error = CoderResult.Companion.getUNDERFLOW();
        private boolean isPair;

        public final int character() {
            if (!(this.error == null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.character;
        }

        public final boolean isPair() {
            if (!(this.error == null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.isPair;
        }

        public final int increment() {
            if (!(this.error == null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.isPair ? 2 : 1;
        }

        @NotNull
        public final CoderResult error() {
            if (this.error == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            CoderResult coderResult = this.error;
            Intrinsics.checkNotNull((Object)coderResult);
            return coderResult;
        }

        @NotNull
        public final CoderResult unmappableResult() {
            if (!(this.error == null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return CoderResult.Companion.unmappableForLength(this.isPair ? 2 : 1);
        }

        public final int parse(char c, @NotNull CharBuffer in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            if (Character.Companion.isHighSurrogate(c)) {
                if (!in.hasRemaining()) {
                    this.error = CoderResult.Companion.getUNDERFLOW();
                    return -1;
                }
                char d = in.get();
                if (ObjectsKt.isLowSurrogate(d)) {
                    this.character = Character.Companion.toCodePoint(c, d);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.Companion.malformedForLength(1);
                return -1;
            }
            if (ObjectsKt.isLowSurrogate(c)) {
                this.error = CoderResult.Companion.malformedForLength(1);
                return -1;
            }
            this.character = c;
            this.isPair = false;
            this.error = null;
            return this.character;
        }

        public final int parse(char c, @NotNull char[] ia, int ip, int il) {
            Intrinsics.checkNotNullParameter((Object)ia, (String)"ia");
            if (!(ia[ip] == c)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (Character.Companion.isHighSurrogate(c)) {
                if (il - ip < 2) {
                    this.error = CoderResult.Companion.getUNDERFLOW();
                    return -1;
                }
                char d = ia[ip + 1];
                if (ObjectsKt.isLowSurrogate(d)) {
                    this.character = Character.Companion.toCodePoint(c, d);
                    this.isPair = true;
                    this.error = null;
                    return this.character;
                }
                this.error = CoderResult.Companion.malformedForLength(1);
                return -1;
            }
            if (ObjectsKt.isLowSurrogate(c)) {
                this.error = CoderResult.Companion.malformedForLength(1);
                return -1;
            }
            this.character = c;
            this.isPair = false;
            this.error = null;
            return this.character;
        }
    }
}

