/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import dev.scottpierce.envvar.EnvVar;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.Job;
import org.gnit.lucenekmp.jdkport.JavaLangAccess;
import org.gnit.lucenekmp.jdkport.Reference;
import org.gnit.lucenekmp.jdkport.ReferenceQueue;
import org.gnit.lucenekmp.jdkport.StackableScope;
import org.gnit.lucenekmp.jdkport.ThreadContainer;
import org.gnit.lucenekmp.jdkport.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0001J\u0006\u0010\u0017\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\rJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0006\u0010\u0014\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/jdkport/ThreadContainers;", "", "<init>", "()V", "JLA", "Lorg/gnit/lucenekmp/jdkport/JavaLangAccess;", "TRACK_ALL_THREADS", "", "ROOT_CONTAINER", "Lorg/gnit/lucenekmp/jdkport/ThreadContainers$RootContainer;", "CONTAINER_REGISTRY", "", "Lorg/gnit/lucenekmp/jdkport/WeakReference;", "Lorg/gnit/lucenekmp/jdkport/ThreadContainer;", "QUEUE", "Lorg/gnit/lucenekmp/jdkport/ReferenceQueue;", "expungeStaleEntries", "", "trackAllThreads", "registerContainer", "container", "deregisterContainer", "key", "root", "parent", "children", "Lkotlin/sequences/Sequence;", "thread", "Lkotlinx/coroutines/Job;", "top", "next", "RootContainer", "core"})
@SourceDebugExtension(value={"SMAP\nThreadContainers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadContainers.kt\norg/gnit/lucenekmp/jdkport/ThreadContainers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,263:1\n1#2:264\n3#3,8:265\n10#4:273\n*S KotlinDebug\n*F\n+ 1 ThreadContainers.kt\norg/gnit/lucenekmp/jdkport/ThreadContainers\n*L\n68#1:265,8\n68#1:273\n*E\n"})
public final class ThreadContainers {
    @NotNull
    public static final ThreadContainers INSTANCE = new ThreadContainers();
    @NotNull
    private static final JavaLangAccess JLA = JavaLangAccess.INSTANCE;
    private static final boolean TRACK_ALL_THREADS;
    @NotNull
    private static final RootContainer ROOT_CONTAINER;
    @NotNull
    private static final Set<WeakReference<ThreadContainer>> CONTAINER_REGISTRY;
    @NotNull
    private static final ReferenceQueue<ThreadContainer> QUEUE;

    private ThreadContainers() {
    }

    private final void expungeStaleEntries() {
        Reference<ThreadContainer> key = null;
        while (true) {
            Object object = QUEUE.poll();
            Reference<ThreadContainer> it = object;
            boolean bl = false;
            key = it;
            if (object == null) break;
            object = CONTAINER_REGISTRY;
            Reference<ThreadContainer> reference = key;
            TypeIntrinsics.asMutableCollection((Object)object).remove(reference);
        }
    }

    public final boolean trackAllThreads() {
        return TRACK_ALL_THREADS;
    }

    @NotNull
    public final Object registerContainer(@Nullable ThreadContainer container) {
        this.expungeStaleEntries();
        WeakReference<ThreadContainer> ref = new WeakReference<ThreadContainer>(container, QUEUE);
        CONTAINER_REGISTRY.add(ref);
        return ref;
    }

    public final void deregisterContainer(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean condition$iv = key instanceof WeakReference;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        TypeIntrinsics.asMutableCollection((Object)CONTAINER_REGISTRY).remove(key);
    }

    @NotNull
    public final ThreadContainer root() {
        return ROOT_CONTAINER;
    }

    @Nullable
    public final ThreadContainer parent(@NotNull ThreadContainer container) {
        ThreadContainer root;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Job owner = container.owner();
        if (owner != null) {
            ThreadContainer threadContainer;
            ThreadContainer parent = null;
            parent = (ThreadContainer)container.enclosingScope(Reflection.getOrCreateKotlinClass(ThreadContainer.class));
            if (parent != null) {
                return parent;
            }
            ThreadContainer it = threadContainer = this.container(owner);
            boolean bl = false;
            parent = it;
            if (threadContainer != null) {
                return parent;
            }
        }
        return container != (root = this.root()) ? root : null;
    }

    @NotNull
    public final Sequence<ThreadContainer> children(@NotNull ThreadContainer container) {
        ThreadContainer next;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Sequence s1 = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CONTAINER_REGISTRY), ThreadContainers::children$lambda$2), arg_0 -> ThreadContainers.children$lambda$3(container, arg_0));
        Sequence s2 = SequencesKt.emptySequence();
        if (container.owner() != null && (next = this.next(container)) != null) {
            s2 = SequencesKt.sequenceOf((Object)next);
        }
        Sequence s3 = SequencesKt.mapNotNull(container.threads(), ThreadContainers::children$lambda$4);
        Object[] objectArray = new Sequence[]{s1, s2, s3};
        return SequencesKt.flatten((Sequence)SequencesKt.sequenceOf((Object[])objectArray));
    }

    @Nullable
    public final ThreadContainer container(@NotNull Job thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        if (thread.isActive() || thread.isCompleted()) {
            ThreadContainer container = JLA.threadContainer(thread);
            ThreadContainer threadContainer = container;
            if (threadContainer == null) {
                threadContainer = this.root();
            }
            return threadContainer;
        }
        throw new IllegalStateException("Thread not started");
    }

    private final ThreadContainer top(Job thread) {
        ThreadContainer top = null;
        for (StackableScope current = JLA.headStackableScope(thread); current != null; current = current.previous()) {
            if (!(current instanceof ThreadContainer)) continue;
            top = (ThreadContainer)current;
        }
        return top;
    }

    private final ThreadContainer next(ThreadContainer container) {
        StackableScope current = JLA.headStackableScope(container.owner());
        if (current != null) {
            ThreadContainer next = null;
            while (current != null) {
                if (current == container) {
                    return next;
                }
                if (current instanceof ThreadContainer) {
                    next = (ThreadContainer)current;
                }
                current = current.previous();
            }
        }
        return null;
    }

    private static final ThreadContainer children$lambda$2(WeakReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ThreadContainer)it.get();
    }

    private static final boolean children$lambda$3(ThreadContainer $container, ThreadContainer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.parent() == $container;
    }

    private static final ThreadContainer children$lambda$4(Job t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return INSTANCE.top(t);
    }

    static {
        CONTAINER_REGISTRY = new LinkedHashSet();
        QUEUE = new ReferenceQueue();
        String s = EnvVar.INSTANCE.get("jdk.trackAllThreads");
        if (s == null || ((CharSequence)s).length() == 0 || Boolean.parseBoolean(s)) {
            TRACK_ALL_THREADS = true;
            ROOT_CONTAINER = new RootContainer.TrackingRootContainer();
        } else {
            TRACK_ALL_THREADS = false;
            ROOT_CONTAINER = new RootContainer.CountingRootContainer();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0004\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/jdkport/ThreadContainers$RootContainer;", "Lorg/gnit/lucenekmp/jdkport/ThreadContainer;", "<init>", "()V", "parent", "name", "", "previous", "Lorg/gnit/lucenekmp/jdkport/StackableScope;", "toString", "platformThreads", "Lkotlin/sequences/Sequence;", "Lkotlinx/coroutines/Job;", "TrackingRootContainer", "CountingRootContainer", "core"})
    public static abstract class RootContainer
    extends ThreadContainer {
        public RootContainer() {
            super(true);
        }

        @Override
        @Nullable
        public ThreadContainer parent() {
            return null;
        }

        @Override
        @NotNull
        public String name() {
            return "<root>";
        }

        @Override
        @Nullable
        public StackableScope previous() {
            return null;
        }

        @Override
        @NotNull
        public String toString() {
            return this.name();
        }

        @NotNull
        protected final Sequence<Job> platformThreads() {
            return SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])JLA.getAllThreads()), RootContainer::platformThreads$lambda$0);
        }

        private static final boolean platformThreads$lambda$0(Job t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return JLA.threadContainer(t) == null;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/jdkport/ThreadContainers$RootContainer$CountingRootContainer;", "Lorg/gnit/lucenekmp/jdkport/ThreadContainers$RootContainer;", "<init>", "()V", "onStart", "", "thread", "Lkotlinx/coroutines/Job;", "onExit", "threadCount", "", "threads", "Lkotlin/sequences/Sequence;", "Companion", "core"})
        public static final class CountingRootContainer
        extends RootContainer {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final AtomicLong VTHREAD_COUNT = new AtomicLong(0L);

            @Override
            public void onStart(@NotNull Job thread) {
                Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
                VTHREAD_COUNT.addAndGet(1L);
            }

            @Override
            public void onExit(@NotNull Job thread) {
                Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
                VTHREAD_COUNT.addAndGet(-1L);
            }

            @Override
            public long threadCount() {
                return (long)SequencesKt.count(this.platformThreads()) + VTHREAD_COUNT.get();
            }

            @Override
            @NotNull
            public Sequence<Job> threads() {
                return this.platformThreads();
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/jdkport/ThreadContainers$RootContainer$CountingRootContainer$Companion;", "", "<init>", "()V", "VTHREAD_COUNT", "Lkotlin/concurrent/atomics/AtomicLong;", "getVTHREAD_COUNT$annotations", "Ljava/util/concurrent/atomic/AtomicLong;", "core"})
            public static final class Companion {
                private Companion() {
                }

                private static /* synthetic */ void getVTHREAD_COUNT$annotations() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/jdkport/ThreadContainers$RootContainer$TrackingRootContainer;", "Lorg/gnit/lucenekmp/jdkport/ThreadContainers$RootContainer;", "<init>", "()V", "onStart", "", "thread", "Lkotlinx/coroutines/Job;", "onExit", "threadCount", "", "threads", "Lkotlin/sequences/Sequence;", "Companion", "core"})
        public static final class TrackingRootContainer
        extends RootContainer {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final Set<Job> VTHREADS = new LinkedHashSet();

            @Override
            public void onStart(@NotNull Job thread) {
                Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
                VTHREADS.add(thread);
            }

            @Override
            public void onExit(@NotNull Job thread) {
                Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
                VTHREADS.remove(thread);
            }

            @Override
            public long threadCount() {
                return SequencesKt.count(this.platformThreads()) + VTHREADS.size();
            }

            @Override
            @NotNull
            public Sequence<Job> threads() {
                return SequencesKt.plus(this.platformThreads(), (Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)VTHREADS), TrackingRootContainer::threads$lambda$0));
            }

            private static final boolean threads$lambda$0(Job it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isActive();
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/jdkport/ThreadContainers$RootContainer$TrackingRootContainer$Companion;", "", "<init>", "()V", "VTHREADS", "", "Lkotlinx/coroutines/Job;", "core"})
            public static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

