/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetDecoder;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.ObjectsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/jdkport/UnicodeDecoder;", "Lorg/gnit/lucenekmp/jdkport/CharsetDecoder;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "currentByteOrder", "", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Charset;I)V", "bo", "defaultBO", "(Lorg/gnit/lucenekmp/jdkport/Charset;II)V", "expectedByteOrder", "defaultByteOrder", "decode", "", "b1", "b2", "decodeLoop", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "src", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "dst", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "implReset", "", "Companion", "core"})
public abstract class UnicodeDecoder
extends CharsetDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int currentByteOrder;
    private final int expectedByteOrder;
    private int defaultByteOrder;
    private static final char BYTE_ORDER_MARK = (char)65279;
    private static final char REVERSED_MARK = (char)65534;
    protected static final int NONE = 0;
    protected static final int BIG = 1;
    protected static final int LITTLE = 2;

    public UnicodeDecoder(@NotNull Charset cs, int currentByteOrder) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(cs, 0.5f, 1.0f);
        this.currentByteOrder = currentByteOrder;
        this.defaultByteOrder = 1;
        this.expectedByteOrder = this.currentByteOrder;
    }

    public UnicodeDecoder(@NotNull Charset cs, int bo, int defaultBO) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this(cs, bo);
        this.defaultByteOrder = defaultBO;
    }

    private final char decode(int b1, int b2) {
        if (this.currentByteOrder == 1) {
            return (char)(b1 << 8 | b2);
        }
        return (char)(b2 << 8 | b1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected CoderResult decodeLoop(@NotNull ByteBuffer src, @NotNull CharBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int mark = src.getPosition();
        try {
            while (src.remaining() > 1) {
                char c;
                int b1 = src.get() & 0xFF;
                int b2 = src.get() & 0xFF;
                if (this.currentByteOrder == 0) {
                    c = (char)(b1 << 8 | b2);
                    if (c == BYTE_ORDER_MARK) {
                        this.currentByteOrder = 1;
                        mark += 2;
                        continue;
                    }
                    if (c == REVERSED_MARK) {
                        this.currentByteOrder = 2;
                        mark += 2;
                        continue;
                    }
                    this.currentByteOrder = this.defaultByteOrder;
                }
                if (CharsKt.isSurrogate((char)(c = this.decode(b1, b2)))) {
                    if (Character.Companion.isHighSurrogate(c)) {
                        if (src.remaining() < 2) {
                            CoderResult coderResult = CoderResult.Companion.getUNDERFLOW();
                            return coderResult;
                        }
                        char c2 = this.decode(src.get() & 0xFF, src.get() & 0xFF);
                        if (!ObjectsKt.isLowSurrogate(c2)) {
                            CoderResult coderResult = CoderResult.Companion.malformedForLength(4);
                            return coderResult;
                        }
                        if (dst.remaining() < 2) {
                            CoderResult coderResult = CoderResult.Companion.getOVERFLOW();
                            return coderResult;
                        }
                        mark += 4;
                        dst.put(c);
                        dst.put(c2);
                        continue;
                    }
                    CoderResult coderResult = CoderResult.Companion.malformedForLength(2);
                    return coderResult;
                }
                if (!dst.hasRemaining()) {
                    CoderResult coderResult = CoderResult.Companion.getOVERFLOW();
                    return coderResult;
                }
                mark += 2;
                dst.put(c);
            }
            CoderResult coderResult = CoderResult.Companion.getUNDERFLOW();
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    @Override
    protected void implReset() {
        this.currentByteOrder = this.expectedByteOrder;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/jdkport/UnicodeDecoder$Companion;", "", "<init>", "()V", "BYTE_ORDER_MARK", "", "getBYTE_ORDER_MARK", "()C", "REVERSED_MARK", "getREVERSED_MARK", "NONE", "", "BIG", "LITTLE", "core"})
    public static final class Companion {
        private Companion() {
        }

        protected final char getBYTE_ORDER_MARK() {
            return BYTE_ORDER_MARK;
        }

        protected final char getREVERSED_MARK() {
            return REVERSED_MARK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

