/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.jdkport.ByteBuffer;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.Charset;
import org.gnit.lucenekmp.jdkport.CharsetEncoder;
import org.gnit.lucenekmp.jdkport.CoderResult;
import org.gnit.lucenekmp.jdkport.Surrogate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0018\u001a\u00020\rH\u0014J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/jdkport/UnicodeEncoder;", "Lorg/gnit/lucenekmp/jdkport/CharsetEncoder;", "cs", "Lorg/gnit/lucenekmp/jdkport/Charset;", "bo", "", "needsMark", "", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Charset;IZ)V", "byteOrder", "usesMark", "put", "", "c", "", "dst", "Lorg/gnit/lucenekmp/jdkport/ByteBuffer;", "sgp", "Lorg/gnit/lucenekmp/jdkport/Surrogate$Parser;", "encodeLoop", "Lorg/gnit/lucenekmp/jdkport/CoderResult;", "src", "Lorg/gnit/lucenekmp/jdkport/CharBuffer;", "implReset", "canEncode", "Companion", "core"})
public abstract class UnicodeEncoder
extends CharsetEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean needsMark;
    private final int byteOrder;
    private final boolean usesMark;
    @NotNull
    private final Surrogate.Parser sgp;
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int BIG = 0;
    protected static final int LITTLE = 1;

    protected UnicodeEncoder(@NotNull Charset cs, int bo, boolean needsMark) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        float f = needsMark ? 4.0f : 2.0f;
        if (bo == 0) {
            byte[] byArray2 = new byte[]{-1, -3};
            byArray = byArray2;
        } else {
            byte[] byArray3 = new byte[]{-3, -1};
            byArray = byArray3;
        }
        super(cs, 2.0f, f, byArray);
        this.needsMark = needsMark;
        this.sgp = new Surrogate.Parser();
        this.usesMark = this.needsMark;
        this.byteOrder = bo;
    }

    private final void put(char c, ByteBuffer dst) {
        if (this.byteOrder == 0) {
            dst.put((byte)(c >> 8));
            v0 = dst.put((byte)(c & 0xFF));
        } else {
            dst.put((byte)(c & 0xFF));
            v0 = dst.put((byte)(c >> 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected CoderResult encodeLoop(@NotNull CharBuffer src, @NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int mark = src.position();
        if (this.needsMark && src.hasRemaining()) {
            if (dst.remaining() < 2) {
                return CoderResult.Companion.getOVERFLOW();
            }
            this.put('\ufeff', dst);
            this.needsMark = false;
        }
        try {
            while (src.hasRemaining()) {
                char c = src.get();
                if (!CharsKt.isSurrogate((char)c)) {
                    if (dst.remaining() < 2) {
                        CoderResult coderResult = CoderResult.Companion.getOVERFLOW();
                        return coderResult;
                    }
                    ++mark;
                    this.put(c, dst);
                    continue;
                }
                int d = this.sgp.parse(c, src);
                if (d < 0) {
                    CoderResult coderResult = this.sgp.error();
                    Intrinsics.checkNotNull((Object)coderResult);
                    CoderResult coderResult2 = coderResult;
                    return coderResult2;
                }
                if (dst.remaining() < 4) {
                    CoderResult coderResult = CoderResult.Companion.getOVERFLOW();
                    return coderResult;
                }
                mark += 2;
                this.put(Character.Companion.highSurrogate(d), dst);
                this.put(Character.Companion.lowSurrogate(d), dst);
            }
            CoderResult coderResult = CoderResult.Companion.getUNDERFLOW();
            return coderResult;
        }
        finally {
            src.setPosition(mark);
        }
    }

    @Override
    protected void implReset() {
        this.needsMark = this.usesMark;
    }

    @Override
    public boolean canEncode(char c) {
        return !CharsKt.isSurrogate((char)c);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/jdkport/UnicodeEncoder$Companion;", "", "<init>", "()V", "BYTE_ORDER_MARK", "", "REVERSED_MARK", "BIG", "", "LITTLE", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

