/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.jdkport;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Flushable;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.Ported;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Ported(from="java.io.Writer")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\b'\u0018\u0000 \u001b2\u00060\u0001j\u0002`\u00022\u00060\u0003j\u0002`\u00042\u00020\u0005:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0012\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\"\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000bH&J\b\u0010\u001a\u001a\u00020\u000bH&R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/jdkport/Writer;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lorg/gnit/lucenekmp/jdkport/Flushable;", "<init>", "()V", "writeBuffer", "", "write", "", "c", "", "cbuf", "off", "len", "str", "", "append", "csq", "", "start", "end", "", "flush", "close", "Companion", "core"})
public abstract class Writer
implements Appendable,
AutoCloseable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private char[] writeBuffer;
    private static final int WRITE_BUFFER_SIZE = 1024;

    public void write(int c) throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = new char[1024];
        }
        Intrinsics.checkNotNull((Object)this.writeBuffer);
        this.writeBuffer[0] = (char)c;
        Intrinsics.checkNotNull((Object)this.writeBuffer);
        this.write(this.writeBuffer, 0, 1);
    }

    public void write(@NotNull char[] cbuf) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.write(cbuf, 0, cbuf.length);
    }

    public abstract void write(@NotNull char[] var1, int var2, int var3) throws IOException;

    public void write(@NotNull String str) throws IOException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.write(str, 0, str.length());
    }

    public void write(@NotNull String str, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        char[] cbuf = null;
        if (len <= 1024) {
            if (this.writeBuffer == null) {
                this.writeBuffer = new char[1024];
            }
            cbuf = this.writeBuffer;
        } else {
            cbuf = new char[len];
        }
        String string = str;
        Intrinsics.checkNotNull((Object)cbuf);
        char[] cArray = cbuf;
        int n = 0;
        int n2 = off + len;
        string.getChars(off, n2, cArray, n);
        this.write(cbuf, 0, len);
    }

    @Override
    @NotNull
    public Writer append(@Nullable CharSequence csq) {
        this.write(String.valueOf(csq));
        return this;
    }

    @Override
    @NotNull
    public Writer append(@Nullable CharSequence csq, int start, int end) {
        CharSequence csq2 = csq;
        if (csq2 == null) {
            csq2 = "null";
        }
        return this.append(csq2.subSequence(start, end));
    }

    @Override
    @NotNull
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/jdkport/Writer$Companion;", "", "<init>", "()V", "WRITE_BUFFER_SIZE", "", "nullWriter", "Lorg/gnit/lucenekmp/jdkport/Writer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Writer nullWriter() {
            return new Writer(){
                private volatile boolean closed;

                public final void ensureOpen() throws IOException {
                    if (this.closed) {
                        throw new IOException("Stream closed");
                    }
                }

                public Writer append(char c) throws IOException {
                    this.ensureOpen();
                    return this;
                }

                public Writer append(CharSequence csq) throws IOException {
                    this.ensureOpen();
                    return this;
                }

                public Writer append(CharSequence csq, int start, int end) throws IOException {
                    this.ensureOpen();
                    if (csq != null) {
                        Objects.INSTANCE.checkFromToIndex(start, end, csq.length());
                    }
                    return this;
                }

                public void write(int c) throws IOException {
                    this.ensureOpen();
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
                    Objects.INSTANCE.checkFromIndexSize(off, len, cbuf.length);
                    this.ensureOpen();
                }

                public void write(String str) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                    this.ensureOpen();
                }

                public void write(String str, int off, int len) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                    Objects.INSTANCE.checkFromIndexSize(off, len, str.length());
                    this.ensureOpen();
                }

                public void flush() throws IOException {
                    this.ensureOpen();
                }

                public void close() throws IOException {
                    this.closed = true;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

