/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.QueryTimeout;
import org.gnit.lucenekmp.jdkport.Callable;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.AbstractKnnVectorQuery;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.ConjunctionDISI;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.FieldExistsQuery;
import org.gnit.lucenekmp.search.FilteredDocIdSetIterator;
import org.gnit.lucenekmp.search.HitQueue;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.TaskExecutor;
import org.gnit.lucenekmp.search.TimeLimitingKnnCollectorManager;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopDocsCollector;
import org.gnit.lucenekmp.search.TotalHits;
import org.gnit.lucenekmp.search.VectorScorer;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.search.knn.KnnCollectorManager;
import org.gnit.lucenekmp.search.knn.KnnSearchStrategy;
import org.gnit.lucenekmp.search.knn.TopKnnCollectorManager;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u0000 H2\u00020\u0001:\u0002GHB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0015H\u0004J(\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020'H$J\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010*\u001a\u00020\u00192\u0006\u00100\u001a\u000201H&J\"\u00102\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u00192\u0006\u00103\u001a\u00020\"2\b\u00104\u001a\u0004\u0018\u000105H\u0004J\u001b\u00106\u001a\u00020\u00172\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001708H\u0004\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0017H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\u0013\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0096\u0002J\b\u0010F\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006I"}, d2={"Lorg/gnit/lucenekmp/search/AbstractKnnVectorQuery;", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "k", "", "filter", "searchStrategy", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "<init>", "(Ljava/lang/String;ILorg/gnit/lucenekmp/search/Query;Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;)V", "getField", "()Ljava/lang/String;", "getK", "()I", "getFilter", "()Lorg/gnit/lucenekmp/search/Query;", "getSearchStrategy", "()Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "searchLeaf", "Lorg/gnit/lucenekmp/search/TopDocs;", "ctx", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "filterWeight", "Lorg/gnit/lucenekmp/search/Weight;", "timeLimitingKnnCollectorManager", "Lorg/gnit/lucenekmp/search/TimeLimitingKnnCollectorManager;", "getLeafResults", "createBitSet", "Lorg/gnit/lucenekmp/util/BitSet;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "maxDoc", "getKnnCollectorManager", "Lorg/gnit/lucenekmp/search/knn/KnnCollectorManager;", "searcher", "approximateSearch", "context", "acceptDocs", "visitedLimit", "knnCollectorManager", "createVectorScorer", "Lorg/gnit/lucenekmp/search/VectorScorer;", "fi", "Lorg/gnit/lucenekmp/index/FieldInfo;", "exactSearch", "acceptIterator", "queryTimeout", "Lorg/gnit/lucenekmp/index/QueryTimeout;", "mergeLeafResults", "perLeafResults", "", "([Lorg/gnit/lucenekmp/search/TopDocs;)Lorg/gnit/lucenekmp/search/TopDocs;", "createRewrittenQuery", "reader", "Lorg/gnit/lucenekmp/index/IndexReader;", "topK", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "equals", "", "o", "", "hashCode", "DocAndScoreQuery", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nAbstractKnnVectorQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKnnVectorQuery.kt\norg/gnit/lucenekmp/search/AbstractKnnVectorQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,455:1\n1#2:456\n37#3:457\n36#3,3:458\n6181#4,2:461\n*S KotlinDebug\n*F\n+ 1 AbstractKnnVectorQuery.kt\norg/gnit/lucenekmp/search/AbstractKnnVectorQuery\n*L\n89#1:457\n89#1:458,3\n269#1:461,2\n*E\n"})
public abstract class AbstractKnnVectorQuery
extends Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    private final int k;
    @Nullable
    private final Query filter;
    @NotNull
    private final KnnSearchStrategy searchStrategy;
    @NotNull
    private static final TopDocs NO_RESULTS = TopDocsCollector.Companion.getEMPTY_TOPDOCS();

    public AbstractKnnVectorQuery(@NotNull String field, int k, @Nullable Query filter, @NotNull KnnSearchStrategy searchStrategy) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)searchStrategy, (String)"searchStrategy");
        this.field = field;
        this.k = k;
        this.filter = filter;
        this.searchStrategy = searchStrategy;
        if (!(this.k >= 1)) {
            boolean bl = false;
            String string = "k must be at least 1, got: " + this.k;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    public final int getK() {
        return this.k;
    }

    @Nullable
    public final Query getFilter() {
        return this.filter;
    }

    @NotNull
    protected final KnnSearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        IndexReader reader2 = indexSearcher.getIndexReader();
        Weight filterWeight = null;
        if (this.filter != null) {
            BooleanQuery booleanQuery = new BooleanQuery.Builder().add(this.filter, BooleanClause.Occur.FILTER).add(new FieldExistsQuery(this.field), BooleanClause.Occur.FILTER).build();
            Query rewritten = indexSearcher.rewrite(booleanQuery);
            filterWeight = indexSearcher.createWeight(rewritten, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        } else {
            filterWeight = null;
        }
        TimeLimitingKnnCollectorManager knnCollectorManager = new TimeLimitingKnnCollectorManager(this.getKnnCollectorManager(this.k, indexSearcher), indexSearcher.getTimeout());
        TaskExecutor taskExecutor = indexSearcher.getTaskExecutor();
        List<LeafReaderContext> leafReaderContexts = reader2.leaves();
        List tasks = new ArrayList(leafReaderContexts.size());
        for (LeafReaderContext context : leafReaderContexts) {
            tasks.add(new Callable<TopDocs>(this, context, filterWeight, knnCollectorManager){
                final /* synthetic */ AbstractKnnVectorQuery this$0;
                final /* synthetic */ LeafReaderContext $context;
                final /* synthetic */ Weight $filterWeight;
                final /* synthetic */ TimeLimitingKnnCollectorManager $knnCollectorManager;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$filterWeight = $filterWeight;
                    this.$knnCollectorManager = $knnCollectorManager;
                }

                public TopDocs call() {
                    return AbstractKnnVectorQuery.access$searchLeaf(this.this$0, this.$context, this.$filterWeight, this.$knnCollectorManager);
                }
            });
        }
        Collection $this$toTypedArray$iv = (Collection)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<TopDocs>>, Object>(taskExecutor, (List<Callable<TopDocs>>)tasks, null){
            int label;
            final /* synthetic */ TaskExecutor $taskExecutor;
            final /* synthetic */ List<Callable<TopDocs>> $tasks;
            {
                this.$taskExecutor = $taskExecutor;
                this.$tasks = $tasks;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$taskExecutor.invokeAll((Collection)this.$tasks, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<TopDocs>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TopDocs[] perLeafResults2 = thisCollection$iv.toArray(new TopDocs[0]);
        TopDocs topK = this.mergeLeafResults(perLeafResults2);
        ScoreDoc[] scoreDocArray = topK.getScoreDocs();
        Intrinsics.checkNotNull((Object)scoreDocArray);
        if (scoreDocArray.length == 0) {
            return new MatchNoDocsQuery(null, 1, null);
        }
        return this.createRewrittenQuery(reader2, topK);
    }

    private final TopDocs searchLeaf(LeafReaderContext ctx, Weight filterWeight, TimeLimitingKnnCollectorManager timeLimitingKnnCollectorManager) throws IOException {
        TopDocs results2 = this.getLeafResults(ctx, filterWeight, timeLimitingKnnCollectorManager);
        if (ctx.getDocBase() > 0) {
            ScoreDoc[] scoreDocArray = results2.getScoreDocs();
            Intrinsics.checkNotNull((Object)scoreDocArray);
            for (ScoreDoc scoreDoc : scoreDocArray) {
                scoreDoc.setDoc(scoreDoc.getDoc() + ctx.getDocBase());
            }
        }
        return results2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final TopDocs getLeafResults(LeafReaderContext ctx, Weight filterWeight, TimeLimitingKnnCollectorManager timeLimitingKnnCollectorManager) throws IOException {
        TopDocs topDocs;
        QueryTimeout queryTimeout;
        int cost;
        BitSet acceptDocs;
        block8: {
            TopDocs results2;
            block7: {
                block6: {
                    LeafReader reader2 = ctx.reader();
                    Bits bits = reader2.getLiveDocs();
                    Intrinsics.checkNotNull((Object)bits);
                    Bits liveDocs2 = bits;
                    if (filterWeight == null) {
                        return this.approximateSearch(ctx, liveDocs2, Integer.MAX_VALUE, timeLimitingKnnCollectorManager);
                    }
                    Scorer scorer2 = filterWeight.scorer(ctx);
                    if (scorer2 == null) {
                        return NO_RESULTS;
                    }
                    acceptDocs = this.createBitSet(scorer2.iterator(), liveDocs2, reader2.maxDoc());
                    cost = acceptDocs.cardinality();
                    queryTimeout = timeLimitingKnnCollectorManager.getQueryTimeout();
                    if (cost <= this.k) {
                        DocIdSetIterator docIdSetIterator = new BitSetIterator(acceptDocs, cost);
                        QueryTimeout queryTimeout2 = queryTimeout;
                        Intrinsics.checkNotNull((Object)queryTimeout2);
                        return this.exactSearch(ctx, docIdSetIterator, queryTimeout2);
                    }
                    results2 = this.approximateSearch(ctx, acceptDocs, cost + 1, timeLimitingKnnCollectorManager);
                    if (results2.getTotalHits().getRelation() != TotalHits.Relation.EQUAL_TO) break block6;
                    ScoreDoc[] scoreDocArray = results2.getScoreDocs();
                    Intrinsics.checkNotNull((Object)scoreDocArray);
                    if (scoreDocArray.length >= this.k) break block7;
                }
                if (queryTimeout == null || !queryTimeout.shouldExit()) break block8;
            }
            topDocs = results2;
            return topDocs;
        }
        DocIdSetIterator docIdSetIterator = new BitSetIterator(acceptDocs, cost);
        QueryTimeout queryTimeout3 = queryTimeout;
        Intrinsics.checkNotNull((Object)queryTimeout3);
        topDocs = this.exactSearch(ctx, docIdSetIterator, queryTimeout3);
        return topDocs;
    }

    private final BitSet createBitSet(DocIdSetIterator iterator2, Bits liveDocs2, int maxDoc) throws IOException {
        if (liveDocs2 == null && iterator2 instanceof BitSetIterator) {
            return ((BitSetIterator)iterator2).getBitSet();
        }
        FilteredDocIdSetIterator filterIterator2 = new FilteredDocIdSetIterator(iterator2, liveDocs2){
            final /* synthetic */ Bits $liveDocs;
            {
                this.$liveDocs = $liveDocs;
                super($iterator);
            }

            protected boolean match(int doc) {
                return this.$liveDocs == null || this.$liveDocs.get(doc);
            }
        };
        return BitSet.Companion.of(filterIterator2, maxDoc);
    }

    @NotNull
    protected final KnnCollectorManager getKnnCollectorManager(int k, @NotNull IndexSearcher searcher) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        return new TopKnnCollectorManager(k, searcher);
    }

    @NotNull
    protected abstract TopDocs approximateSearch(@NotNull LeafReaderContext var1, @NotNull Bits var2, int var3, @NotNull KnnCollectorManager var4) throws IOException;

    @Nullable
    public abstract VectorScorer createVectorScorer(@NotNull LeafReaderContext var1, @NotNull FieldInfo var2) throws IOException;

    @NotNull
    protected final TopDocs exactSearch(@NotNull LeafReaderContext context, @NotNull DocIdSetIterator acceptIterator, @Nullable QueryTimeout queryTimeout) throws IOException {
        ScoreDoc[] topScoreDocs;
        int it2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)acceptIterator, (String)"acceptIterator");
        FieldInfo fi = context.reader().getFieldInfos().fieldInfo(this.field);
        if (fi == null || fi.getVectorDimension() == 0) {
            return NO_RESULTS;
        }
        VectorScorer vectorScorer = this.createVectorScorer(context, fi);
        if (vectorScorer == null) {
            return NO_RESULTS;
        }
        int queueSize = java.lang.Math.min(this.k, Math.INSTANCE.toIntExact(acceptIterator.cost()));
        HitQueue queue2 = new HitQueue(queueSize, true);
        TotalHits.Relation relation = TotalHits.Relation.EQUAL_TO;
        Object t = queue2.top();
        Intrinsics.checkNotNull(t);
        ScoreDoc topDoc = (ScoreDoc)t;
        DocIdSetIterator vectorIterator = vectorScorer.iterator();
        Object[] objectArray = new DocIdSetIterator[]{vectorIterator, acceptIterator};
        DocIdSetIterator conjunction = ConjunctionDISI.Companion.createConjunction(CollectionsKt.mutableListOf((Object[])objectArray), new ArrayList());
        int doc = 0;
        while (true) {
            int n;
            it2 = n = conjunction.nextDoc();
            boolean bl = false;
            doc = it2;
            if (n == Integer.MAX_VALUE) break;
            if (queryTimeout != null && queryTimeout.shouldExit()) {
                relation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                break;
            }
            if (!(vectorIterator.docID() == doc)) {
                String it2 = "Failed requirement.";
                throw new IllegalArgumentException(it2.toString());
            }
            float score2 = vectorScorer.score();
            if (!(score2 > topDoc.getScore())) continue;
            topDoc.setScore(score2);
            topDoc.setDoc(doc);
            Object t2 = queue2.updateTop();
            Intrinsics.checkNotNull(t2);
            topDoc = (ScoreDoc)t2;
        }
        while (queue2.size() > 0) {
            Object t3 = queue2.top();
            Intrinsics.checkNotNull(t3);
            if (!(((ScoreDoc)t3).getScore() < 0.0f)) break;
            queue2.pop();
        }
        if (0 <= (it2 = (topScoreDocs = new ScoreDoc[queue2.size()]).length + -1)) {
            do {
                int i = it2--;
                topScoreDocs[i] = queue2.pop();
            } while (0 <= it2);
        }
        TotalHits totalHits = new TotalHits(acceptIterator.cost(), relation);
        return new TopDocs(totalHits, topScoreDocs);
    }

    @NotNull
    protected final TopDocs mergeLeafResults(@NotNull TopDocs[] perLeafResults2) {
        Intrinsics.checkNotNullParameter((Object)perLeafResults2, (String)"perLeafResults");
        return TopDocs.Companion.merge(this.k, perLeafResults2);
    }

    private final Query createRewrittenQuery(IndexReader reader2, TopDocs topK) {
        ScoreDoc[] scoreDocArray = topK.getScoreDocs();
        Intrinsics.checkNotNull((Object)scoreDocArray);
        int len = scoreDocArray.length;
        if (!(len > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ScoreDoc[] scoreDocArray2 = topK.getScoreDocs();
        Intrinsics.checkNotNull((Object)scoreDocArray2);
        float maxScore = scoreDocArray2[0].getScore();
        Object[] objectArray = topK.getScoreDocs();
        if (objectArray != null) {
            Object[] $this$sortBy$iv = objectArray;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.length > 1) {
                ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ScoreDoc it = (ScoreDoc)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getDoc());
                        it = (ScoreDoc)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getDoc()));
                    }
                });
            }
        }
        int[] docs = new int[len];
        float[] scores = new float[len];
        for (int i = 0; i < len; ++i) {
            ScoreDoc[] scoreDocArray3 = topK.getScoreDocs();
            Intrinsics.checkNotNull((Object)scoreDocArray3);
            docs[i] = scoreDocArray3[i].getDoc();
            ScoreDoc[] scoreDocArray4 = topK.getScoreDocs();
            Intrinsics.checkNotNull((Object)scoreDocArray4);
            scores[i] = scoreDocArray4[i].getScore();
        }
        int[] segmentStarts = Companion.findSegmentStarts(reader2.leaves(), docs);
        return new DocAndScoreQuery(docs, scores, maxScore, segmentStarts, reader2.getContext().id());
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.field)) {
            visitor2.visitLeaf(this);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractKnnVectorQuery that = (AbstractKnnVectorQuery)o;
        return this.k == that.k && Intrinsics.areEqual((Object)this.field, (Object)that.field) && Intrinsics.areEqual((Object)this.filter, (Object)that.filter) && Intrinsics.areEqual((Object)this.searchStrategy, (Object)that.searchStrategy);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.field, this.k, this.filter};
        return Objects.INSTANCE.hash(objectArray);
    }

    public static final /* synthetic */ TopDocs access$searchLeaf(AbstractKnnVectorQuery $this, LeafReaderContext ctx, Weight filterWeight, TimeLimitingKnnCollectorManager timeLimitingKnnCollectorManager) {
        return $this.searchLeaf(ctx, filterWeight, timeLimitingKnnCollectorManager);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/AbstractKnnVectorQuery$Companion;", "", "<init>", "()V", "NO_RESULTS", "Lorg/gnit/lucenekmp/search/TopDocs;", "findSegmentStarts", "", "leaves", "", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "docs", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] findSegmentStarts(@NotNull List<LeafReaderContext> leaves, @NotNull int[] docs) {
            Intrinsics.checkNotNullParameter(leaves, (String)"leaves");
            Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
            int[] starts = new int[leaves.size() + 1];
            starts[starts.length - 1] = docs.length;
            if (starts.length == 2) {
                return starts;
            }
            int resultIndex = 0;
            int n = starts.length - 1;
            for (int i = 1; i < n; ++i) {
                int upper = leaves.get(i).getDocBase();
                if ((resultIndex = org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.binarySearch(docs, resultIndex, docs.length, upper)) < 0) {
                    resultIndex = -1 - resultIndex;
                }
                starts[i] = resultIndex;
            }
            return starts;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/search/AbstractKnnVectorQuery$DocAndScoreQuery;", "Lorg/gnit/lucenekmp/search/Query;", "docs", "", "scores", "", "maxScore", "", "segmentStarts", "contextIdentity", "", "<init>", "([I[FF[ILjava/lang/Object;)V", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "toString", "", "field", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "equals", "", "obj", "hashCode", "", "core"})
    public static final class DocAndScoreQuery
    extends Query {
        @NotNull
        private final int[] docs;
        @NotNull
        private final float[] scores;
        private final float maxScore;
        @NotNull
        private final int[] segmentStarts;
        @NotNull
        private final Object contextIdentity;

        public DocAndScoreQuery(@NotNull int[] docs, @NotNull float[] scores, float maxScore, @NotNull int[] segmentStarts, @NotNull Object contextIdentity) {
            Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
            Intrinsics.checkNotNullParameter((Object)scores, (String)"scores");
            Intrinsics.checkNotNullParameter((Object)segmentStarts, (String)"segmentStarts");
            Intrinsics.checkNotNullParameter((Object)contextIdentity, (String)"contextIdentity");
            this.docs = docs;
            this.scores = scores;
            this.maxScore = maxScore;
            this.segmentStarts = segmentStarts;
            this.contextIdentity = contextIdentity;
        }

        @Override
        @NotNull
        public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
            if (!(searcher.getIndexReader().getContext().id() == this.contextIdentity)) {
                boolean bl = false;
                String string = "This DocAndScore query was created by a different reader";
                throw new IllegalStateException(string.toString());
            }
            return new Weight(this, boost){
                final /* synthetic */ DocAndScoreQuery this$0;
                final /* synthetic */ float $boost;
                {
                    this.this$0 = $receiver;
                    this.$boost = $boost;
                    super($receiver);
                }

                public Explanation explain(LeafReaderContext context, int doc) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    int found = org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.binarySearch(DocAndScoreQuery.access$getDocs$p(this.this$0), doc + context.getDocBase());
                    if (found < 0) {
                        return Explanation.Companion.noMatch("not in top " + DocAndScoreQuery.access$getDocs$p(this.this$0).length + " docs", new Explanation[0]);
                    }
                    return Explanation.Companion.match((Number)Float.valueOf(DocAndScoreQuery.access$getScores$p(this.this$0)[found] * this.$boost), "within top " + DocAndScoreQuery.access$getDocs$p(this.this$0).length + " docs", new Explanation[0]);
                }

                public int count(LeafReaderContext context) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    return DocAndScoreQuery.access$getSegmentStarts$p(this.this$0)[context.getOrd() + 1] - DocAndScoreQuery.access$getSegmentStarts$p(this.this$0)[context.getOrd()];
                }

                public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    if (DocAndScoreQuery.access$getSegmentStarts$p(this.this$0)[context.getOrd()] == DocAndScoreQuery.access$getSegmentStarts$p(this.this$0)[context.getOrd() + 1]) {
                        return null;
                    }
                    Scorer scorer2 = new Scorer(this.this$0, context, this.$boost){
                        private final int lower;
                        private final int upper;
                        private int upTo;
                        final /* synthetic */ DocAndScoreQuery this$0;
                        final /* synthetic */ LeafReaderContext $context;
                        final /* synthetic */ float $boost;
                        {
                            this.this$0 = $receiver;
                            this.$context = $context;
                            this.$boost = $boost;
                            this.lower = DocAndScoreQuery.access$getSegmentStarts$p($receiver)[$context.getOrd()];
                            this.upper = DocAndScoreQuery.access$getSegmentStarts$p($receiver)[$context.getOrd() + 1];
                            this.upTo = -1;
                        }

                        public final int getLower() {
                            return this.lower;
                        }

                        public final int getUpper() {
                            return this.upper;
                        }

                        public final int getUpTo() {
                            return this.upTo;
                        }

                        public final void setUpTo(int n) {
                            this.upTo = n;
                        }

                        public DocIdSetIterator iterator() {
                            return new DocIdSetIterator(this){
                                final /* synthetic */ createWeight.scorerSupplier.scorer.1 this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public int docID() {
                                    return this.this$0.docIdNoShadow();
                                }

                                public int nextDoc() {
                                    if (this.this$0.getUpTo() == -1) {
                                        this.this$0.setUpTo(this.this$0.getLower());
                                    } else {
                                        this.this$0.setUpTo(this.this$0.getUpTo() + 1);
                                        this.this$0.getUpTo();
                                    }
                                    return this.this$0.docIdNoShadow();
                                }

                                public int advance(int target) throws IOException {
                                    return this.slowAdvance(target);
                                }

                                public long cost() {
                                    return this.this$0.getUpper() - this.this$0.getLower();
                                }
                            };
                        }

                        public float getMaxScore(int docId) {
                            return DocAndScoreQuery.access$getMaxScore$p(this.this$0) * this.$boost;
                        }

                        public float score() {
                            return DocAndScoreQuery.access$getScores$p(this.this$0)[this.upTo] * this.$boost;
                        }

                        public final int docIdNoShadow() {
                            if (this.upTo == -1) {
                                return -1;
                            }
                            if (this.upTo >= this.upper) {
                                return Integer.MAX_VALUE;
                            }
                            return DocAndScoreQuery.access$getDocs$p(this.this$0)[this.upTo] - this.$context.getDocBase();
                        }

                        public int docID() {
                            return this.docIdNoShadow();
                        }
                    };
                    return new Weight.DefaultScorerSupplier(scorer2);
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    return true;
                }
            };
        }

        @Override
        @NotNull
        public String toString(@Nullable String field) {
            return "DocAndScoreQuery[" + this.docs[0] + ",...][" + this.scores[0] + ",...]," + this.maxScore;
        }

        @Override
        public void visit(@NotNull QueryVisitor visitor2) {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            visitor2.visitLeaf(this);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!this.sameClassAs(obj)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.AbstractKnnVectorQuery.DocAndScoreQuery");
            return this.contextIdentity == ((DocAndScoreQuery)obj).contextIdentity && Arrays.equals(this.docs, ((DocAndScoreQuery)obj).docs) && Arrays.equals(this.scores, ((DocAndScoreQuery)obj).scores);
        }

        @Override
        public int hashCode() {
            Object[] objectArray = new Object[]{this.classHash(), this.contextIdentity, Arrays.hashCode(this.docs), Arrays.hashCode(this.scores)};
            return Objects.INSTANCE.hash(objectArray);
        }

        public static final /* synthetic */ int[] access$getDocs$p(DocAndScoreQuery $this) {
            return $this.docs;
        }

        public static final /* synthetic */ float[] access$getScores$p(DocAndScoreQuery $this) {
            return $this.scores;
        }

        public static final /* synthetic */ int[] access$getSegmentStarts$p(DocAndScoreQuery $this) {
            return $this.segmentStarts;
        }

        public static final /* synthetic */ float access$getMaxScore$p(DocAndScoreQuery $this) {
            return $this.maxScore;
        }
    }
}

