/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.ConstantScoreWeight;
import org.gnit.lucenekmp.search.DisjunctionMatchesIterator;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.MatchesIterator;
import org.gnit.lucenekmp.search.MatchesUtils;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0004\u001c\u001d\u001e\u001fB\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u000f\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper;", "Q", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "Lorg/gnit/lucenekmp/search/Query;", "Lorg/gnit/lucenekmp/util/Accountable;", "query", "<init>", "(Lorg/gnit/lucenekmp/search/MultiTermQuery;)V", "getQuery", "()Lorg/gnit/lucenekmp/search/MultiTermQuery;", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "ramBytesUsed", "", "toString", "", "field", "equals", "", "other", "", "hashCode", "", "getField", "()Ljava/lang/String;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "TermAndState", "WeightOrDocIdSetIterator", "RewritingWeight", "Companion", "core"})
public abstract class AbstractMultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends Query
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Q query;
    public static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;

    public AbstractMultiTermQueryConstantScoreWrapper(@NotNull Q query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        this.query = query;
    }

    @NotNull
    public final Q getQuery() {
        return this.query;
    }

    @Override
    public long ramBytesUsed() {
        if (this.query instanceof Accountable) {
            long l = 12;
            Q q = this.query;
            Intrinsics.checkNotNull(q, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.Accountable");
            return l + ((Accountable)q).ramBytesUsed();
        }
        return 1036L;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        return ((Query)this.query).toString(field);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!this.sameClassAs(other)) return false;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.AbstractMultiTermQueryConstantScoreWrapper<*>");
        if (!((MultiTermQuery)this.query).equals(((AbstractMultiTermQueryConstantScoreWrapper)other).query)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + ((MultiTermQuery)this.query).hashCode();
    }

    @NotNull
    public final String getField() {
        return ((MultiTermQuery)this.query).getField();
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.getField())) {
            ((Query)this.query).visit(visitor2.getSubVisitor(BooleanClause.Occur.FILTER, this));
        }
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper$Companion;", "", "<init>", "()V", "BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b$\u0018\u0000 *2\u00020\u0001:\u0002)*B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ>\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH&J\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0011H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper$RewritingWeight;", "Lorg/gnit/lucenekmp/search/ConstantScoreWeight;", "q", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "boost", "", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "<init>", "(Lorg/gnit/lucenekmp/search/MultiTermQuery;FLorg/gnit/lucenekmp/search/ScoreMode;Lorg/gnit/lucenekmp/search/IndexSearcher;)V", "rewriteInner", "Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper$WeightOrDocIdSetIterator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "fieldDocCount", "", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "collectedTerms", "", "Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper$TermAndState;", "leadCost", "", "rewriteAsBooleanQuery", "collectTerms", "", "scorerForIterator", "Lorg/gnit/lucenekmp/search/Scorer;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "matches", "Lorg/gnit/lucenekmp/search/Matches;", "doc", "scorerSupplier", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "isCacheable", "ctx", "IOLongFunction", "Companion", "core"})
    protected static abstract class RewritingWeight
    extends ConstantScoreWeight {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MultiTermQuery q;
        @NotNull
        private final ScoreMode scoreMode;
        @NotNull
        private final IndexSearcher searcher;

        public RewritingWeight(@NotNull MultiTermQuery q, float boost, @NotNull ScoreMode scoreMode, @NotNull IndexSearcher searcher) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            super(q, boost);
            this.q = q;
            this.scoreMode = scoreMode;
            this.searcher = searcher;
        }

        @NotNull
        public abstract WeightOrDocIdSetIterator rewriteInner(@NotNull LeafReaderContext var1, int var2, @NotNull Terms var3, @NotNull TermsEnum var4, @NotNull List<TermAndState> var5, long var6) throws IOException;

        private final WeightOrDocIdSetIterator rewriteAsBooleanQuery(LeafReaderContext context, List<TermAndState> collectedTerms) throws IOException {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            for (TermAndState t : collectedTerms) {
                TermStates termStates = new TermStates(this.searcher.getTopReaderContext());
                termStates.register(t.getState(), context.getOrd(), t.getDocFreq(), t.getTotalTermFreq());
                bq.add(new TermQuery(new Term(this.q.getField(), t.getTerm()), termStates), BooleanClause.Occur.SHOULD);
            }
            Query q = new ConstantScoreQuery(bq.build());
            Weight weight = this.searcher.rewrite(q).createWeight(this.searcher, this.scoreMode, this.score());
            return new WeightOrDocIdSetIterator(weight);
        }

        private final boolean collectTerms(int fieldDocCount, TermsEnum termsEnum, List<TermAndState> terms) throws IOException {
            int threshold = Math.min(16, IndexSearcher.Companion.getMaxClauseCount());
            for (int i = 0; i < threshold; ++i) {
                BytesRef term = termsEnum.next();
                if (term == null) {
                    return true;
                }
                TermState state2 = termsEnum.termState();
                int docFreq = termsEnum.docFreq();
                TermAndState termAndState = new TermAndState(BytesRef.Companion.deepCopyOf(term), state2, docFreq, termsEnum.totalTermFreq());
                if (fieldDocCount == docFreq) {
                    terms.clear();
                    terms.add(termAndState);
                    return true;
                }
                terms.add(termAndState);
            }
            return termsEnum.next() == null;
        }

        private final Scorer scorerForIterator(DocIdSetIterator iterator2) {
            if (iterator2 == null) {
                return null;
            }
            return new ConstantScoreScorer(this.score(), this.scoreMode, iterator2);
        }

        @Override
        @Nullable
        public Matches matches(@NotNull LeafReaderContext context, int doc) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Terms terms = context.reader().terms(this.q.getField());
            if (terms == null) {
                return null;
            }
            return MatchesUtils.INSTANCE.forField(this.q.getField(), () -> RewritingWeight.matches$lambda$0(context, doc, this, terms));
        }

        @Override
        @Nullable
        public ScorerSupplier scorerSupplier(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Terms terms = context.reader().terms(this.q.getField());
            if (terms == null) {
                return null;
            }
            int fieldDocCount = terms.getDocCount();
            TermsEnum termsEnum = this.q.getTermsEnum(terms);
            if (termsEnum == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            TermsEnum termsEnum2 = termsEnum;
            List collectedTerms = new ArrayList();
            boolean collectResult = this.collectTerms(fieldDocCount, termsEnum2, collectedTerms);
            long cost = 0L;
            if (collectResult) {
                if (collectedTerms.isEmpty()) {
                    return null;
                }
                long sumTermCost = 0L;
                for (TermAndState collectedTerm : collectedTerms) {
                    sumTermCost += (long)collectedTerm.getDocFreq();
                }
                cost = sumTermCost;
            } else {
                cost = RewritingWeight.Companion.estimateCost(terms, this.q.getTermsCount());
            }
            IOLongFunction weightOrIteratorSupplier2 = new IOLongFunction<WeightOrDocIdSetIterator>(collectResult, this, context, (List<TermAndState>)collectedTerms, fieldDocCount, terms, termsEnum2){
                final /* synthetic */ boolean $collectResult;
                final /* synthetic */ RewritingWeight this$0;
                final /* synthetic */ LeafReaderContext $context;
                final /* synthetic */ List<TermAndState> $collectedTerms;
                final /* synthetic */ int $fieldDocCount;
                final /* synthetic */ Terms $terms;
                final /* synthetic */ TermsEnum $termsEnum;
                {
                    this.$collectResult = $collectResult;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$collectedTerms = $collectedTerms;
                    this.$fieldDocCount = $fieldDocCount;
                    this.$terms = $terms;
                    this.$termsEnum = $termsEnum;
                }

                public WeightOrDocIdSetIterator apply(long leadCost) throws IOException {
                    return this.$collectResult ? RewritingWeight.access$rewriteAsBooleanQuery(this.this$0, this.$context, this.$collectedTerms) : this.this$0.rewriteInner(this.$context, this.$fieldDocCount, this.$terms, this.$termsEnum, this.$collectedTerms, leadCost);
                }
            };
            return new ScorerSupplier(weightOrIteratorSupplier2, context, this, cost){
                final /* synthetic */ IOLongFunction<WeightOrDocIdSetIterator> $weightOrIteratorSupplier;
                final /* synthetic */ LeafReaderContext $context;
                final /* synthetic */ RewritingWeight this$0;
                final /* synthetic */ long $cost;
                {
                    this.$weightOrIteratorSupplier = $weightOrIteratorSupplier;
                    this.$context = $context;
                    this.this$0 = $receiver;
                    this.$cost = $cost;
                }

                public Scorer get(long leadCost) throws IOException {
                    WeightOrDocIdSetIterator weightOrIterator = this.$weightOrIteratorSupplier.apply(leadCost);
                    Scorer scorer2 = weightOrIterator == null ? null : (weightOrIterator.getWeight() != null ? weightOrIterator.getWeight().scorer(this.$context) : RewritingWeight.access$scorerForIterator(this.this$0, weightOrIterator.getIterator()));
                    Scorer scorer3 = scorer2;
                    if (scorer3 == null) {
                        scorer3 = new ConstantScoreScorer(this.this$0.score(), RewritingWeight.access$getScoreMode$p(this.this$0), DocIdSetIterator.Companion.empty());
                    }
                    return scorer3;
                }

                public BulkScorer bulkScorer() throws IOException {
                    BulkScorer bulkScorer;
                    BulkScorer bulkScorer2;
                    BulkScorer bulkScorer3;
                    WeightOrDocIdSetIterator weightOrIterator = this.$weightOrIteratorSupplier.apply(Long.MAX_VALUE);
                    if (weightOrIterator == null) {
                        bulkScorer3 = null;
                    } else if (weightOrIterator.getWeight() != null) {
                        bulkScorer3 = weightOrIterator.getWeight().bulkScorer(this.$context);
                    } else {
                        float f = this.this$0.score();
                        ScoreMode scoreMode = RewritingWeight.access$getScoreMode$p(this.this$0);
                        DocIdSetIterator docIdSetIterator = weightOrIterator.getIterator();
                        Intrinsics.checkNotNull((Object)docIdSetIterator);
                        bulkScorer3 = new Weight.DefaultBulkScorer(new ConstantScoreScorer(f, scoreMode, docIdSetIterator));
                    }
                    if ((bulkScorer2 = (bulkScorer = bulkScorer3)) == null) {
                        bulkScorer2 = new Weight.DefaultBulkScorer(new ConstantScoreScorer(this.this$0.score(), RewritingWeight.access$getScoreMode$p(this.this$0), DocIdSetIterator.Companion.empty()));
                    }
                    return bulkScorer2;
                }

                public long cost() {
                    return this.$cost;
                }
            };
        }

        @Override
        public boolean isCacheable(@NotNull LeafReaderContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return true;
        }

        private static final MatchesIterator matches$lambda$0(LeafReaderContext $context, int $doc, RewritingWeight this$0, Terms $terms) {
            MatchesIterator matchesIterator = DisjunctionMatchesIterator.Companion.fromTermsEnum($context, $doc, this$0.q, this$0.q.getField(), this$0.q.getTermsEnum($terms));
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator;
        }

        public static final /* synthetic */ WeightOrDocIdSetIterator access$rewriteAsBooleanQuery(RewritingWeight $this, LeafReaderContext context, List collectedTerms) {
            return $this.rewriteAsBooleanQuery(context, collectedTerms);
        }

        public static final /* synthetic */ Scorer access$scorerForIterator(RewritingWeight $this, DocIdSetIterator iterator2) {
            return $this.scorerForIterator(iterator2);
        }

        public static final /* synthetic */ ScoreMode access$getScoreMode$p(RewritingWeight $this) {
            return $this.scoreMode;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper$RewritingWeight$Companion;", "", "<init>", "()V", "estimateCost", "", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "queryTermsCount", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final long estimateCost(Terms terms, long queryTermsCount) throws IOException {
                long cost = 0L;
                if (queryTermsCount == -1L) {
                    cost = terms.getSumDocFreq();
                } else {
                    long potentialExtraCost = terms.getSumDocFreq();
                    long indexedTermCount = terms.size();
                    if (indexedTermCount != -1L) {
                        potentialExtraCost -= indexedTermCount;
                    }
                    cost = queryTermsCount + potentialExtraCost;
                }
                return cost;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\bb\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper$RewritingWeight$IOLongFunction;", "T", "", "apply", "arg", "", "(J)Ljava/lang/Object;", "core"})
        private static interface IOLongFunction<T> {
            @Nullable
            public T apply(long var1) throws IOException;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper$TermAndState;", "", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "state", "Lorg/gnit/lucenekmp/index/TermState;", "docFreq", "", "totalTermFreq", "", "<init>", "(Lorg/gnit/lucenekmp/util/BytesRef;Lorg/gnit/lucenekmp/index/TermState;IJ)V", "getTerm", "()Lorg/gnit/lucenekmp/util/BytesRef;", "getState", "()Lorg/gnit/lucenekmp/index/TermState;", "getDocFreq", "()I", "getTotalTermFreq", "()J", "core"})
    protected static final class TermAndState {
        @NotNull
        private final BytesRef term;
        @NotNull
        private final TermState state;
        private final int docFreq;
        private final long totalTermFreq;

        public TermAndState(@NotNull BytesRef term, @NotNull TermState state2, int docFreq, long totalTermFreq) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            this.term = term;
            this.state = state2;
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }

        @NotNull
        public final BytesRef getTerm() {
            return this.term;
        }

        @NotNull
        public final TermState getState() {
            return this.state;
        }

        public final int getDocFreq() {
            return this.docFreq;
        }

        public final long getTotalTermFreq() {
            return this.totalTermFreq;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/search/AbstractMultiTermQueryConstantScoreWrapper$WeightOrDocIdSetIterator;", "", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "<init>", "(Lorg/gnit/lucenekmp/search/Weight;)V", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "getWeight", "()Lorg/gnit/lucenekmp/search/Weight;", "getIterator", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "core"})
    protected static final class WeightOrDocIdSetIterator {
        @Nullable
        private final Weight weight;
        @Nullable
        private final DocIdSetIterator iterator;

        @Nullable
        public final Weight getWeight() {
            return this.weight;
        }

        @Nullable
        public final DocIdSetIterator getIterator() {
            return this.iterator;
        }

        public WeightOrDocIdSetIterator(@NotNull Weight weight) {
            Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
            this.weight = weight;
            this.iterator = null;
        }

        public WeightOrDocIdSetIterator(@NotNull DocIdSetIterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            this.iterator = iterator2;
            this.weight = null;
        }
    }
}

