/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerUtil;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010 \u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010!\u001a\u00020\u0011H\u0016J\b\u0010\"\u001a\u00020\u0011H\u0002J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001bH\u0016J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$H\u0016J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020$H\u0016R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0007\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010*\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u001d\"\u0004\b,\u0010\u001fR\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/search/BlockMaxConjunctionScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "scorersList", "", "<init>", "(Ljava/util/Collection;)V", "scorers", "", "getScorers", "()[Lorg/gnit/lucenekmp/search/Scorer;", "[Lorg/gnit/lucenekmp/search/Scorer;", "scorables", "Lorg/gnit/lucenekmp/search/Scorable;", "getScorables", "()[Lorg/gnit/lucenekmp/search/Scorable;", "[Lorg/gnit/lucenekmp/search/Scorable;", "approximations", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "getApproximations", "()[Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "[Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "twoPhases", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "getTwoPhases", "()[Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "[Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "minScore", "", "getMinScore", "()F", "setMinScore", "(F)V", "twoPhaseIterator", "iterator", "approximation", "docID", "", "score", "advanceShallow", "target", "getMaxScore", "upTo", "minCompetitiveScore", "getMinCompetitiveScore", "setMinCompetitiveScore", "children", "Lorg/gnit/lucenekmp/search/Scorable$ChildScorable;", "getChildren", "()Ljava/util/Collection;", "core"})
@SourceDebugExtension(value={"SMAP\nBlockMaxConjunctionScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockMaxConjunctionScorer.kt\norg/gnit/lucenekmp/search/BlockMaxConjunctionScorer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n37#2:239\n36#2,3:240\n37#2:249\n36#2,3:250\n37#2:253\n36#2,3:254\n6181#3,2:243\n11228#3:245\n11563#3,3:246\n1#4:257\n*S KotlinDebug\n*F\n+ 1 BlockMaxConjunctionScorer.kt\norg/gnit/lucenekmp/search/BlockMaxConjunctionScorer\n*L\n11#1:239\n11#1:240,3\n22#1:249\n22#1:250,3\n38#1:253\n38#1:254,3\n20#1:243,2\n22#1:245\n22#1:246,3\n*E\n"})
public final class BlockMaxConjunctionScorer
extends Scorer {
    @NotNull
    private final Scorer[] scorers;
    @NotNull
    private final Scorable[] scorables;
    @NotNull
    private final DocIdSetIterator[] approximations;
    @NotNull
    private final TwoPhaseIterator[] twoPhases;
    private float minScore;

    /*
     * WARNING - void declaration
     */
    public BlockMaxConjunctionScorer(@NotNull Collection<Scorer> scorersList) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(scorersList, (String)"scorersList");
        Collection $this$toTypedArray$iv = scorersList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.scorers = thisCollection$iv.toArray(new Scorer[0]);
        Object[] $this$sortBy$iv = this.scorers;
        boolean $i$f$sortBy22 = false;
        if ($this$sortBy$iv.length > 1) {
            ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Scorer it = (Scorer)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.iterator().cost());
                    it = (Scorer)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.iterator().cost()));
                }
            });
        }
        $this$sortBy$iv = this.scorers;
        ScorerUtil $i$f$sortBy22 = ScorerUtil.INSTANCE;
        BlockMaxConjunctionScorer blockMaxConjunctionScorer = this;
        boolean $i$f$map = false;
        void var5_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Scorable scorable = (Scorable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add($i$f$sortBy22.likelyTermScorer((Scorable)p0));
        }
        $this$toTypedArray$iv = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv2 = $this$toTypedArray$iv;
        blockMaxConjunctionScorer.scorables = thisCollection$iv2.toArray(new Scorable[0]);
        this.approximations = new DocIdSetIterator[this.scorers.length];
        List twoPhaseList = new ArrayList();
        int thisCollection$iv2 = this.scorers.length;
        for (int i = 0; i < thisCollection$iv2; ++i) {
            Scorer scorer2 = this.scorers[i];
            TwoPhaseIterator twoPhase = scorer2.twoPhaseIterator();
            if (twoPhase != null) {
                twoPhaseList.add(twoPhase);
                this.approximations[i] = twoPhase.approximation();
            } else {
                this.approximations[i] = scorer2.iterator();
            }
            DocIdSetIterator docIdSetIterator = this.approximations[i];
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            this.approximations[i] = ScorerUtil.INSTANCE.likelyImpactsEnum(docIdSetIterator);
            scorer2.advanceShallow(0);
        }
        Collection $this$toTypedArray$iv2 = twoPhaseList;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv3 = $this$toTypedArray$iv2;
        this.twoPhases = thisCollection$iv3.toArray(new TwoPhaseIterator[0]);
        Arrays.INSTANCE.sort(this.twoPhases, new Comparator(){

            public final int compare(T a, T b) {
                TwoPhaseIterator it = (TwoPhaseIterator)a;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.matchCost());
                it = (TwoPhaseIterator)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.matchCost()));
            }
        });
    }

    @NotNull
    public final Scorer[] getScorers() {
        return this.scorers;
    }

    @NotNull
    public final Scorable[] getScorables() {
        return this.scorables;
    }

    @NotNull
    public final DocIdSetIterator[] getApproximations() {
        return this.approximations;
    }

    @NotNull
    public final TwoPhaseIterator[] getTwoPhases() {
        return this.twoPhases;
    }

    public final float getMinScore() {
        return this.minScore;
    }

    public final void setMinScore(float f) {
        this.minScore = f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TwoPhaseIterator twoPhaseIterator() {
        if (this.twoPhases.length == 0) {
            return null;
        }
        TwoPhaseIterator[] twoPhaseIteratorArray = this.twoPhases;
        double d = 0.0;
        int n = twoPhaseIteratorArray.length;
        for (int i = 0; i < n; ++i) {
            void it;
            TwoPhaseIterator twoPhaseIterator2;
            TwoPhaseIterator twoPhaseIterator3 = twoPhaseIterator2 = twoPhaseIteratorArray[i];
            double d2 = d;
            boolean bl = false;
            double d3 = it.matchCost();
            d = d2 + d3;
        }
        float matchCost = (float)d;
        DocIdSetIterator approx = this.approximation();
        return new TwoPhaseIterator(approx, this, matchCost){
            final /* synthetic */ BlockMaxConjunctionScorer this$0;
            final /* synthetic */ float $matchCost;
            {
                this.this$0 = $receiver;
                this.$matchCost = $matchCost;
                super($approx);
            }

            public boolean matches() throws IOException {
                for (TwoPhaseIterator twoPhase : this.this$0.getTwoPhases()) {
                    if (!(twoPhase.approximation().docID() == this.this$0.docID())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (twoPhase.matches()) continue;
                    return false;
                }
                return true;
            }

            public float matchCost() {
                return this.$matchCost;
            }
        };
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        DocIdSetIterator docIdSetIterator;
        if (this.twoPhases.length == 0) {
            docIdSetIterator = this.approximation();
        } else {
            TwoPhaseIterator twoPhaseIterator2 = this.twoPhaseIterator();
            Intrinsics.checkNotNull((Object)twoPhaseIterator2);
            docIdSetIterator = TwoPhaseIterator.Companion.asDocIdSetIterator(twoPhaseIterator2);
        }
        return docIdSetIterator;
    }

    private final DocIdSetIterator approximation() {
        DocIdSetIterator docIdSetIterator = this.approximations[0];
        Intrinsics.checkNotNull((Object)docIdSetIterator);
        DocIdSetIterator lead = docIdSetIterator;
        return new DocIdSetIterator(lead, this){
            private float maxScore;
            private int upTo;
            final /* synthetic */ DocIdSetIterator $lead;
            final /* synthetic */ BlockMaxConjunctionScorer this$0;
            {
                this.$lead = $lead;
                this.this$0 = $receiver;
                this.upTo = -1;
            }

            public final float getMaxScore() {
                return this.maxScore;
            }

            public final void setMaxScore(float f) {
                this.maxScore = f;
            }

            public final int getUpTo() {
                return this.upTo;
            }

            public final void setUpTo(int n) {
                this.upTo = n;
            }

            public int docID() {
                return this.$lead.docID();
            }

            public long cost() {
                return this.$lead.cost();
            }

            public final void moveToNextBlock(int target) throws IOException {
                if (this.this$0.getMinScore() == 0.0f) {
                    this.upTo = target;
                    this.maxScore = Float.POSITIVE_INFINITY;
                } else {
                    this.upTo = this.this$0.advanceShallow(target);
                    this.maxScore = this.this$0.getMaxScore(this.upTo);
                }
            }

            public final int advanceTarget(int target) throws IOException {
                int target2 = target;
                if (target2 > this.upTo) {
                    this.moveToNextBlock(target2);
                }
                while (true) {
                    if (!(this.upTo >= target2)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (this.maxScore >= this.this$0.getMinScore()) {
                        return target2;
                    }
                    if (this.upTo == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    target2 = this.upTo + 1;
                    this.moveToNextBlock(target2);
                }
            }

            public int nextDoc() throws IOException {
                return this.advance(this.docID() + 1);
            }

            public int advance(int target) throws IOException {
                return this.doNext(this.$lead.advance(this.advanceTarget(target)));
            }

            public final int doNext(int doc) throws IOException {
                int doc2 = doc;
                block0: while (true) {
                    int nextTarget;
                    if (!(doc2 == this.$lead.docID())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (doc2 == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    if (doc2 > this.upTo && (nextTarget = this.advanceTarget(doc2)) != doc2) {
                        doc2 = this.$lead.advance(nextTarget);
                        continue;
                    }
                    if (!(doc2 <= this.upTo)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    int n = this.this$0.getApproximations().length;
                    for (int i = 1; i < n; ++i) {
                        int next;
                        DocIdSetIterator other;
                        Intrinsics.checkNotNull((Object)this.this$0.getApproximations()[i]);
                        if (other.docID() < doc2 && (next = other.advance(doc2)) > doc2) {
                            doc2 = this.$lead.advance(this.advanceTarget(next));
                            continue block0;
                        }
                        if (other.docID() == doc2) continue;
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    break;
                }
                return doc2;
            }
        };
    }

    @Override
    public int docID() {
        return this.scorers[0].docID();
    }

    @Override
    public float score() throws IOException {
        double score2 = 0.0;
        for (Scorable scorer2 : this.scorables) {
            score2 += (double)scorer2.score();
        }
        return (float)score2;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        int result = this.scorers[0].advanceShallow(target);
        int n = this.scorers.length;
        for (int i = 1; i < n; ++i) {
            this.scorers[i].advanceShallow(target);
        }
        return result;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double sum = 0.0;
        for (Scorer scorer2 : this.scorers) {
            sum += (double)scorer2.getMaxScore(upTo);
        }
        return (float)sum;
    }

    @Override
    public float getMinCompetitiveScore() {
        return this.minScore;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        this.minScore = minScore;
    }

    @Override
    @NotNull
    public Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
        for (Scorer scorer2 : this.scorers) {
            children.add(new Scorable.ChildScorable(scorer2, "MUST"));
        }
        return children;
    }
}

