/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.internal.hppc.LongArrayList;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.CheckedIntConsumer;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.DocIdStream;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.Score;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerUtil;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0000\u0018\u0000 I2\u00020\u0001:\u0005EFGHIB%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010(\u001a\u00020)H\u0016JM\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u00109\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u0006H\u0002J:\u0010<\u001a\u0002012\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0006H\u0002J:\u0010A\u001a\u0002012\u0006\u0010B\u001a\u00020\u00162\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006H\u0002J2\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\u00162\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006H\u0002J*\u0010\"\u001a\u00020\u00062\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006H\u0016R\u001d\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\f\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0012\u0010.\u001a\u00060/R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/gnit/lucenekmp/search/BooleanScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "scorers", "", "Lorg/gnit/lucenekmp/search/Scorer;", "minShouldMatch", "", "needsScores", "", "<init>", "(Ljava/util/Collection;IZ)V", "buckets", "", "Lorg/gnit/lucenekmp/search/BooleanScorer$Bucket;", "getBuckets", "()[Lorg/gnit/lucenekmp/search/BooleanScorer$Bucket;", "[Lorg/gnit/lucenekmp/search/BooleanScorer$Bucket;", "matching", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "getMatching", "()Lorg/gnit/lucenekmp/util/FixedBitSet;", "leads", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "getLeads", "()[Lorg/gnit/lucenekmp/search/DisiWrapper;", "[Lorg/gnit/lucenekmp/search/DisiWrapper;", "head", "Lorg/gnit/lucenekmp/search/BooleanScorer$HeadPriorityQueue;", "getHead", "()Lorg/gnit/lucenekmp/search/BooleanScorer$HeadPriorityQueue;", "tail", "Lorg/gnit/lucenekmp/search/BooleanScorer$TailPriorityQueue;", "getTail", "()Lorg/gnit/lucenekmp/search/BooleanScorer$TailPriorityQueue;", "score", "Lorg/gnit/lucenekmp/search/Score;", "getScore", "()Lorg/gnit/lucenekmp/search/Score;", "getMinShouldMatch", "()I", "cost", "", "getCost", "()J", "getNeedsScores", "()Z", "docIdStreamView", "Lorg/gnit/lucenekmp/search/BooleanScorer$DocIdStreamView;", "scoreWindowIntoBitSetAndReplay", "", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "base", "min", "max", "numScorers", "(Lorg/gnit/lucenekmp/search/LeafCollector;Lorg/gnit/lucenekmp/util/Bits;III[Lorg/gnit/lucenekmp/search/DisiWrapper;I)V", "advance", "scoreWindowMultipleScorers", "windowBase", "windowMin", "windowMax", "maxFreq", "scoreWindowSingleScorer", "w", "scoreWindow", "top", "Bucket", "HeadPriorityQueue", "TailPriorityQueue", "DocIdStreamView", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nBooleanScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanScorer.kt\norg/gnit/lucenekmp/search/BooleanScorer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n1#2:324\n*E\n"})
public final class BooleanScorer
extends BulkScorer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Bucket[] buckets;
    @NotNull
    private final FixedBitSet matching;
    @NotNull
    private final DisiWrapper[] leads;
    @NotNull
    private final HeadPriorityQueue head;
    @NotNull
    private final TailPriorityQueue tail;
    @NotNull
    private final Score score;
    private final int minShouldMatch;
    private final long cost;
    private final boolean needsScores;
    @NotNull
    private final DocIdStreamView docIdStreamView;
    public static final int SHIFT = 12;
    public static final int SIZE = 4096;
    public static final int MASK = 4095;

    public BooleanScorer(@NotNull Collection<Scorer> scorers, int minShouldMatch, boolean needsScores) {
        Intrinsics.checkNotNullParameter(scorers, (String)"scorers");
        this.matching = new FixedBitSet(4096);
        this.score = new Score();
        this.docIdStreamView = new DocIdStreamView();
        if (!(minShouldMatch >= 1 && minShouldMatch <= scorers.size())) {
            boolean $i$a$-require-BooleanScorer$32 = false;
            String $i$a$-require-BooleanScorer$32 = "minShouldMatch should be within 1..num_scorers. Got " + minShouldMatch;
            throw new IllegalArgumentException($i$a$-require-BooleanScorer$32.toString());
        }
        if (!(scorers.size() > 1)) {
            boolean bl = false;
            String string = "This scorer can only be used with two scorers or more, got " + scorers.size();
            throw new IllegalArgumentException(string.toString());
        }
        if (needsScores || minShouldMatch > 1) {
            this.buckets = new Bucket[4096];
            int n = this.buckets.length;
            for (int i = 0; i < n; ++i) {
                this.buckets[i] = new Bucket();
            }
        } else {
            this.buckets = null;
        }
        this.leads = new DisiWrapper[scorers.size()];
        this.head = new HeadPriorityQueue(scorers.size() - minShouldMatch + 1);
        this.tail = new TailPriorityQueue(minShouldMatch - 1);
        this.minShouldMatch = minShouldMatch;
        this.needsScores = needsScores;
        LongArrayList costs = new LongArrayList(scorers.size());
        for (Scorer scorer2 : scorers) {
            DisiWrapper w = new DisiWrapper(scorer2, false);
            costs.add(w.getCost());
            DisiWrapper evicted = this.tail.insertWithOverflow(w);
            if (evicted == null) continue;
            this.head.add(evicted);
        }
        this.cost = ScorerUtil.INSTANCE.costWithMinShouldMatch(costs.asSequence(), costs.size(), minShouldMatch);
    }

    @Nullable
    public final Bucket[] getBuckets() {
        return this.buckets;
    }

    @NotNull
    public final FixedBitSet getMatching() {
        return this.matching;
    }

    @NotNull
    public final DisiWrapper[] getLeads() {
        return this.leads;
    }

    @NotNull
    public final HeadPriorityQueue getHead() {
        return this.head;
    }

    @NotNull
    public final TailPriorityQueue getTail() {
        return this.tail;
    }

    @NotNull
    public final Score getScore() {
        return this.score;
    }

    public final int getMinShouldMatch() {
        return this.minShouldMatch;
    }

    public final long getCost() {
        return this.cost;
    }

    public final boolean getNeedsScores() {
        return this.needsScores;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private final void scoreWindowIntoBitSetAndReplay(LeafCollector collector2, Bits acceptDocs, int base, int min, int max, DisiWrapper[] scorers, int numScorers) throws IOException {
        for (int i = 0; i < numScorers; ++i) {
            DocIdSetIterator it;
            DisiWrapper w = scorers[i];
            if (!(w.getDoc() < max)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)w.getIterator());
            int doc = w.getDoc();
            if (doc < min) {
                doc = it.advance(min);
            }
            if (this.buckets == null) {
                it.intoBitSet(max, this.matching, base);
            } else {
                while (doc < max) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        Bucket bucket;
                        int d = doc & 0xFFF;
                        this.matching.set(d);
                        Intrinsics.checkNotNull((Object)this.buckets[d]);
                        int n = bucket.getFreq();
                        bucket.setFreq(n + 1);
                        if (this.needsScores) {
                            double d2 = bucket.getScore();
                            Scorable scorable = w.getScorable();
                            Intrinsics.checkNotNull((Object)scorable);
                            bucket.setScore(d2 + (double)scorable.score());
                        }
                    }
                    doc = it.nextDoc();
                }
            }
            w.setDoc(it.docID());
        }
        if (this.buckets == null && acceptDocs != null) {
            acceptDocs.applyMask(this.matching, base);
        }
        this.docIdStreamView.setBase(base);
        collector2.collect(this.docIdStreamView);
        this.matching.clear();
    }

    private final DisiWrapper advance(int min) throws IOException {
        if (!(this.tail.size() == this.minShouldMatch - 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        HeadPriorityQueue head2 = this.head;
        TailPriorityQueue tail = this.tail;
        DisiWrapper headTop = (DisiWrapper)head2.top();
        DisiWrapper tailTop = (DisiWrapper)tail.top();
        while (headTop.getDoc() < min) {
            if (tailTop == null || headTop.getCost() <= tailTop.getCost()) {
                DocIdSetIterator docIdSetIterator = headTop.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                headTop.setDoc(docIdSetIterator.advance(min));
                headTop = (DisiWrapper)head2.updateTop();
                continue;
            }
            DisiWrapper previousHeadTop = headTop;
            DocIdSetIterator docIdSetIterator = tailTop.getIterator();
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            tailTop.setDoc(docIdSetIterator.advance(min));
            headTop = head2.updateTop(tailTop);
            tailTop = tail.updateTop(previousHeadTop);
        }
        return headTop;
    }

    private final void scoreWindowMultipleScorers(LeafCollector collector2, Bits acceptDocs, int windowBase, int windowMin, int windowMax, int maxFreq) throws IOException {
        int n;
        int maxFreq2 = maxFreq;
        while (maxFreq2 < this.minShouldMatch && maxFreq2 + this.tail.size() >= this.minShouldMatch) {
            Object t = this.tail.pop();
            Intrinsics.checkNotNull(t);
            DisiWrapper candidate = (DisiWrapper)t;
            if (candidate.getDoc() < windowMin) {
                DocIdSetIterator docIdSetIterator = candidate.getIterator();
                Intrinsics.checkNotNull((Object)docIdSetIterator);
                candidate.setDoc(docIdSetIterator.advance(windowMin));
            }
            if (candidate.getDoc() < windowMax) {
                this.leads[maxFreq2++] = candidate;
                continue;
            }
            this.head.add(candidate);
        }
        if (maxFreq2 >= this.minShouldMatch) {
            n = this.tail.size();
            for (int i = 0; i < n; ++i) {
                this.leads[maxFreq2++] = this.tail.get(i);
            }
            this.tail.clear();
            this.scoreWindowIntoBitSetAndReplay(collector2, acceptDocs, windowBase, windowMin, windowMax, this.leads, maxFreq2);
        }
        n = maxFreq2;
        for (int i = 0; i < n; ++i) {
            DisiWrapper disiWrapper = this.leads[i];
            Intrinsics.checkNotNull((Object)disiWrapper);
            DisiWrapper evicted = this.head.insertWithOverflow(disiWrapper);
            if (evicted == null) continue;
            this.tail.add(evicted);
        }
    }

    private final void scoreWindowSingleScorer(DisiWrapper w, LeafCollector collector2, Bits acceptDocs, int windowMin, int windowMax, int max) throws IOException {
        if (!(this.tail.size() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int nextWindowBase = ((DisiWrapper)this.head.top()).getDoc() & 0xFFFFF000;
        int end = Math.max(windowMax, Math.min(max, nextWindowBase));
        DocIdSetIterator docIdSetIterator = w.getIterator();
        Intrinsics.checkNotNull((Object)docIdSetIterator);
        DocIdSetIterator it = docIdSetIterator;
        int doc = w.getDoc();
        if (doc < windowMin) {
            doc = it.advance(windowMin);
        }
        collector2.setScorer(w.getScorer());
        while (doc < end) {
            if (acceptDocs == null || acceptDocs.get(doc)) {
                collector2.collect(doc);
            }
            doc = it.nextDoc();
        }
        w.setDoc(doc);
        collector2.setScorer(this.score);
    }

    private final DisiWrapper scoreWindow(DisiWrapper top, LeafCollector collector2, Bits acceptDocs, int min, int max) throws IOException {
        int windowBase = top.getDoc() & 0xFFFFF000;
        int windowMin = Math.max(min, windowBase);
        int windowMax = Math.min(max, windowBase + 4096);
        Intrinsics.checkNotNull(this.head.pop());
        int maxFreq = 1;
        while (this.head.size() > 0 && ((DisiWrapper)this.head.top()).getDoc() < windowMax) {
            int n = maxFreq++;
            Object t = this.head.pop();
            Intrinsics.checkNotNull(t);
            this.leads[n] = t;
        }
        if (this.minShouldMatch == 1 && maxFreq == 1) {
            DisiWrapper disiWrapper = this.leads[0];
            Intrinsics.checkNotNull((Object)disiWrapper);
            DisiWrapper bulkScorer = disiWrapper;
            this.scoreWindowSingleScorer(bulkScorer, collector2, acceptDocs, windowMin, windowMax, max);
            DisiWrapper disiWrapper2 = this.head.add(bulkScorer);
            Intrinsics.checkNotNull((Object)disiWrapper2);
            return disiWrapper2;
        }
        this.scoreWindowMultipleScorers(collector2, acceptDocs, windowBase, windowMin, windowMax, maxFreq);
        return (DisiWrapper)this.head.top();
    }

    @Override
    public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        collector2.setScorer(this.score);
        DisiWrapper top = this.advance(min);
        while (top.getDoc() < max) {
            top = this.scoreWindow(top, collector2, acceptDocs, min, max);
        }
        return top.getDoc();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/BooleanScorer$Bucket;", "", "<init>", "()V", "score", "", "getScore", "()D", "setScore", "(D)V", "freq", "", "getFreq", "()I", "setFreq", "(I)V", "core"})
    public static final class Bucket {
        private double score;
        private int freq;

        public final double getScore() {
            return this.score;
        }

        public final void setScore(double d) {
            this.score = d;
        }

        public final int getFreq() {
            return this.freq;
        }

        public final void setFreq(int n) {
            this.freq = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/BooleanScorer$Companion;", "", "<init>", "()V", "SHIFT", "", "SIZE", "MASK", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\rH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/BooleanScorer$DocIdStreamView;", "Lorg/gnit/lucenekmp/search/DocIdStream;", "<init>", "(Lorg/gnit/lucenekmp/search/BooleanScorer;)V", "base", "", "getBase", "()I", "setBase", "(I)V", "forEach", "", "consumer", "Lorg/gnit/lucenekmp/search/CheckedIntConsumer;", "Ljava/io/IOException;", "Lokio/IOException;", "count", "core"})
    public final class DocIdStreamView
    extends DocIdStream {
        private int base;

        public final int getBase() {
            return this.base;
        }

        public final void setBase(int n) {
            this.base = n;
        }

        @Override
        public void forEach(@NotNull CheckedIntConsumer<IOException> consumer) throws IOException {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            FixedBitSet matching = BooleanScorer.this.getMatching();
            Bucket[] buckets = BooleanScorer.this.getBuckets();
            int base = this.base;
            long[] bitArray = matching.getBits();
            int n = bitArray.length;
            for (int idx = 0; idx < n; ++idx) {
                int ntz;
                for (long bits = bitArray[idx]; bits != 0L; bits ^= 1L << ntz) {
                    ntz = LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, bits);
                    if (buckets != null) {
                        Bucket bucket;
                        int indexInWindow = idx << 6 | ntz;
                        Intrinsics.checkNotNull((Object)buckets[indexInWindow]);
                        if (bucket.getFreq() >= BooleanScorer.this.getMinShouldMatch()) {
                            BooleanScorer.this.getScore().setScore((float)bucket.getScore());
                            consumer.accept(base | indexInWindow);
                        }
                        bucket.setFreq(0);
                        bucket.setScore(0.0);
                        continue;
                    }
                    consumer.accept(base | idx << 6 | ntz);
                }
            }
        }

        @Override
        public int count() throws IOException {
            if (BooleanScorer.this.getMinShouldMatch() > 1) {
                return super.count();
            }
            return BooleanScorer.this.getMatching().cardinality();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/search/BooleanScorer$HeadPriorityQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "maxSize", "", "<init>", "(I)V", "lessThan", "", "a", "b", "core"})
    public static final class HeadPriorityQueue
    extends PriorityQueue<DisiWrapper> {
        public HeadPriorityQueue(int maxSize) {
            super(maxSize, null, 2, null);
        }

        @Override
        public boolean lessThan(@NotNull DisiWrapper a, @NotNull DisiWrapper b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.getDoc() < b.getDoc();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/search/BooleanScorer$TailPriorityQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "maxSize", "", "<init>", "(I)V", "lessThan", "", "a", "b", "get", "i", "core"})
    public static final class TailPriorityQueue
    extends PriorityQueue<DisiWrapper> {
        public TailPriorityQueue(int maxSize) {
            super(maxSize, null, 2, null);
        }

        @Override
        public boolean lessThan(@NotNull DisiWrapper a, @NotNull DisiWrapper b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.getCost() < b.getCost();
        }

        @NotNull
        public final DisiWrapper get(int i) {
            Objects.INSTANCE.checkIndex(i, this.size());
            DisiWrapper disiWrapper = ((DisiWrapper[])this.getHeapArray())[1 + i];
            Intrinsics.checkNotNull((Object)disiWrapper, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.DisiWrapper");
            return disiWrapper;
        }
    }
}

