/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/search/BoostQuery;", "Lorg/gnit/lucenekmp/search/Query;", "query", "boost", "", "<init>", "(Lorg/gnit/lucenekmp/search/Query;F)V", "getQuery", "()Lorg/gnit/lucenekmp/search/Query;", "getBoost", "()F", "equals", "", "other", "", "equalsTo", "hashCode", "", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "toString", "", "field", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "core"})
public final class BoostQuery
extends Query {
    @NotNull
    private final Query query;
    private final float boost;

    /*
     * Unable to fully structure code
     */
    public BoostQuery(@NotNull Query query, float boost) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        super();
        this.query = query;
        if (!FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, boost)) ** GOTO lbl-1000
        if (FloatExtKt.compare(FloatCompanionObject.INSTANCE, boost, 0.0f) >= 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (!v0) {
            $i$a$-require-BoostQuery$1 = false;
            var3_4 = "boost must be a positive float, got " + boost;
            throw new IllegalArgumentException(var3_4.toString());
        }
        this.boost = boost;
    }

    @NotNull
    public final Query getQuery() {
        return this.query;
    }

    public final float getBoost() {
        return this.boost;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other) && this.equalsTo((BoostQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean equalsTo(BoostQuery other) {
        return Intrinsics.areEqual((Object)this.query, (Object)other.query) && FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, this.boost) == FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, other.boost);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.query.hashCode();
        h = 31 * h + FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, this.boost);
        return h;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        Query rewritten = this.query.rewrite(indexSearcher);
        if (this.boost == 1.0f) {
            return rewritten;
        }
        if (rewritten instanceof BoostQuery) {
            Query in = rewritten;
            return new BoostQuery(((BoostQuery)in).query, this.boost * ((BoostQuery)in).boost);
        }
        if (rewritten instanceof MatchNoDocsQuery) {
            return rewritten;
        }
        if (this.boost == 0.0f && rewritten.getClass() != ConstantScoreQuery.class) {
            return new BoostQuery(new ConstantScoreQuery(rewritten), 0.0f);
        }
        if (this.query != rewritten) {
            return new BoostQuery(rewritten, this.boost);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        this.query.visit(visitor2.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.query.toString(field));
        builder.append(")");
        builder.append("^");
        builder.append(this.boost);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        return this.query.createWeight(searcher, scoreMode, this.boost * boost);
    }
}

