/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerUtil;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/search/ConjunctionBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "requiredScoring", "", "Lorg/gnit/lucenekmp/search/Scorer;", "requiredNoScoring", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "scoringScorers", "", "Lorg/gnit/lucenekmp/search/Scorable;", "[Lorg/gnit/lucenekmp/search/Scorable;", "lead1", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "lead2", "others", "scorable", "score", "", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "cost", "", "core"})
@SourceDebugExtension(value={"SMAP\nConjunctionBulkScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConjunctionBulkScorer.kt\norg/gnit/lucenekmp/search/ConjunctionBulkScorer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,154:1\n1#2:155\n1563#3:156\n1634#3,3:157\n1011#3,2:164\n37#4:160\n36#4,3:161\n37#4:166\n36#4,3:167\n*S KotlinDebug\n*F\n+ 1 ConjunctionBulkScorer.kt\norg/gnit/lucenekmp/search/ConjunctionBulkScorer\n*L\n26#1:156\n26#1:157,3\n31#1:164,2\n26#1:160\n26#1:161,3\n78#1:166\n78#1:167,3\n*E\n"})
public final class ConjunctionBulkScorer
extends BulkScorer {
    @NotNull
    private final Scorable[] scoringScorers;
    @NotNull
    private final DocIdSetIterator lead1;
    @NotNull
    private final DocIdSetIterator lead2;
    @NotNull
    private final List<DocIdSetIterator> others;
    @NotNull
    private final Scorable scorable;

    /*
     * WARNING - void declaration
     */
    public ConjunctionBulkScorer(@NotNull List<Scorer> requiredScoring, @NotNull List<Scorer> requiredNoScoring) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter(requiredScoring, (String)"requiredScoring");
        Intrinsics.checkNotNullParameter(requiredNoScoring, (String)"requiredNoScoring");
        int numClauses = requiredScoring.size() + requiredNoScoring.size();
        if (!(numClauses > 1)) {
            boolean $i$a$-require-ConjunctionBulkScorer$22 = false;
            String $i$a$-require-ConjunctionBulkScorer$22 = "Expected 2 or more clauses, got " + numClauses;
            throw new IllegalArgumentException($i$a$-require-ConjunctionBulkScorer$22.toString());
        }
        final List allScorers = new ArrayList();
        allScorers.addAll((Collection)requiredScoring);
        allScorers.addAll((Collection)requiredNoScoring);
        Iterable $i$a$-require-ConjunctionBulkScorer$22 = requiredScoring;
        ScorerUtil scorerUtil = ScorerUtil.INSTANCE;
        ConjunctionBulkScorer conjunctionBulkScorer = this;
        boolean $i$f$map = false;
        void var8_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Scorable scorable = (Scorable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(scorerUtil.likelyTermScorer((Scorable)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        conjunctionBulkScorer.scoringScorers = thisCollection$iv.toArray(new Scorable[0]);
        List iterators = new ArrayList();
        for (Scorer scorer2 : allScorers) {
            iterators.add(scorer2.iterator());
        }
        List $this$sortBy$iv = iterators;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DocIdSetIterator it = (DocIdSetIterator)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.cost());
                    it = (DocIdSetIterator)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.cost()));
                }
            });
        }
        this.lead1 = (DocIdSetIterator)iterators.get(0);
        this.lead2 = (DocIdSetIterator)iterators.get(1);
        this.others = CollectionsKt.toMutableList((Collection)iterators.subList(2, iterators.size()));
        this.scorable = new Scorable(){

            @Override
            public float score() throws IOException {
                double score2 = 0.0;
                for (Scorable scorer2 : scoringScorers) {
                    score2 += (double)scorer2.score();
                }
                return (float)score2;
            }

            @Override
            public Collection<Scorable.ChildScorable> getChildren() {
                ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
                for (Scorer scorer2 : allScorers) {
                    children.add(new Scorable.ChildScorable(scorer2, "MUST"));
                }
                return children;
            }
        };
    }

    @Override
    public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
        int next;
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (!(this.lead1.docID() >= this.lead2.docID())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.lead1.docID() < min) {
            this.lead1.advance(min);
        }
        if (this.lead1.docID() >= max) {
            return this.lead1.docID();
        }
        collector2.setScorer(this.scorable);
        List otherIterators = this.others;
        DocIdSetIterator collectorIterator = collector2.competitiveIterator();
        if (collectorIterator != null) {
            otherIterators = new ArrayList(otherIterators);
            ((ArrayList)otherIterators).add(collectorIterator);
        }
        Collection $this$toTypedArray$iv = otherIterators;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DocIdSetIterator[] others = thisCollection$iv.toArray(new DocIdSetIterator[0]);
        if (this.lead1.docID() == this.lead2.docID()) {
            int doc = this.lead1.docID();
            if (acceptDocs == null || acceptDocs.get(doc)) {
                boolean match = true;
                for (DocIdSetIterator it : others) {
                    if (it.docID() < doc && (next = it.advance(doc)) != doc) {
                        this.lead1.advance(next);
                        match = false;
                        break;
                    }
                    if (it.docID() == doc) continue;
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (match) {
                    collector2.collect(doc);
                    this.lead1.nextDoc();
                }
            } else {
                this.lead1.nextDoc();
            }
        }
        int doc = this.lead1.docID();
        block1: while (doc < max) {
            if (!(this.lead2.docID() < doc)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (acceptDocs != null && !acceptDocs.get(doc)) {
                doc = this.lead1.nextDoc();
                continue;
            }
            int next2 = this.lead2.advance(doc);
            if (next2 != doc) {
                doc = this.lead1.advance(next2);
                if (doc != next2) continue;
                if (doc >= max) break;
                if (acceptDocs != null && !acceptDocs.get(doc)) {
                    doc = this.lead1.nextDoc();
                    continue;
                }
            }
            if (!(this.lead2.docID() == doc)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            for (DocIdSetIterator it : others) {
                if (it.docID() < doc && (next = it.advance(doc)) != doc) {
                    doc = this.lead1.advance(next);
                    continue block1;
                }
                if (it.docID() == doc) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            collector2.collect(doc);
            doc = this.lead1.nextDoc();
        }
        return this.lead1.docID();
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }
}

