/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u0019B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/ConstantScoreScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "score", "", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "disi", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "<init>", "(FLorg/gnit/lucenekmp/search/ScoreMode;Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "twoPhaseIterator", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "(FLorg/gnit/lucenekmp/search/ScoreMode;Lorg/gnit/lucenekmp/search/TwoPhaseIterator;)V", "approximation", "getMaxScore", "upTo", "", "minScore", "minCompetitiveScore", "getMinCompetitiveScore", "()F", "setMinCompetitiveScore", "(F)V", "iterator", "docID", "DocIdSetIteratorWrapper", "core"})
public final class ConstantScoreScorer
extends Scorer {
    private final float score;
    @Nullable
    private final ScoreMode scoreMode;
    @NotNull
    private final DocIdSetIterator approximation;
    @Nullable
    private final TwoPhaseIterator twoPhaseIterator;
    @NotNull
    private final DocIdSetIterator disi;

    public ConstantScoreScorer(float score2, @Nullable ScoreMode scoreMode, @NotNull DocIdSetIterator disi) {
        Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
        this.score = score2;
        this.scoreMode = scoreMode;
        this.approximation = scoreMode == ScoreMode.TOP_SCORES ? (DocIdSetIterator)new DocIdSetIteratorWrapper(disi) : disi;
        this.twoPhaseIterator = null;
        this.disi = this.approximation;
    }

    public ConstantScoreScorer(float score2, @Nullable ScoreMode scoreMode, final @NotNull TwoPhaseIterator twoPhaseIterator2) {
        Intrinsics.checkNotNullParameter((Object)twoPhaseIterator2, (String)"twoPhaseIterator");
        this.score = score2;
        this.scoreMode = scoreMode;
        if (scoreMode == ScoreMode.TOP_SCORES) {
            DocIdSetIteratorWrapper docIdSetIteratorWrapper = new DocIdSetIteratorWrapper(twoPhaseIterator2.approximation());
            this.approximation = docIdSetIteratorWrapper;
            this.twoPhaseIterator = new TwoPhaseIterator(docIdSetIteratorWrapper){

                @Override
                public boolean matches() throws IOException {
                    return twoPhaseIterator2.matches();
                }

                @Override
                public float matchCost() {
                    return twoPhaseIterator2.matchCost();
                }
            };
        } else {
            this.approximation = twoPhaseIterator2.approximation();
            this.twoPhaseIterator = twoPhaseIterator2;
        }
        this.disi = TwoPhaseIterator.Companion.asDocIdSetIterator(this.twoPhaseIterator);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.score;
    }

    @Override
    public float getMinCompetitiveScore() {
        return this.scoreMode == ScoreMode.TOP_SCORES ? this.score : 0.0f;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        if (this.scoreMode == ScoreMode.TOP_SCORES && minScore > this.score) {
            DocIdSetIterator docIdSetIterator = this.approximation;
            Intrinsics.checkNotNull((Object)docIdSetIterator, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.ConstantScoreScorer.DocIdSetIteratorWrapper");
            ((DocIdSetIteratorWrapper)docIdSetIterator).setDelegate(DocIdSetIterator.Companion.empty());
        }
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        return this.disi;
    }

    @Override
    @Nullable
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhaseIterator;
    }

    @Override
    public int docID() {
        return this.disi.docID();
    }

    @Override
    public float score() throws IOException {
        return this.score;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0002\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/search/ConstantScoreScorer$DocIdSetIteratorWrapper;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "delegate", "<init>", "(Lorg/gnit/lucenekmp/search/ConstantScoreScorer;Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "getDelegate", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "setDelegate", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;)V", "doc", "", "getDoc", "()I", "setDoc", "(I)V", "docID", "nextDoc", "advance", "target", "cost", "", "core"})
    @SourceDebugExtension(value={"SMAP\nConstantScoreScorer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantScoreScorer.kt\norg/gnit/lucenekmp/search/ConstantScoreScorer$DocIdSetIteratorWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
    private final class DocIdSetIteratorWrapper
    extends DocIdSetIterator {
        @NotNull
        private DocIdSetIterator delegate;
        private int doc;

        public DocIdSetIteratorWrapper(DocIdSetIterator delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.doc = -1;
        }

        @NotNull
        public final DocIdSetIterator getDelegate() {
            return this.delegate;
        }

        public final void setDelegate(@NotNull DocIdSetIterator docIdSetIterator) {
            Intrinsics.checkNotNullParameter((Object)docIdSetIterator, (String)"<set-?>");
            this.delegate = docIdSetIterator;
        }

        public final int getDoc() {
            return this.doc;
        }

        public final void setDoc(int n) {
            this.doc = n;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            int n;
            int it = n = this.delegate.nextDoc();
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public int advance(int target) throws IOException {
            int n;
            int it = n = this.delegate.advance(target);
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public long cost() {
            return this.delegate.cost();
        }
    }
}

