/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.DenseConjunctionBulkScorer;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/ConstantScoreScorerSupplier;", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "score", "", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "maxDoc", "", "<init>", "(FLorg/gnit/lucenekmp/search/ScoreMode;I)V", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "leadCost", "", "get", "Lorg/gnit/lucenekmp/search/Scorer;", "bulkScorer", "Lorg/gnit/lucenekmp/search/BulkScorer;", "Companion", "core"})
public abstract class ConstantScoreScorerSupplier
extends ScorerSupplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float score;
    @NotNull
    private final ScoreMode scoreMode;
    private final int maxDoc;

    protected ConstantScoreScorerSupplier(float score2, @NotNull ScoreMode scoreMode, int maxDoc) {
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        this.score = score2;
        this.scoreMode = scoreMode;
        this.maxDoc = maxDoc;
    }

    @NotNull
    public abstract DocIdSetIterator iterator(long var1) throws IOException;

    @Override
    @NotNull
    public Scorer get(long leadCost) throws IOException {
        DocIdSetIterator iterator2 = this.iterator(leadCost);
        TwoPhaseIterator twoPhase = TwoPhaseIterator.Companion.unwrap(iterator2);
        if (twoPhase == null) {
            return new ConstantScoreScorer(this.score, this.scoreMode, iterator2);
        }
        return new ConstantScoreScorer(this.score, this.scoreMode, twoPhase);
    }

    @Override
    @NotNull
    public BulkScorer bulkScorer() throws IOException {
        DocIdSetIterator iterator2 = this.iterator(Long.MAX_VALUE);
        if (this.maxDoc >= 2048 && iterator2.cost() >= (long)(this.maxDoc / 32) && TwoPhaseIterator.Companion.unwrap(iterator2) == null) {
            Object[] objectArray = new DocIdSetIterator[]{iterator2};
            return new DenseConjunctionBulkScorer(CollectionsKt.mutableListOf((Object[])objectArray), this.maxDoc, this.score);
        }
        return new Weight.DefaultBulkScorer(new ConstantScoreScorer(this.score, this.scoreMode, iterator2));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/search/ConstantScoreScorerSupplier$Companion;", "", "<init>", "()V", "fromIterator", "Lorg/gnit/lucenekmp/search/ConstantScoreScorerSupplier;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "score", "", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "maxDoc", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConstantScoreScorerSupplier fromIterator(@NotNull DocIdSetIterator iterator2, float score2, @NotNull ScoreMode scoreMode, int maxDoc) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
            return new ConstantScoreScorerSupplier(score2, scoreMode, maxDoc, iterator2){
                final /* synthetic */ DocIdSetIterator $iterator;
                {
                    this.$iterator = $iterator;
                    super($score, $scoreMode, $maxDoc);
                }

                public long cost() {
                    return this.$iterator.cost();
                }

                public DocIdSetIterator iterator(long leadCost) throws IOException {
                    return this.$iterator;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

