/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.MatchesIterator;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.TermMatchesIterator;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefIterator;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMatchesIterator;", "Lorg/gnit/lucenekmp/search/MatchesIterator;", "matches", "", "<init>", "(Ljava/util/List;)V", "queue", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "started", "", "next", "startPosition", "", "endPosition", "startOffset", "endOffset", "subMatches", "getSubMatches", "()Lorg/gnit/lucenekmp/search/MatchesIterator;", "query", "Lorg/gnit/lucenekmp/search/Query;", "getQuery", "()Lorg/gnit/lucenekmp/search/Query;", "TermsEnumDisjunctionMatchesIterator", "Companion", "core"})
public final class DisjunctionMatchesIterator
implements MatchesIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PriorityQueue<MatchesIterator> queue;
    private boolean started;

    private DisjunctionMatchesIterator(List<MatchesIterator> matches2) {
        int n = matches2.size();
        this.queue = new PriorityQueue<MatchesIterator>(n){

            @Override
            public boolean lessThan(MatchesIterator a, MatchesIterator b) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                if (a.startPosition() == -1 && b.startPosition() == -1) {
                    try {
                        return a.startOffset() < b.startOffset() || a.startOffset() == b.startOffset() && a.endOffset() < b.endOffset() || a.startOffset() == b.startOffset() && a.endOffset() == b.endOffset();
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Failed to retrieve term offset", e);
                    }
                }
                return a.startPosition() < b.startPosition() || a.startPosition() == b.startPosition() && a.endPosition() < b.endPosition() || a.startPosition() == b.startPosition() && a.endPosition() == b.endPosition();
            }
        };
        for (MatchesIterator mi : matches2) {
            if (!mi.next()) continue;
            (this.queue).add(mi);
        }
    }

    @Override
    public boolean next() throws IOException {
        if (!this.started) {
            this.started = true;
            return this.queue.size() > 0;
        }
        if (!this.queue.top().next()) {
            this.queue.pop();
        }
        if (this.queue.size() > 0) {
            this.queue.updateTop();
            return true;
        }
        return false;
    }

    @Override
    public int startPosition() {
        return this.queue.top().startPosition();
    }

    @Override
    public int endPosition() {
        return this.queue.top().endPosition();
    }

    @Override
    public int startOffset() throws IOException {
        return this.queue.top().startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.queue.top().endOffset();
    }

    @Override
    @Nullable
    public MatchesIterator getSubMatches() {
        return this.queue.top().getSubMatches();
    }

    @Override
    @NotNull
    public Query getQuery() {
        return this.queue.top().getQuery();
    }

    public /* synthetic */ DisjunctionMatchesIterator(List matches2, DefaultConstructorMarker $constructor_marker) {
        this(matches2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J0\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMatchesIterator$Companion;", "", "<init>", "()V", "fromTerms", "Lorg/gnit/lucenekmp/search/MatchesIterator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "doc", "", "query", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "terms", "", "Lorg/gnit/lucenekmp/index/Term;", "asBytesRefIterator", "Lorg/gnit/lucenekmp/util/BytesRefIterator;", "fromTermsEnum", "fromSubIterators", "mis", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MatchesIterator fromTerms(@NotNull LeafReaderContext context, int doc, @NotNull Query query, @NotNull String field, @NotNull List<Term> terms) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter(terms, (String)"terms");
            for (Term term : terms) {
                if (Intrinsics.areEqual((Object)field, (Object)term.field())) continue;
                boolean bl = false;
                String string = "Tried to generate iterator from terms in multiple fields: expected [" + field + "] but got [" + term.field() + "]";
                throw new IllegalArgumentException(string.toString());
            }
            return this.fromTermsEnum(context, doc, query, field, this.asBytesRefIterator(terms));
        }

        private final BytesRefIterator asBytesRefIterator(List<Term> terms) {
            return new BytesRefIterator(terms){
                private int i;
                final /* synthetic */ List<Term> $terms;
                {
                    this.$terms = $terms;
                }

                public final int getI() {
                    return this.i;
                }

                public final void setI(int n) {
                    this.i = n;
                }

                public BytesRef next() {
                    if (this.i >= this.$terms.size()) {
                        return null;
                    }
                    int n = this.i;
                    this.i = n + 1;
                    return this.$terms.get(n).bytes();
                }
            };
        }

        @Nullable
        public final MatchesIterator fromTermsEnum(@NotNull LeafReaderContext context, int doc, @NotNull Query query, @NotNull String field, @NotNull BytesRefIterator terms) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            Terms t = Terms.Companion.getTerms(context.reader(), field);
            TermsEnum te = t.iterator();
            PostingsEnum reuse = null;
            BytesRef term = terms.next();
            while (term != null) {
                if (te.seekExact(term)) {
                    PostingsEnum pe = te.postings(reuse, PostingsEnum.Companion.getOFFSETS());
                    if (pe.advance(doc) == doc) {
                        return new TermsEnumDisjunctionMatchesIterator(new TermMatchesIterator(query, pe), terms, te, doc, query);
                    }
                    reuse = pe;
                }
                term = terms.next();
            }
            return null;
        }

        @Nullable
        public final MatchesIterator fromSubIterators(@NotNull List<MatchesIterator> mis) throws IOException {
            Intrinsics.checkNotNullParameter(mis, (String)"mis");
            if (mis.size() == 0) {
                return null;
            }
            if (mis.size() == 1) {
                return mis.get(0);
            }
            return new DisjunctionMatchesIterator(mis, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMatchesIterator$TermsEnumDisjunctionMatchesIterator;", "Lorg/gnit/lucenekmp/search/MatchesIterator;", "first", "terms", "Lorg/gnit/lucenekmp/util/BytesRefIterator;", "te", "Lorg/gnit/lucenekmp/index/TermsEnum;", "doc", "", "query", "Lorg/gnit/lucenekmp/search/Query;", "<init>", "(Lorg/gnit/lucenekmp/search/MatchesIterator;Lorg/gnit/lucenekmp/util/BytesRefIterator;Lorg/gnit/lucenekmp/index/TermsEnum;ILorg/gnit/lucenekmp/search/Query;)V", "getQuery", "()Lorg/gnit/lucenekmp/search/Query;", "setQuery", "(Lorg/gnit/lucenekmp/search/Query;)V", "it", "init", "", "next", "", "startPosition", "endPosition", "startOffset", "endOffset", "subMatches", "getSubMatches", "()Lorg/gnit/lucenekmp/search/MatchesIterator;", "core"})
    private static final class TermsEnumDisjunctionMatchesIterator
    implements MatchesIterator {
        @NotNull
        private final MatchesIterator first;
        @NotNull
        private final BytesRefIterator terms;
        @NotNull
        private final TermsEnum te;
        private final int doc;
        @NotNull
        private Query query;
        @Nullable
        private MatchesIterator it;

        public TermsEnumDisjunctionMatchesIterator(@NotNull MatchesIterator first, @NotNull BytesRefIterator terms, @NotNull TermsEnum te, int doc, @NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            Intrinsics.checkNotNullParameter((Object)te, (String)"te");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            this.first = first;
            this.terms = terms;
            this.te = te;
            this.doc = doc;
            this.setQuery(query);
        }

        @Override
        @NotNull
        public Query getQuery() {
            MatchesIterator matchesIterator = this.it;
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator.getQuery();
        }

        public void setQuery(@NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"<set-?>");
            this.query = query;
        }

        public final void init() throws IOException {
            List mis = new ArrayList();
            mis.add(this.first);
            PostingsEnum reuse = null;
            BytesRef term = this.terms.next();
            while (term != null) {
                if (this.te.seekExact(term)) {
                    PostingsEnum pe = this.te.postings(reuse, PostingsEnum.Companion.getOFFSETS());
                    if (pe.advance(this.doc) == this.doc) {
                        mis.add(new TermMatchesIterator(this.getQuery(), pe));
                        reuse = null;
                    } else {
                        reuse = pe;
                    }
                }
                term = this.terms.next();
            }
            this.it = Companion.fromSubIterators(mis);
        }

        @Override
        public boolean next() throws IOException {
            if (this.it == null) {
                this.init();
            }
            if (this.it == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            MatchesIterator matchesIterator = this.it;
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator.next();
        }

        @Override
        public int startPosition() {
            MatchesIterator matchesIterator = this.it;
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator.startPosition();
        }

        @Override
        public int endPosition() {
            MatchesIterator matchesIterator = this.it;
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator.endPosition();
        }

        @Override
        public int startOffset() throws IOException {
            MatchesIterator matchesIterator = this.it;
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            MatchesIterator matchesIterator = this.it;
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator.endOffset();
        }

        @Override
        @Nullable
        public MatchesIterator getSubMatches() {
            MatchesIterator matchesIterator = this.it;
            Intrinsics.checkNotNull((Object)matchesIterator);
            return matchesIterator.getSubMatches();
        }
    }
}

