/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.DisjunctionMaxBulkScorer;
import org.gnit.lucenekmp.search.DisjunctionMaxScorer;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.MatchesUtils;
import org.gnit.lucenekmp.search.Multiset;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u0001(B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0096\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000H\u0002J\b\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMaxQuery;", "Lorg/gnit/lucenekmp/search/Query;", "", "disjuncts", "", "tieBreakerMultiplier", "", "<init>", "(Ljava/util/Collection;F)V", "Lorg/gnit/lucenekmp/search/Multiset;", "orderedQueries", "", "getTieBreakerMultiplier", "()F", "iterator", "", "getDisjuncts", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "rewrite", "indexSearcher", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "toString", "", "field", "equals", "", "other", "", "equalsTo", "hashCode", "", "DisjunctionMaxWeight", "core"})
@SourceDebugExtension(value={"SMAP\nDisjunctionMaxQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisjunctionMaxQuery.kt\norg/gnit/lucenekmp/search/DisjunctionMaxQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n1#2:314\n1563#3:315\n1634#3,3:316\n*S KotlinDebug\n*F\n+ 1 DisjunctionMaxQuery.kt\norg/gnit/lucenekmp/search/DisjunctionMaxQuery\n*L\n273#1:315\n273#1:316,3\n*E\n"})
public class DisjunctionMaxQuery
extends Query
implements Iterable<Query>,
KMappedMarker {
    @NotNull
    private final Multiset<Query> disjuncts;
    @NotNull
    private final List<Query> orderedQueries;
    private final float tieBreakerMultiplier;

    public DisjunctionMaxQuery(@NotNull Collection<? extends Query> disjuncts, float tieBreakerMultiplier) {
        Intrinsics.checkNotNullParameter(disjuncts, (String)"disjuncts");
        this.disjuncts = new Multiset();
        if (!(!(tieBreakerMultiplier < 0.0f) && !(tieBreakerMultiplier > 1.0f))) {
            boolean bl = false;
            String string = "tieBreakerMultiplier must be in [0, 1]";
            throw new IllegalArgumentException(string.toString());
        }
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.disjuncts.addAll(disjuncts);
        this.orderedQueries = new ArrayList<Query>(disjuncts);
    }

    public final float getTieBreakerMultiplier() {
        return this.tieBreakerMultiplier;
    }

    @Override
    @NotNull
    public Iterator<Query> iterator() {
        return this.getDisjuncts().iterator();
    }

    @NotNull
    public final Collection<Query> getDisjuncts() {
        return CollectionsKt.toMutableList((Collection)((Collection)((Object)this.disjuncts)));
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        return new DisjunctionMaxWeight(searcher, scoreMode, boost);
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        if (this.disjuncts.isEmpty()) {
            return new MatchNoDocsQuery("empty DisjunctionMaxQuery");
        }
        if (this.disjuncts.size() == 1) {
            return this.disjuncts.iterator().next();
        }
        if (this.tieBreakerMultiplier == 1.0f) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            Iterator<Query> iterator2 = this.disjuncts.iterator();
            while (iterator2.hasNext()) {
                Query sub = iterator2.next();
                builder.add(sub, BooleanClause.Occur.SHOULD);
            }
            return builder.build();
        }
        boolean actuallyRewritten = false;
        List rewrittenDisjuncts = new ArrayList();
        Iterator<Query> iterator3 = this.disjuncts.iterator();
        while (iterator3.hasNext()) {
            Query sub = iterator3.next();
            Query rewrittenSub = sub.rewrite(indexSearcher);
            actuallyRewritten |= !Intrinsics.areEqual((Object)rewrittenSub, (Object)sub);
            rewrittenDisjuncts.add(rewrittenSub);
        }
        if (actuallyRewritten) {
            return new DisjunctionMaxQuery(rewrittenDisjuncts, this.tieBreakerMultiplier);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        QueryVisitor v = visitor2.getSubVisitor(BooleanClause.Occur.SHOULD, this);
        Iterator<Query> iterator2 = this.disjuncts.iterator();
        while (iterator2.hasNext()) {
            Query q = iterator2.next();
            q.visit(v);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString(@Nullable String field) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.orderedQueries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void subquery;
            Query query = (Query)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(subquery instanceof BooleanQuery ? "(" + ((BooleanQuery)subquery).toString(field) + ")" : subquery.toString(field));
        }
        List queryStrings = (List)destination$iv$iv;
        String tieBreaker = !(this.tieBreakerMultiplier == 0.0f) ? "~" + this.tieBreakerMultiplier : "";
        return "(" + CollectionsKt.joinToString$default((Iterable)queryStrings, (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null) + ")" + tieBreaker;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other) && this.equalsTo((DisjunctionMaxQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean equalsTo(DisjunctionMaxQuery other) {
        return this.tieBreakerMultiplier == other.tieBreakerMultiplier && Intrinsics.areEqual(this.disjuncts, other.disjuncts);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, this.tieBreakerMultiplier);
        h = 31 * h + Objects.INSTANCE.hashCode(this.disjuncts);
        return h;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R$\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u000bj\b\u0012\u0004\u0012\u00020\u0001`\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionMaxQuery$DisjunctionMaxWeight;", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "<init>", "(Lorg/gnit/lucenekmp/search/DisjunctionMaxQuery;Lorg/gnit/lucenekmp/search/IndexSearcher;Lorg/gnit/lucenekmp/search/ScoreMode;F)V", "weights", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getWeights", "()Ljava/util/ArrayList;", "matches", "Lorg/gnit/lucenekmp/search/Matches;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "doc", "", "scorerSupplier", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "isCacheable", "", "ctx", "explain", "Lorg/gnit/lucenekmp/search/Explanation;", "core"})
    protected class DisjunctionMaxWeight
    extends Weight {
        @NotNull
        private final ArrayList<Weight> weights;
        @NotNull
        private final ScoreMode scoreMode;

        public DisjunctionMaxWeight(@NotNull IndexSearcher searcher, ScoreMode scoreMode, float boost) {
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
            super(DisjunctionMaxQuery.this);
            this.weights = new ArrayList();
            Iterator iterator2 = DisjunctionMaxQuery.this.disjuncts.iterator();
            while (iterator2.hasNext()) {
                Query disjunctQuery = (Query)iterator2.next();
                this.weights.add(searcher.createWeight(disjunctQuery, scoreMode, boost));
            }
            this.scoreMode = scoreMode;
        }

        @NotNull
        protected final ArrayList<Weight> getWeights() {
            return this.weights;
        }

        @Override
        @NotNull
        public Matches matches(@NotNull LeafReaderContext context, int doc) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            List mis = new ArrayList();
            Iterator<Weight> iterator2 = this.weights.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Weight> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Weight weight;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                Matches mi = weight.matches(context, doc);
                if (mi == null) continue;
                mis.add(mi);
            }
            Matches matches2 = MatchesUtils.INSTANCE.fromSubMatches(mis);
            Intrinsics.checkNotNull((Object)matches2);
            return matches2;
        }

        @Override
        @Nullable
        public ScorerSupplier scorerSupplier(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            List scorerSuppliers = new ArrayList();
            Iterator<Weight> iterator2 = this.weights.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Weight> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Weight w;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                ScorerSupplier ss = w.scorerSupplier(context);
                if (ss == null) continue;
                scorerSuppliers.add(ss);
            }
            if (scorerSuppliers.isEmpty()) {
                return null;
            }
            if (scorerSuppliers.size() == 1) {
                return (ScorerSupplier)scorerSuppliers.get(0);
            }
            return new ScorerSupplier(scorerSuppliers, DisjunctionMaxQuery.this, this){
                private long cost;
                final /* synthetic */ List<ScorerSupplier> $scorerSuppliers;
                final /* synthetic */ DisjunctionMaxQuery this$0;
                final /* synthetic */ DisjunctionMaxWeight this$1;
                {
                    this.$scorerSuppliers = $scorerSuppliers;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.cost = -1L;
                }

                public Scorer get(long leadCost) throws IOException {
                    List scorers = new ArrayList<E>();
                    for (ScorerSupplier ss : this.$scorerSuppliers) {
                        scorers.add(ss.get(leadCost));
                    }
                    return new DisjunctionMaxScorer(this.this$0.getTieBreakerMultiplier(), scorers, DisjunctionMaxWeight.access$getScoreMode$p(this.this$1), leadCost);
                }

                public BulkScorer bulkScorer() throws IOException {
                    if (this.this$0.getTieBreakerMultiplier() == 0.0f && DisjunctionMaxWeight.access$getScoreMode$p(this.this$1) == ScoreMode.TOP_SCORES) {
                        List scorers = new ArrayList<E>();
                        for (ScorerSupplier ss : this.$scorerSuppliers) {
                            BulkScorer bulkScorer = ss.bulkScorer();
                            Intrinsics.checkNotNull((Object)bulkScorer);
                            scorers.add(bulkScorer);
                        }
                        return new DisjunctionMaxBulkScorer(scorers);
                    }
                    return super.bulkScorer();
                }

                public long cost() {
                    if (this.cost == -1L) {
                        long cost = 0L;
                        for (ScorerSupplier ss : this.$scorerSuppliers) {
                            cost += ss.cost();
                        }
                        this.cost = cost;
                    }
                    return this.cost;
                }

                public void setTopLevelScoringClause() {
                    if (this.this$0.getTieBreakerMultiplier() == 0.0f) {
                        for (ScorerSupplier ss : this.$scorerSuppliers) {
                            ss.setTopLevelScoringClause();
                        }
                    }
                }
            };
        }

        @Override
        public boolean isCacheable(@NotNull LeafReaderContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this.weights.size() > 16) {
                return false;
            }
            Iterator<Weight> iterator2 = this.weights.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Weight> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Weight w;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                if (w.isCacheable(ctx)) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public Explanation explain(@NotNull LeafReaderContext context, int doc) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            boolean match = false;
            double max = 0.0;
            double otherSum = 0.0;
            List subsOnMatch = new ArrayList();
            List subsOnNoMatch = new ArrayList();
            Iterator<Weight> iterator2 = this.weights.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Weight> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Weight wt;
                Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                Explanation e = wt.explain(context, doc);
                if (e.isMatch()) {
                    match = true;
                    subsOnMatch.add(e);
                    double score2 = e.getValue().doubleValue();
                    if (score2 >= max) {
                        otherSum += max;
                        max = score2;
                        continue;
                    }
                    otherSum += score2;
                    continue;
                }
                if (match) continue;
                subsOnNoMatch.add(e);
            }
            if (match) {
                float score3 = (float)(max + otherSum * (double)DisjunctionMaxQuery.this.getTieBreakerMultiplier());
                String desc = DisjunctionMaxQuery.this.getTieBreakerMultiplier() == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.getTieBreakerMultiplier() + " times others of:";
                return Explanation.Companion.match((Number)Float.valueOf(score3), desc, subsOnMatch);
            }
            return Explanation.Companion.noMatch("No matching clause", subsOnNoMatch);
        }

        public static final /* synthetic */ ScoreMode access$getScoreMode$p(DisjunctionMaxWeight $this) {
            return $this.scoreMode;
        }
    }
}

