/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.search.Scorer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionScoreBlockBoundaryPropagator;", "", "scorers", "", "Lorg/gnit/lucenekmp/search/Scorer;", "<init>", "(Ljava/util/Collection;)V", "", "[Lorg/gnit/lucenekmp/search/Scorer;", "maxScores", "", "leadIndex", "", "advanceShallow", "target", "setMinCompetitiveScore", "", "minScore", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDisjunctionScoreBlockBoundaryPropagator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisjunctionScoreBlockBoundaryPropagator.kt\norg/gnit/lucenekmp/search/DisjunctionScoreBlockBoundaryPropagator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n37#2:97\n36#2,3:98\n*S KotlinDebug\n*F\n+ 1 DisjunctionScoreBlockBoundaryPropagator.kt\norg/gnit/lucenekmp/search/DisjunctionScoreBlockBoundaryPropagator\n*L\n17#1:97\n17#1:98,3\n*E\n"})
public final class DisjunctionScoreBlockBoundaryPropagator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scorer[] scorers;
    @NotNull
    private final float[] maxScores;
    private int leadIndex;
    @NotNull
    private static final Comparator<Scorer> MAX_SCORE_COMPARATOR;

    public DisjunctionScoreBlockBoundaryPropagator(@NotNull Collection<Scorer> scorers) {
        Intrinsics.checkNotNullParameter(scorers, (String)"scorers");
        Scorer[] $this$toTypedArray$iv = scorers;
        boolean $i$f$toTypedArray = false;
        Scorer[] thisCollection$iv = $this$toTypedArray$iv;
        this.scorers = thisCollection$iv.toArray(new Scorer[0]);
        for (Scorer scorer2 : this.scorers) {
            scorer2.advanceShallow(0);
        }
        Arrays.INSTANCE.sort(this.scorers, MAX_SCORE_COMPARATOR);
        this.maxScores = new float[this.scorers.length];
        int n = this.scorers.length;
        for (int i = 0; i < n; ++i) {
            this.maxScores[i] = this.scorers[i].getMaxScore(Integer.MAX_VALUE);
        }
    }

    public final int advanceShallow(int target) throws IOException {
        Scorer scorer2;
        int i;
        int n = this.leadIndex;
        for (int i2 = 0; i2 < n; ++i2) {
            Scorer s = this.scorers[i2];
            if (s.docID() >= target) continue;
            s.advanceShallow(target);
        }
        Scorer leadScorer = this.scorers[this.leadIndex];
        int upTo = leadScorer.advanceShallow(Math.max(leadScorer.docID(), target));
        int n2 = this.scorers.length;
        for (i = this.leadIndex + 1; i < n2; ++i) {
            scorer2 = this.scorers[i];
            if (scorer2.docID() > target) continue;
            upTo = Math.min(scorer2.advanceShallow(target), upTo);
        }
        n2 = this.leadIndex + 1;
        i = this.scorers.length - 1;
        if (n2 <= i) {
            while ((scorer2 = this.scorers[i]).docID() > target) {
                upTo = Math.min(upTo, scorer2.docID() - 1);
                if (i == n2) break;
                --i;
            }
        }
        return upTo;
    }

    public final void setMinCompetitiveScore(float minScore) throws IOException {
        while (this.leadIndex < this.maxScores.length - 1 && minScore > this.maxScores[this.leadIndex]) {
            int n = this.leadIndex;
            this.leadIndex = n + 1;
        }
    }

    static {
        Comparator comparator2 = new Comparator(){

            public final int compare(T a, T b) {
                Comparable comparable;
                Scorer scorer2 = (Scorer)a;
                boolean bl = false;
                try {
                    comparable = Float.valueOf(scorer2.getMaxScore(Integer.MAX_VALUE));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                scorer2 = (Scorer)b;
                Comparable comparable2 = comparable;
                bl = false;
                try {
                    comparable = Float.valueOf(scorer2.getMaxScore(Integer.MAX_VALUE));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable);
            }
        };
        MAX_SCORE_COMPARATOR = new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Scorer scorer2 = (Scorer)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(scorer2.iterator().cost());
                    scorer2 = (Scorer)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(scorer2.iterator().cost()));
                }
                return n;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionScoreBlockBoundaryPropagator$Companion;", "", "<init>", "()V", "MAX_SCORE_COMPARATOR", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/search/Scorer;", "Lkotlin/Comparator;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

