/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.search.DisiWrapper;
import org.gnit.lucenekmp.search.DisjunctionScorer;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/search/DisjunctionSumScorer;", "Lorg/gnit/lucenekmp/search/DisjunctionScorer;", "scorers", "", "Lorg/gnit/lucenekmp/search/Scorer;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "leadCost", "", "<init>", "(Ljava/util/List;Lorg/gnit/lucenekmp/search/ScoreMode;J)V", "score", "", "topList", "Lorg/gnit/lucenekmp/search/DisiWrapper;", "advanceShallow", "", "target", "getMaxScore", "upTo", "core"})
public final class DisjunctionSumScorer
extends DisjunctionScorer {
    @NotNull
    private final List<Scorer> scorers;

    public DisjunctionSumScorer(@NotNull List<Scorer> scorers, @Nullable ScoreMode scoreMode, long leadCost) {
        Intrinsics.checkNotNullParameter(scorers, (String)"scorers");
        super(scorers, scoreMode, leadCost);
        this.scorers = scorers;
    }

    @Override
    protected float score(@Nullable DisiWrapper topList) throws IOException {
        double score2 = 0.0;
        for (DisiWrapper w = topList; w != null; w = w.getNext()) {
            Scorable scorable = w.getScorable();
            Intrinsics.checkNotNull((Object)scorable);
            score2 += (double)scorable.score();
        }
        return (float)score2;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        int min = Integer.MAX_VALUE;
        for (Scorer scorer2 : this.scorers) {
            if (scorer2.docID() > target) continue;
            min = Math.min(min, scorer2.advanceShallow(target));
        }
        return min;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double maxScore = 0.0;
        for (Scorer scorer2 : this.scorers) {
            if (scorer2.docID() > upTo) continue;
            maxScore += (double)scorer2.getMaxScore(upTo);
        }
        return (float)MathUtil.INSTANCE.sumUpperBound(maxScore, this.scorers.size());
    }
}

