/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.Impact;
import org.gnit.lucenekmp.index.Impacts;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.ImpactsSource;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.search.ConjunctionUtils;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.ExactPhraseMatcher;
import org.gnit.lucenekmp.search.ImpactsDISI;
import org.gnit.lucenekmp.search.MaxScoreCache;
import org.gnit.lucenekmp.search.PhraseMatcher;
import org.gnit.lucenekmp.search.PhraseQuery;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/search/ExactPhraseMatcher;", "Lorg/gnit/lucenekmp/search/PhraseMatcher;", "postings", "", "Lorg/gnit/lucenekmp/search/PhraseQuery$PostingsAndFreq;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "scorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "matchCost", "", "<init>", "([Lorg/gnit/lucenekmp/search/PhraseQuery$PostingsAndFreq;Lorg/gnit/lucenekmp/search/ScoreMode;Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;F)V", "Lorg/gnit/lucenekmp/search/ExactPhraseMatcher$PostingsAndPosition;", "[Lorg/gnit/lucenekmp/search/ExactPhraseMatcher$PostingsAndPosition;", "approximation", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "impactsApproximation", "Lorg/gnit/lucenekmp/search/ImpactsDISI;", "maxFreq", "reset", "", "nextMatch", "", "sloppyWeight", "startPosition", "", "endPosition", "startOffset", "endOffset", "PostingsAndPosition", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nExactPhraseMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExactPhraseMatcher.kt\norg/gnit/lucenekmp/search/ExactPhraseMatcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,334:1\n11228#2:335\n11563#2,3:336\n11228#2:339\n11563#2,3:340\n37#3:343\n36#3,3:344\n37#3:347\n36#3,3:348\n*S KotlinDebug\n*F\n+ 1 ExactPhraseMatcher.kt\norg/gnit/lucenekmp/search/ExactPhraseMatcher\n*L\n38#1:335\n38#1:336,3\n39#1:339\n39#1:340,3\n39#1:343\n39#1:344,3\n60#1:347\n60#1:348,3\n*E\n"})
public final class ExactPhraseMatcher
extends PhraseMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostingsAndPosition[] postings;
    @NotNull
    private final DocIdSetIterator approximation;
    @NotNull
    private final ImpactsDISI impactsApproximation;

    /*
     * WARNING - void declaration
     */
    public ExactPhraseMatcher(@NotNull PhraseQuery.PostingsAndFreq[] postings, @NotNull ScoreMode scoreMode, @NotNull Similarity.SimScorer scorer2, float matchCost) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)postings, (String)"postings");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        super(matchCost);
        PhraseQuery.PostingsAndFreq[] postingsAndFreqArray = postings;
        Object object = ConjunctionUtils.INSTANCE;
        boolean $i$f$map22 = false;
        void var8_9 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv2).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv2).length;
        for (int i = 0; i < n; ++i) {
            void p;
            void item$iv$iv;
            void var14_20 = item$iv$iv = $this$mapTo$iv$iv2[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p.getPostings());
        }
        DocIdSetIterator approximation2 = ((ConjunctionUtils)object).intersectIterators(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)));
        PhraseQuery.PostingsAndFreq[] $i$f$map22 = postings;
        object = Companion;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo2 = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            void p;
            void item$iv$iv;
            void bl = item$iv$iv = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(p.getImpacts());
        }
        $this$map$iv = (List)destination$iv$iv2;
        int $i$f$toTypedArray = 0;
        void thisCollection$iv = $this$toTypedArray$iv;
        ImpactsSource impactsSource2 = ((Companion)object).mergeImpacts(thisCollection$iv.toArray(new ImpactsEnum[0]));
        this.impactsApproximation = new ImpactsDISI(approximation2, new MaxScoreCache(impactsSource2, scorer2));
        this.approximation = scoreMode == ScoreMode.TOP_SCORES ? (DocIdSetIterator)this.impactsApproximation : approximation2;
        List postingsAndPositions = new ArrayList();
        for (PhraseQuery.PostingsAndFreq posting : postings) {
            postingsAndPositions.add(new PostingsAndPosition(posting.getPostings(), posting.getPosition()));
        }
        Collection $this$toTypedArray$iv2 = postingsAndPositions;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        this.postings = thisCollection$iv2.toArray(new PostingsAndPosition[0]);
    }

    @Override
    @NotNull
    public DocIdSetIterator approximation() {
        return this.approximation;
    }

    @Override
    @NotNull
    public ImpactsDISI impactsApproximation() {
        return this.impactsApproximation;
    }

    @Override
    public float maxFreq() {
        int minFreq = this.postings[0].getFreq();
        int n = this.postings.length;
        for (int i = 1; i < n; ++i) {
            minFreq = Math.min(minFreq, this.postings[i].getFreq());
        }
        return minFreq;
    }

    @Override
    public void reset() throws IOException {
        for (PostingsAndPosition posting : this.postings) {
            posting.setFreq(posting.getPostings().freq());
            posting.setPos(-1);
            posting.setUpTo(0);
        }
    }

    @Override
    public boolean nextMatch() throws IOException {
        block5: {
            PostingsAndPosition lead = this.postings[0];
            if (lead.getUpTo() >= lead.getFreq()) {
                return false;
            }
            lead.setPos(lead.getPostings().nextPosition());
            lead.setUpTo(lead.getUpTo() + 1);
            block0: while (true) {
                int phrasePos = lead.getPos() - lead.getOffset();
                int n = this.postings.length;
                for (int j = 1; j < n; ++j) {
                    PostingsAndPosition posting = this.postings[j];
                    int expectedPos = phrasePos + posting.getOffset();
                    if (ExactPhraseMatcher.Companion.advancePosition(posting, expectedPos)) {
                        if (posting.getPos() == expectedPos) continue;
                        if (ExactPhraseMatcher.Companion.advancePosition(lead, posting.getPos() - posting.getOffset() + lead.getOffset())) {
                            continue block0;
                        }
                    }
                    break block5;
                }
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    public float sloppyWeight() {
        return 1.0f;
    }

    @Override
    public int startPosition() {
        return this.postings[0].getPos();
    }

    @Override
    public int endPosition() {
        return this.postings[this.postings.length - 1].getPos();
    }

    @Override
    public int startOffset() throws IOException {
        return this.postings[0].getPostings().startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.postings[this.postings.length - 1].getPostings().endOffset();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0019\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/ExactPhraseMatcher$Companion;", "", "<init>", "()V", "advancePosition", "", "posting", "Lorg/gnit/lucenekmp/search/ExactPhraseMatcher$PostingsAndPosition;", "target", "", "mergeImpacts", "Lorg/gnit/lucenekmp/index/ImpactsSource;", "impactsEnums", "", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "([Lorg/gnit/lucenekmp/index/ImpactsEnum;)Lorg/gnit/lucenekmp/index/ImpactsSource;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean advancePosition(PostingsAndPosition posting, int target) throws IOException {
            while (posting.getPos() < target) {
                if (posting.getUpTo() == posting.getFreq()) {
                    return false;
                }
                posting.setPos(posting.getPostings().nextPosition());
                posting.setUpTo(posting.getUpTo() + 1);
            }
            return true;
        }

        @NotNull
        public final ImpactsSource mergeImpacts(@NotNull ImpactsEnum[] impactsEnums) {
            Intrinsics.checkNotNullParameter((Object)impactsEnums, (String)"impactsEnums");
            int tmpLeadIndex = -1;
            int n = impactsEnums.length;
            for (int i = 0; i < n; ++i) {
                if (tmpLeadIndex != -1 && impactsEnums[i].cost() >= impactsEnums[tmpLeadIndex].cost()) continue;
                tmpLeadIndex = i;
            }
            int leadIndex = tmpLeadIndex;
            return new ImpactsSource(impactsEnums, leadIndex){
                final /* synthetic */ ImpactsEnum[] $impactsEnums;
                final /* synthetic */ int $leadIndex;
                {
                    this.$impactsEnums = $impactsEnums;
                    this.$leadIndex = $leadIndex;
                }

                public Impacts getImpacts() {
                    int n = 0;
                    int n2 = this.$impactsEnums.length;
                    Impacts[] impactsArray = new Impacts[n2];
                    while (n < n2) {
                        int n3 = n++;
                        impactsArray[n3] = this.$impactsEnums[n3].getImpacts();
                    }
                    Impacts[] impacts2 = impactsArray;
                    Impacts lead = impacts2[this.$leadIndex];
                    return new Impacts(lead, impacts2, this){
                        final /* synthetic */ Impacts $lead;
                        final /* synthetic */ Impacts[] $impacts;
                        final /* synthetic */ mergeImpacts.1 this$0;
                        {
                            this.$lead = $lead;
                            this.$impacts = $impacts;
                            this.this$0 = $receiver;
                        }

                        public int numLevels() {
                            return this.$lead.numLevels();
                        }

                        public int getDocIdUpTo(int level) {
                            return this.$lead.getDocIdUpTo(level);
                        }

                        public final int getLevel(Impacts impacts2, int docIdUpTo) {
                            Intrinsics.checkNotNullParameter((Object)impacts2, (String)"impacts");
                            int numLevels = impacts2.numLevels();
                            for (int level = 0; level < numLevels; ++level) {
                                if (impacts2.getDocIdUpTo(level) < docIdUpTo) continue;
                                return level;
                            }
                            return -1;
                        }

                        public List<Impact> getImpacts(int level) {
                            int docIdUpTo = this.getDocIdUpTo(level);
                            int n = this.$impacts.length;
                            PriorityQueue pq2 = new PriorityQueue<mergeImpacts.SubIterator>(n){

                                public boolean lessThan(mergeImpacts.SubIterator a, mergeImpacts.SubIterator b) {
                                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                                    Impact impact = a.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact);
                                    int n = impact.getFreq();
                                    Impact impact2 = b.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact2);
                                    return n < impact2.getFreq();
                                }
                            };
                            boolean hasImpacts = false;
                            List<Impact> onlyImpactList = null;
                            List subIterators = new ArrayList<E>(this.$impacts.length);
                            int n2 = this.$impacts.length;
                            for (int i = 0; i < n2; ++i) {
                                List<Impact> impactList;
                                Impact firstImpact;
                                int impactsLevel = this.getLevel(this.$impacts[i], docIdUpTo);
                                if (impactsLevel == -1 || (firstImpact = (impactList = this.$impacts[i].getImpacts(impactsLevel)).get(0)).getFreq() == Integer.MAX_VALUE && firstImpact.getNorm() == 1L) continue;
                                mergeImpacts.SubIterator subIterator = new mergeImpacts.SubIterator(this.this$0, impactList);
                                subIterators.add(subIterator);
                                if (!hasImpacts) {
                                    hasImpacts = true;
                                    onlyImpactList = impactList;
                                    continue;
                                }
                                onlyImpactList = null;
                            }
                            if (!hasImpacts) {
                                Object[] i = new Impact[]{new Impact(Integer.MAX_VALUE, 1L)};
                                return CollectionsKt.mutableListOf((Object[])i);
                            }
                            if (onlyImpactList != null) {
                                return onlyImpactList;
                            }
                            pq2.addAll(subIterators);
                            List mergedImpacts = new ArrayList<E>();
                            mergeImpacts.SubIterator top = (mergeImpacts.SubIterator)pq2.top();
                            Impact impact = top.getCurrent();
                            Intrinsics.checkNotNull((Object)impact);
                            int currentFreq = impact.getFreq();
                            long currentNorm = 0L;
                            for (mergeImpacts.SubIterator it : pq2) {
                                Impact impact2 = it.getCurrent();
                                Intrinsics.checkNotNull((Object)impact2);
                                if (LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, impact2.getNorm(), currentNorm) <= 0) continue;
                                Impact impact3 = it.getCurrent();
                                Intrinsics.checkNotNull((Object)impact3);
                                currentNorm = impact3.getNorm();
                            }
                            block2: while (true) {
                                if (!((Collection)mergedImpacts).isEmpty() && ((Impact)mergedImpacts.get(mergedImpacts.size() - 1)).getNorm() == currentNorm) {
                                    ((Impact)mergedImpacts.get(mergedImpacts.size() - 1)).setFreq(currentFreq);
                                } else {
                                    mergedImpacts.add(new Impact(currentFreq, currentNorm));
                                }
                                while (top.next()) {
                                    Impact impact4 = top.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact4);
                                    if (LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, impact4.getNorm(), currentNorm) > 0) {
                                        Impact impact5 = top.getCurrent();
                                        Intrinsics.checkNotNull((Object)impact5);
                                        currentNorm = impact5.getNorm();
                                    }
                                    top = (mergeImpacts.SubIterator)pq2.updateTop();
                                    Impact impact6 = top.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact6);
                                    if (impact6.getFreq() == currentFreq) continue;
                                    Impact impact7 = top.getCurrent();
                                    Intrinsics.checkNotNull((Object)impact7);
                                    currentFreq = impact7.getFreq();
                                    continue block2;
                                }
                                break;
                            }
                            return mergedImpacts;
                        }
                    };
                }

                public void advanceShallow(int target) throws IOException {
                    for (ImpactsEnum impactsEnum : this.$impactsEnums) {
                        impactsEnum.advanceShallow(target);
                    }
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/search/ExactPhraseMatcher$PostingsAndPosition;", "", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/index/PostingsEnum;I)V", "getPostings", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "getOffset", "()I", "freq", "getFreq", "setFreq", "(I)V", "upTo", "getUpTo", "setUpTo", "pos", "getPos", "setPos", "core"})
    private static final class PostingsAndPosition {
        @NotNull
        private final PostingsEnum postings;
        private final int offset;
        private int freq;
        private int upTo;
        private int pos;

        public PostingsAndPosition(@NotNull PostingsEnum postings, int offset) {
            Intrinsics.checkNotNullParameter((Object)postings, (String)"postings");
            this.postings = postings;
            this.offset = offset;
        }

        @NotNull
        public final PostingsEnum getPostings() {
            return this.postings;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getFreq() {
            return this.freq;
        }

        public final void setFreq(int n) {
            this.freq = n;
        }

        public final int getUpTo() {
            return this.upTo;
        }

        public final void setUpTo(int n) {
            this.upTo = n;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }
    }
}

