/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.BaseTermsEnum;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.BoostAttribute;
import org.gnit.lucenekmp.search.FuzzyAutomatonBuilder;
import org.gnit.lucenekmp.search.MaxNonCompetitiveBoostAttribute;
import org.gnit.lucenekmp.util.Attribute;
import org.gnit.lucenekmp.util.AttributeImpl;
import org.gnit.lucenekmp.util.AttributeReflector;
import org.gnit.lucenekmp.util.AttributeSource;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.IOBooleanSupplier;
import org.gnit.lucenekmp.util.UnicodeUtil;
import org.gnit.lucenekmp.util.automaton.ByteRunAutomaton;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003EFGB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000b\u0010\u0012B9\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000b\u0010\u0013J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 J\u001a\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u000e2\b\u0010+\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010,\u001a\u00020%2\b\u0010+\u001a\u0004\u0018\u00010\"H\u0002J\n\u0010-\u001a\u0004\u0018\u00010\"H\u0016J\u0018\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u000eH\u0002J\b\u00101\u001a\u00020\u000eH\u0016J\b\u00102\u001a\u000203H\u0016J\u001a\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u0001052\u0006\u00107\u001a\u00020\u000eH\u0016J\u0010\u00108\u001a\u0002092\u0006\u00107\u001a\u00020\u000eH\u0016J\u0018\u0010:\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\"2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020<H\u0016J\b\u0010>\u001a\u000203H\u0016J\b\u0010?\u001a\u00020\u0005H\u0016J\u0010\u0010:\u001a\u00020\u00112\u0006\u0010@\u001a\u00020\"H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010@\u001a\u00020\"H\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010@\u001a\u00020\"H\u0016J\u0010\u0010:\u001a\u00020%2\u0006\u0010>\u001a\u000203H\u0016J\b\u0010\u0006\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006H"}, d2={"Lorg/gnit/lucenekmp/search/FuzzyTermsEnum;", "Lorg/gnit/lucenekmp/index/BaseTermsEnum;", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "atts", "Lorg/gnit/lucenekmp/util/AttributeSource;", "term", "Lorg/gnit/lucenekmp/index/Term;", "automatonBuilder", "Lkotlin/Function0;", "Lorg/gnit/lucenekmp/search/FuzzyAutomatonBuilder;", "<init>", "(Lorg/gnit/lucenekmp/index/Terms;Lorg/gnit/lucenekmp/util/AttributeSource;Lorg/gnit/lucenekmp/index/Term;Lkotlin/jvm/functions/Function0;)V", "maxEdits", "", "prefixLength", "transpositions", "", "(Lorg/gnit/lucenekmp/index/Terms;Lorg/gnit/lucenekmp/index/Term;IIZ)V", "(Lorg/gnit/lucenekmp/index/Terms;Lorg/gnit/lucenekmp/util/AttributeSource;Lorg/gnit/lucenekmp/index/Term;IIZ)V", "actualEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "boostAtt", "Lorg/gnit/lucenekmp/search/BoostAttribute;", "maxBoostAtt", "Lorg/gnit/lucenekmp/search/MaxNonCompetitiveBoostAttribute;", "automata", "", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "[Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "termLength", "bottom", "", "bottomTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "queuedBottom", "setMaxNonCompetitiveBoost", "", "boost", "getBoost", "()F", "getAutomatonEnum", "editDistance", "lastTerm", "bottomChanged", "next", "matches", "termIn", "k", "docFreq", "totalTermFreq", "", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "flags", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "seekExact", "state", "Lorg/gnit/lucenekmp/index/TermState;", "termState", "ord", "attributes", "text", "prepareSeekExact", "Lorg/gnit/lucenekmp/util/IOBooleanSupplier;", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "FuzzyTermsException", "AutomatonAttribute", "AutomatonAttributeImpl", "core"})
@SourceDebugExtension(value={"SMAP\nFuzzyTermsEnum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FuzzyTermsEnum.kt\norg/gnit/lucenekmp/search/FuzzyTermsEnum\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,406:1\n3#2,8:407\n10#3:415\n*S KotlinDebug\n*F\n+ 1 FuzzyTermsEnum.kt\norg/gnit/lucenekmp/search/FuzzyTermsEnum\n*L\n168#1:407,8\n168#1:415\n*E\n"})
public final class FuzzyTermsEnum
extends BaseTermsEnum {
    @NotNull
    private final Terms terms;
    @NotNull
    private final AttributeSource atts;
    @NotNull
    private final Term term;
    @Nullable
    private TermsEnum actualEnum;
    @NotNull
    private final BoostAttribute boostAtt;
    @NotNull
    private final MaxNonCompetitiveBoostAttribute maxBoostAtt;
    @NotNull
    private final CompiledAutomaton[] automata;
    private final int termLength;
    private float bottom;
    @Nullable
    private BytesRef bottomTerm;
    @Nullable
    private BytesRef queuedBottom;
    private int maxEdits;

    private FuzzyTermsEnum(Terms terms, AttributeSource atts, Term term, Function0<FuzzyAutomatonBuilder> automatonBuilder) {
        this.terms = terms;
        this.atts = atts;
        this.term = term;
        this.boostAtt = (BoostAttribute)this.atts.addAttribute(Reflection.getOrCreateKotlinClass(BoostAttribute.class));
        this.maxBoostAtt = (MaxNonCompetitiveBoostAttribute)this.atts.addAttribute(Reflection.getOrCreateKotlinClass(MaxNonCompetitiveBoostAttribute.class));
        this.atts.addAttributeImpl(new AutomatonAttributeImpl());
        AutomatonAttribute aa = (AutomatonAttribute)this.atts.addAttribute(Reflection.getOrCreateKotlinClass(AutomatonAttribute.class));
        aa.init(automatonBuilder);
        CompiledAutomaton[] compiledAutomatonArray = aa.getAutomata();
        Intrinsics.checkNotNull((Object)compiledAutomatonArray);
        this.automata = compiledAutomatonArray;
        this.termLength = aa.getTermLength();
        this.maxEdits = this.automata.length - 1;
        this.bottom = this.maxBoostAtt.getMaxNonCompetitiveBoost();
        this.bottomTerm = this.maxBoostAtt.getCompetitiveTerm();
        this.bottomChanged(null);
    }

    public FuzzyTermsEnum(@NotNull Terms terms, @NotNull Term term, int maxEdits, int prefixLength, boolean transpositions) {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this(terms, new AttributeSource(), term, (Function0<FuzzyAutomatonBuilder>)((Function0)() -> FuzzyTermsEnum._init_$lambda$0(term, maxEdits, prefixLength, transpositions)));
    }

    public FuzzyTermsEnum(@NotNull Terms terms, @NotNull AttributeSource atts, @NotNull Term term, int maxEdits, int prefixLength, boolean transpositions) {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        Intrinsics.checkNotNullParameter((Object)atts, (String)"atts");
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this(terms, atts, term, (Function0<FuzzyAutomatonBuilder>)((Function0)() -> FuzzyTermsEnum._init_$lambda$1(term, maxEdits, prefixLength, transpositions)));
    }

    public final void setMaxNonCompetitiveBoost(float boost) {
        this.maxBoostAtt.setMaxNonCompetitiveBoost(boost);
    }

    public final float getBoost() {
        return this.boostAtt.getBoost();
    }

    private final TermsEnum getAutomatonEnum(int editDistance, BytesRef lastTerm) throws IOException {
        boolean condition$iv = editDistance < this.automata.length;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        CompiledAutomaton compiled = this.automata[editDistance];
        BytesRef initialSeekTerm = lastTerm == null ? null : compiled.floor(lastTerm, new BytesRefBuilder());
        return this.terms.intersect(compiled, initialSeekTerm);
    }

    /*
     * Unable to fully structure code
     */
    private final void bottomChanged(BytesRef lastTerm) throws IOException {
        oldMaxEdits = this.maxEdits;
        if (this.bottomTerm == null) ** GOTO lbl-1000
        if (lastTerm != null) {
            v0 = this.bottomTerm;
            Intrinsics.checkNotNull((Object)v0);
            ** if (lastTerm.compareTo((BytesRef)v0) < 0) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = true;
            ** GOTO lbl11
        }
lbl-1000:
        // 2 sources

        {
            v1 = termAfter = false;
        }
lbl11:
        // 3 sources

        while (!(this.maxEdits <= 0 || this.bottom < (maxBoost = 1.0f - (float)this.maxEdits / (float)this.termLength) || this.bottom == maxBoost && !termAfter)) {
            var5_5 = this.maxEdits;
            this.maxEdits = var5_5 + -1;
        }
        if (oldMaxEdits != this.maxEdits || lastTerm == null) {
            this.actualEnum = this.getAutomatonEnum(this.maxEdits, lastTerm);
        }
    }

    @Override
    @Nullable
    public BytesRef next() throws IOException {
        int ed;
        if (this.queuedBottom != null) {
            this.bottomChanged(this.queuedBottom);
            this.queuedBottom = null;
        }
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        BytesRef term = termsEnum.next();
        if (term == null) {
            return null;
        }
        for (ed = this.maxEdits; ed > 0 && this.matches(term, ed - 1); --ed) {
        }
        if (ed == 0) {
            this.boostAtt.setBoost(1.0f);
        } else {
            int codePointCount = UnicodeUtil.INSTANCE.codePointCount(term);
            int minTermLength = Math.min(codePointCount, this.termLength);
            float similarity = 1.0f - (float)ed / (float)minTermLength;
            this.boostAtt.setBoost(similarity);
        }
        float bottom = this.maxBoostAtt.getMaxNonCompetitiveBoost();
        BytesRef bottomTerm = this.maxBoostAtt.getCompetitiveTerm();
        if (!(bottom == this.bottom) || bottomTerm != this.bottomTerm) {
            this.bottom = bottom;
            this.bottomTerm = bottomTerm;
            this.queuedBottom = BytesRef.Companion.deepCopyOf(term);
        }
        return term;
    }

    private final boolean matches(BytesRef termIn, int k) {
        boolean bl;
        if (k == 0) {
            bl = Intrinsics.areEqual((Object)termIn, (Object)this.term.bytes());
        } else {
            ByteRunAutomaton byteRunAutomaton = this.automata[k].getRunAutomaton();
            Intrinsics.checkNotNull((Object)byteRunAutomaton);
            bl = byteRunAutomaton.run(termIn.getBytes(), termIn.getOffset(), termIn.getLength());
        }
        return bl;
    }

    @Override
    public int docFreq() throws IOException {
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        return termsEnum.docFreq();
    }

    @Override
    public long totalTermFreq() throws IOException {
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        return termsEnum.totalTermFreq();
    }

    @Override
    @NotNull
    public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) throws IOException {
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        return termsEnum.postings(reuse, flags);
    }

    @Override
    @NotNull
    public ImpactsEnum impacts(int flags) throws IOException {
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        return termsEnum.impacts(flags);
    }

    @Override
    public void seekExact(@NotNull BytesRef term, @NotNull TermState state2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        termsEnum.seekExact(term, state2);
    }

    @Override
    @NotNull
    public TermState termState() throws IOException {
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        return termsEnum.termState();
    }

    @Override
    public long ord() throws IOException {
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        return termsEnum.ord();
    }

    @Override
    @NotNull
    public AttributeSource attributes() {
        return this.atts;
    }

    @Override
    public boolean seekExact(@NotNull BytesRef text) throws IOException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        return termsEnum.seekExact(text);
    }

    @Override
    @NotNull
    public IOBooleanSupplier prepareSeekExact(@NotNull BytesRef text) throws IOException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        IOBooleanSupplier iOBooleanSupplier = termsEnum.prepareSeekExact(text);
        Intrinsics.checkNotNull((Object)iOBooleanSupplier);
        return iOBooleanSupplier;
    }

    @Override
    @NotNull
    public TermsEnum.SeekStatus seekCeil(@NotNull BytesRef text) throws IOException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        return termsEnum.seekCeil(text);
    }

    @Override
    public void seekExact(long ord) throws IOException {
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        termsEnum.seekExact(ord);
    }

    @Override
    @NotNull
    public BytesRef term() throws IOException {
        TermsEnum termsEnum = this.actualEnum;
        Intrinsics.checkNotNull((Object)termsEnum);
        BytesRef bytesRef = termsEnum.term();
        Intrinsics.checkNotNull((Object)bytesRef);
        return bytesRef;
    }

    private static final FuzzyAutomatonBuilder _init_$lambda$0(Term $term, int $maxEdits, int $prefixLength, boolean $transpositions) {
        return new FuzzyAutomatonBuilder($term.text(), $maxEdits, $prefixLength, $transpositions);
    }

    private static final FuzzyAutomatonBuilder _init_$lambda$1(Term $term, int $maxEdits, int $prefixLength, boolean $transpositions) {
        return new FuzzyAutomatonBuilder($term.text(), $maxEdits, $prefixLength, $transpositions);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH&R\u001a\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/search/FuzzyTermsEnum$AutomatonAttribute;", "Lorg/gnit/lucenekmp/util/Attribute;", "automata", "", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "getAutomata", "()[Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "termLength", "", "getTermLength", "()I", "init", "", "builder", "Lkotlin/Function0;", "Lorg/gnit/lucenekmp/search/FuzzyAutomatonBuilder;", "core"})
    private static interface AutomatonAttribute
    extends Attribute {
        @Nullable
        public CompiledAutomaton[] getAutomata();

        public int getTermLength();

        public void init(@NotNull Function0<FuzzyAutomatonBuilder> var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0001H\u0016J\b\u0010\u001e\u001a\u00020\u0001H\u0014R$\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/search/FuzzyTermsEnum$AutomatonAttributeImpl;", "Lorg/gnit/lucenekmp/util/AttributeImpl;", "Lorg/gnit/lucenekmp/search/FuzzyTermsEnum$AutomatonAttribute;", "<init>", "()V", "automata", "", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "getAutomata", "()[Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "setAutomata", "([Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;)V", "[Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "termLength", "", "getTermLength", "()I", "setTermLength", "(I)V", "init", "", "supplier", "Lkotlin/Function0;", "Lorg/gnit/lucenekmp/search/FuzzyAutomatonBuilder;", "clear", "reflectWith", "reflector", "Lorg/gnit/lucenekmp/util/AttributeReflector;", "copyTo", "target", "newInstance", "core"})
    private static final class AutomatonAttributeImpl
    extends AttributeImpl
    implements AutomatonAttribute {
        @Nullable
        private CompiledAutomaton[] automata;
        private int termLength;

        @Override
        @Nullable
        public CompiledAutomaton[] getAutomata() {
            return this.automata;
        }

        public void setAutomata(@Nullable CompiledAutomaton[] compiledAutomatonArray) {
            this.automata = compiledAutomatonArray;
        }

        @Override
        public int getTermLength() {
            return this.termLength;
        }

        public void setTermLength(int n) {
            this.termLength = n;
        }

        @Override
        public void init(@NotNull Function0<FuzzyAutomatonBuilder> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            if (this.getAutomata() != null) {
                return;
            }
            FuzzyAutomatonBuilder builder = (FuzzyAutomatonBuilder)supplier.invoke();
            this.setTermLength(builder.getTermLength());
            this.setAutomata(builder.buildAutomatonSet());
        }

        @Override
        public void clear() {
            this.setAutomata(null);
        }

        @Override
        public void reflectWith(@NotNull AttributeReflector reflector) {
            Intrinsics.checkNotNullParameter((Object)reflector, (String)"reflector");
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyTo(@NotNull AttributeImpl target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        protected AttributeImpl newInstance() {
            throw new UnsupportedOperationException("AutomatonAttributeImpl cannot be instantiated directly, use init() instead");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/gnit/lucenekmp/search/FuzzyTermsEnum$FuzzyTermsException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "term", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "core"})
    public static final class FuzzyTermsException
    extends RuntimeException {
        public FuzzyTermsException(@NotNull String term, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super("Term too complex: " + term, cause);
        }
    }
}

