/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.MaxScoreCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/search/ImpactsDISI;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "in", "maxScoreCache", "Lorg/gnit/lucenekmp/search/MaxScoreCache;", "<init>", "(Lorg/gnit/lucenekmp/search/DocIdSetIterator;Lorg/gnit/lucenekmp/search/MaxScoreCache;)V", "minCompetitiveScore", "", "upTo", "", "maxScore", "getMaxScoreCache", "setMinCompetitiveScore", "", "advanceTarget", "target", "advance", "nextDoc", "docID", "cost", "", "core"})
public final class ImpactsDISI
extends DocIdSetIterator {
    @NotNull
    private final DocIdSetIterator in;
    @NotNull
    private final MaxScoreCache maxScoreCache;
    private float minCompetitiveScore;
    private int upTo;
    private float maxScore;

    public ImpactsDISI(@NotNull DocIdSetIterator in, @NotNull MaxScoreCache maxScoreCache) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)maxScoreCache, (String)"maxScoreCache");
        this.in = in;
        this.maxScoreCache = maxScoreCache;
        this.upTo = Integer.MAX_VALUE;
        this.maxScore = Float.MAX_VALUE;
    }

    @NotNull
    public final MaxScoreCache getMaxScoreCache() {
        return this.maxScoreCache;
    }

    public final void setMinCompetitiveScore(float minCompetitiveScore2) {
        if (!(minCompetitiveScore2 >= this.minCompetitiveScore)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (minCompetitiveScore2 > this.minCompetitiveScore) {
            this.minCompetitiveScore = minCompetitiveScore2;
            this.upTo = -1;
        }
    }

    private final int advanceTarget(int target) throws IOException {
        int target2 = target;
        if (target2 <= this.upTo) {
            return target2;
        }
        this.upTo = this.maxScoreCache.advanceShallow(target2);
        this.maxScore = this.maxScoreCache.getMaxScoreForLevelZero();
        while (true) {
            int n;
            if (!(this.upTo >= target2)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.maxScore >= this.minCompetitiveScore) {
                return target2;
            }
            if (this.upTo == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            int skipUpTo = this.maxScoreCache.getSkipUpTo(this.minCompetitiveScore);
            switch (skipUpTo) {
                case -1: {
                    n = this.upTo + 1;
                    break;
                }
                case 0x7FFFFFFF: {
                    return Integer.MAX_VALUE;
                }
                default: {
                    n = skipUpTo + 1;
                }
            }
            target2 = n;
            this.upTo = this.maxScoreCache.advanceShallow(target2);
            this.maxScore = this.maxScoreCache.getMaxScoreForLevelZero();
        }
    }

    @Override
    public int advance(int target) throws IOException {
        return this.in.advance(this.advanceTarget(target));
    }

    @Override
    public int nextDoc() throws IOException {
        DocIdSetIterator in = this.in;
        if (in.docID() < this.upTo) {
            return in.nextDoc();
        }
        return this.advance(in.docID() + 1);
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public long cost() {
        return this.in.cost();
    }
}

