/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchAllDocsQuery;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/search/IndexOrDocValuesQuery;", "Lorg/gnit/lucenekmp/search/Query;", "indexQuery", "randomAccessQuery", "<init>", "(Lorg/gnit/lucenekmp/search/Query;Lorg/gnit/lucenekmp/search/Query;)V", "getIndexQuery", "()Lorg/gnit/lucenekmp/search/Query;", "getRandomAccessQuery", "toString", "", "field", "equals", "", "obj", "", "hashCode", "", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "core"})
public final class IndexOrDocValuesQuery
extends Query {
    @NotNull
    private final Query indexQuery;
    @NotNull
    private final Query randomAccessQuery;

    public IndexOrDocValuesQuery(@NotNull Query indexQuery, @NotNull Query randomAccessQuery) {
        Intrinsics.checkNotNullParameter((Object)indexQuery, (String)"indexQuery");
        Intrinsics.checkNotNullParameter((Object)randomAccessQuery, (String)"randomAccessQuery");
        this.indexQuery = indexQuery;
        this.randomAccessQuery = randomAccessQuery;
    }

    @NotNull
    public final Query getIndexQuery() {
        return this.indexQuery;
    }

    @NotNull
    public final Query getRandomAccessQuery() {
        return this.randomAccessQuery;
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        return "IndexOrDocValuesQuery(indexQuery=" + this.indexQuery.toString(field) + ", dvQuery=" + this.randomAccessQuery.toString(field) + ")";
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.IndexOrDocValuesQuery");
        IndexOrDocValuesQuery that = (IndexOrDocValuesQuery)obj;
        return Intrinsics.areEqual((Object)this.indexQuery, (Object)that.indexQuery) && Intrinsics.areEqual((Object)this.randomAccessQuery, (Object)that.randomAccessQuery);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.indexQuery.hashCode();
        h = 31 * h + this.randomAccessQuery.hashCode();
        return h;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        Query indexRewrite = this.indexQuery.rewrite(indexSearcher);
        Query dvRewrite = this.randomAccessQuery.rewrite(indexSearcher);
        if (indexRewrite instanceof MatchAllDocsQuery || dvRewrite instanceof MatchAllDocsQuery) {
            return new MatchAllDocsQuery();
        }
        if (this.indexQuery != indexRewrite || this.randomAccessQuery != dvRewrite) {
            return new IndexOrDocValuesQuery(indexRewrite, dvRewrite);
        }
        return this;
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        QueryVisitor v = visitor2.getSubVisitor(BooleanClause.Occur.MUST, this);
        this.indexQuery.visit(v);
        this.randomAccessQuery.visit(v);
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        Weight indexWeight = this.indexQuery.createWeight(searcher, scoreMode, boost);
        Weight dvWeight = this.randomAccessQuery.createWeight(searcher, scoreMode, boost);
        return new Weight(this, dvWeight, indexWeight){
            final /* synthetic */ Weight $dvWeight;
            final /* synthetic */ Weight $indexWeight;
            {
                this.$dvWeight = $dvWeight;
                this.$indexWeight = $indexWeight;
                super($receiver);
            }

            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Matches matches2 = this.$dvWeight.matches(context, doc);
                Intrinsics.checkNotNull((Object)matches2);
                return matches2;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return this.$dvWeight.explain(context, doc);
            }

            public int count(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                int count = this.$indexWeight.count(context);
                if (count != -1) {
                    return count;
                }
                return this.$dvWeight.count(context);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                ScorerSupplier indexScorerSupplier = this.$indexWeight.scorerSupplier(context);
                ScorerSupplier dvScorerSupplier = this.$dvWeight.scorerSupplier(context);
                if (indexScorerSupplier == null || dvScorerSupplier == null) {
                    return null;
                }
                return new ScorerSupplier(indexScorerSupplier, dvScorerSupplier){
                    final /* synthetic */ ScorerSupplier $indexScorerSupplier;
                    final /* synthetic */ ScorerSupplier $dvScorerSupplier;
                    {
                        this.$indexScorerSupplier = $indexScorerSupplier;
                        this.$dvScorerSupplier = $dvScorerSupplier;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        long threshold = this.cost() >>> 3;
                        return threshold <= leadCost ? this.$indexScorerSupplier.get(leadCost) : this.$dvScorerSupplier.get(leadCost);
                    }

                    public BulkScorer bulkScorer() throws IOException {
                        return this.$indexScorerSupplier.bulkScorer();
                    }

                    public long cost() {
                        return this.$indexScorerSupplier.cost();
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return this.$indexWeight.isCacheable(ctx);
            }
        };
    }
}

