/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.IndexReaderContext;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.QueryTimeout;
import org.gnit.lucenekmp.index.ReaderUtil;
import org.gnit.lucenekmp.index.StoredFields;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.jdkport.Callable;
import org.gnit.lucenekmp.jdkport.Executor;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.CollectionStatistics;
import org.gnit.lucenekmp.search.CollectionTerminatedException;
import org.gnit.lucenekmp.search.Collector;
import org.gnit.lucenekmp.search.CollectorManager;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.FieldDoc;
import org.gnit.lucenekmp.search.LRUQueryCache;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryCache;
import org.gnit.lucenekmp.search.QueryCachingPolicy;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.ScorerUtil;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.TaskExecutor;
import org.gnit.lucenekmp.search.TermStatistics;
import org.gnit.lucenekmp.search.TimeLimitingBulkScorer;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopFieldCollector;
import org.gnit.lucenekmp.search.TopFieldCollectorManager;
import org.gnit.lucenekmp.search.TopFieldDocs;
import org.gnit.lucenekmp.search.TopScoreDocCollectorManager;
import org.gnit.lucenekmp.search.TotalHitCountCollectorManager;
import org.gnit.lucenekmp.search.UsageTrackingQueryCachingPolicy;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.search.similarities.BM25Similarity;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.automaton.ByteRunAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u0083\u00012\u00020\u0001:\t\u007f\u0080\u0001\u0081\u0001\u0082\u0001\u0083\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ!\u00102\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0004\u00a2\u0006\u0002\u00104J\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u0013\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010>J \u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010;\u001a\u00020<2\u0006\u0010D\u001a\u00020:J\u0016\u0010J\u001a\u00020A2\u0006\u0010;\u001a\u00020<2\u0006\u0010K\u001a\u00020:J\u0018\u0010J\u001a\u00020L2\u0006\u0010;\u001a\u00020<2\u0006\u0010M\u001a\u00020NH\u0007J\u0006\u0010O\u001a\u00020\u000eJ&\u0010J\u001a\u00020P2\u0006\u0010;\u001a\u00020<2\u0006\u0010K\u001a\u00020:2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u000eJ\u001e\u0010J\u001a\u00020P2\u0006\u0010;\u001a\u00020<2\u0006\u0010K\u001a\u00020:2\u0006\u0010Q\u001a\u00020RJ&\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010;\u001a\u00020<2\u0006\u0010K\u001a\u00020:2\u0006\u0010Q\u001a\u00020RJ0\u0010@\u001a\u00020P2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010;\u001a\u00020<2\u0006\u0010D\u001a\u00020:2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u000eJ2\u0010@\u001a\u00020P2\b\u0010B\u001a\u0004\u0018\u00010T2\u0006\u0010;\u001a\u00020<2\u0006\u0010D\u001a\u00020:2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u000eH\u0002J7\u0010J\u001a\u0002HU\"\b\b\u0000\u0010V*\u00020N\"\u0004\b\u0001\u0010U2\u0006\u0010;\u001a\u00020<2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u0002HV\u0012\u0004\u0012\u0002HU0X\u00a2\u0006\u0002\u0010YJA\u0010J\u001a\u0002HU\"\b\b\u0000\u0010V*\u00020N\"\u0004\b\u0001\u0010U2\u0006\u0010Z\u001a\u00020[2\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u0002HV\u0012\u0004\u0012\u0002HU0X2\u0006\u0010\\\u001a\u0002HVH\u0002\u00a2\u0006\u0002\u0010]J+\u0010J\u001a\u00020L2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020_0\u001b2\u0006\u0010Z\u001a\u00020[2\u0006\u0010M\u001a\u00020NH\u0004\u00a2\u0006\u0002\u0010`J0\u0010a\u001a\u00020L2\u0006\u0010b\u001a\u00020\u00172\u0006\u0010c\u001a\u00020:2\u0006\u0010d\u001a\u00020:2\u0006\u0010Z\u001a\u00020[2\u0006\u0010M\u001a\u00020NH\u0004J\u000e\u0010e\u001a\u00020<2\u0006\u0010f\u001a\u00020<J\u0018\u0010e\u001a\u00020<2\u0006\u0010f\u001a\u00020<2\u0006\u0010g\u001a\u00020\u000eH\u0002J\u0016\u0010h\u001a\u00020i2\u0006\u0010;\u001a\u00020<2\u0006\u0010j\u001a\u00020:J\u0018\u0010h\u001a\u00020i2\u0006\u0010Z\u001a\u00020[2\u0006\u0010j\u001a\u00020:H\u0004J\u001e\u0010k\u001a\u00020[2\u0006\u0010;\u001a\u00020<2\u0006\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020oJ\b\u0010r\u001a\u00020sH\u0016J\u001e\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020:2\u0006\u0010y\u001a\u00020zJ\u0010\u0010{\u001a\u0004\u0018\u00010|2\u0006\u0010}\u001a\u00020sJ\u0006\u0010~\u001a\u00020\u001fR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00105\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0011R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R(\u0010E\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u0011\u0010p\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bq\u0010\u0014\u00a8\u0006\u0084\u0001"}, d2={"Lorg/gnit/lucenekmp/search/IndexSearcher;", "", "context", "Lorg/gnit/lucenekmp/index/IndexReaderContext;", "executor", "Lorg/gnit/lucenekmp/jdkport/Executor;", "<init>", "(Lorg/gnit/lucenekmp/index/IndexReaderContext;Lorg/gnit/lucenekmp/jdkport/Executor;)V", "r", "Lorg/gnit/lucenekmp/index/IndexReader;", "(Lorg/gnit/lucenekmp/index/IndexReader;Lorg/gnit/lucenekmp/jdkport/Executor;)V", "queryTimeout", "Lorg/gnit/lucenekmp/index/QueryTimeout;", "partialResult", "", "reader", "getReader", "()Lorg/gnit/lucenekmp/index/IndexReader;", "readerContext", "getReaderContext", "()Lorg/gnit/lucenekmp/index/IndexReaderContext;", "leafContexts", "", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "getLeafContexts", "()Ljava/util/List;", "leafSlices", "", "Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "[Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "taskExecutor", "Lorg/gnit/lucenekmp/search/TaskExecutor;", "queryCache", "Lorg/gnit/lucenekmp/search/QueryCache;", "getQueryCache", "()Lorg/gnit/lucenekmp/search/QueryCache;", "setQueryCache", "(Lorg/gnit/lucenekmp/search/QueryCache;)V", "queryCachingPolicy", "Lorg/gnit/lucenekmp/search/QueryCachingPolicy;", "getQueryCachingPolicy", "()Lorg/gnit/lucenekmp/search/QueryCachingPolicy;", "setQueryCachingPolicy", "(Lorg/gnit/lucenekmp/search/QueryCachingPolicy;)V", "similarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "getSimilarity", "()Lorg/gnit/lucenekmp/search/similarities/Similarity;", "setSimilarity", "(Lorg/gnit/lucenekmp/search/similarities/Similarity;)V", "slices", "leaves", "(Ljava/util/List;)[Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "indexReader", "getIndexReader", "storedFields", "Lorg/gnit/lucenekmp/index/StoredFields;", "count", "", "query", "Lorg/gnit/lucenekmp/search/Query;", "getSlices", "()[Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "computeAndCacheSlices", "searchAfter", "Lorg/gnit/lucenekmp/search/TopDocs;", "after", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "numHits", "timeout", "getTimeout", "()Lorg/gnit/lucenekmp/index/QueryTimeout;", "setTimeout", "(Lorg/gnit/lucenekmp/index/QueryTimeout;)V", "search", "n", "", "collector", "Lorg/gnit/lucenekmp/search/Collector;", "timedOut", "Lorg/gnit/lucenekmp/search/TopFieldDocs;", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "doDocScores", "Lorg/gnit/lucenekmp/search/FieldDoc;", "T", "C", "collectorManager", "Lorg/gnit/lucenekmp/search/CollectorManager;", "(Lorg/gnit/lucenekmp/search/Query;Lorg/gnit/lucenekmp/search/CollectorManager;)Ljava/lang/Object;", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "firstCollector", "(Lorg/gnit/lucenekmp/search/Weight;Lorg/gnit/lucenekmp/search/CollectorManager;Lorg/gnit/lucenekmp/search/Collector;)Ljava/lang/Object;", "partitions", "Lorg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition;", "([Lorg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition;Lorg/gnit/lucenekmp/search/Weight;Lorg/gnit/lucenekmp/search/Collector;)V", "searchLeaf", "ctx", "minDocId", "maxDocId", "rewrite", "original", "needsScores", "explain", "Lorg/gnit/lucenekmp/search/Explanation;", "doc", "createWeight", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "topReaderContext", "getTopReaderContext", "toString", "", "termStatistics", "Lorg/gnit/lucenekmp/search/TermStatistics;", "term", "Lorg/gnit/lucenekmp/index/Term;", "docFreq", "totalTermFreq", "", "collectionStatistics", "Lorg/gnit/lucenekmp/search/CollectionStatistics;", "field", "getTaskExecutor", "LeafSlice", "LeafReaderContextPartition", "TooManyClauses", "TooManyNestedClauses", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIndexSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,1262:1\n8#2,2:1263\n3#2,8:1270\n1563#3:1265\n1634#3,3:1266\n1#4:1269\n10#5:1278\n*S KotlinDebug\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher\n*L\n136#1:1263,2\n581#1:1270,8\n158#1:1265\n158#1:1266,3\n581#1:1278\n*E\n"})
public class IndexSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private QueryTimeout queryTimeout;
    private volatile boolean partialResult;
    @NotNull
    private final IndexReader reader;
    @NotNull
    private final IndexReaderContext readerContext;
    @NotNull
    private final List<LeafReaderContext> leafContexts;
    private volatile LeafSlice[] leafSlices;
    @NotNull
    private final TaskExecutor taskExecutor;
    @Nullable
    private QueryCache queryCache;
    @NotNull
    private QueryCachingPolicy queryCachingPolicy;
    @NotNull
    private Similarity similarity;
    private static int maxClauseCount = 1024;
    @NotNull
    private static QueryCache DEFAULT_QUERY_CACHE;
    @NotNull
    private static QueryCachingPolicy DEFAULT_CACHING_POLICY;
    private static final int TOTAL_HITS_THRESHOLD = 1000;
    private static final int MAX_DOCS_PER_SLICE = 250000;
    private static final int MAX_SEGMENTS_PER_SLICE = 5;
    @NotNull
    private static final Similarity defaultSimilarity;

    /*
     * WARNING - void declaration
     */
    public IndexSearcher(@NotNull IndexReaderContext context, @Nullable Executor executor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.queryCache = DEFAULT_QUERY_CACHE;
        this.queryCachingPolicy = DEFAULT_CACHING_POLICY;
        this.similarity = defaultSimilarity;
        boolean condition$iv = context.isTopLevel();
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "IndexSearcher's ReaderContext must be topLevel for reader " + context.reader();
            throw new AssertionError((Object)string);
        }
        this.reader = context.reader();
        this.taskExecutor = executor == null ? new TaskExecutor(2.INSTANCE) : new TaskExecutor(executor);
        this.readerContext = context;
        this.leafContexts = context.leaves();
        if (executor == null) {
            LeafSlice[] leafSliceArray;
            IndexSearcher indexSearcher = this;
            if (this.leafContexts.isEmpty()) {
                leafSliceArray = new LeafSlice[]{};
            } else {
                Collection<LeafReaderContextPartition> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LeafSlice[] leafSliceArray2 = new LeafSlice[1];
                Iterable $i$f$assert2 = this.leafContexts;
                int n = 0;
                LeafSlice[] leafSliceArray3 = leafSliceArray2;
                IndexSearcher indexSearcher2 = indexSearcher;
                boolean $i$f$map = false;
                void var6_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void ctx;
                    LeafReaderContext leafReaderContext = (LeafReaderContext)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LeafReaderContextPartition.Companion.createForEntireSegment((LeafReaderContext)ctx));
                }
                collection = (List)destination$iv$iv;
                indexSearcher = indexSearcher2;
                Collection collection2 = CollectionsKt.toList((Iterable)collection);
                List list = new ArrayList(collection2);
                leafSliceArray3[n] = new LeafSlice(list);
                leafSliceArray = leafSliceArray2;
            }
            indexSearcher.leafSlices = leafSliceArray;
        }
    }

    public /* synthetic */ IndexSearcher(IndexReaderContext indexReaderContext, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            executor = null;
        }
        this(indexReaderContext, executor);
    }

    @NotNull
    public final IndexReader getReader() {
        return this.reader;
    }

    @NotNull
    protected final IndexReaderContext getReaderContext() {
        return this.readerContext;
    }

    @NotNull
    public final List<LeafReaderContext> getLeafContexts() {
        return this.leafContexts;
    }

    @Nullable
    public final QueryCache getQueryCache() {
        return this.queryCache;
    }

    public final void setQueryCache(@Nullable QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    @NotNull
    public final QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    public final void setQueryCachingPolicy(@NotNull QueryCachingPolicy queryCachingPolicy) {
        Intrinsics.checkNotNullParameter((Object)queryCachingPolicy, (String)"<set-?>");
        this.queryCachingPolicy = queryCachingPolicy;
    }

    @NotNull
    public final Similarity getSimilarity() {
        return this.similarity;
    }

    public final void setSimilarity(@NotNull Similarity similarity) {
        Intrinsics.checkNotNullParameter((Object)similarity, (String)"<set-?>");
        this.similarity = similarity;
    }

    public IndexSearcher(@NotNull IndexReader r, @Nullable Executor executor) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this(r.getContext(), executor);
    }

    public /* synthetic */ IndexSearcher(IndexReader indexReader, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            executor = null;
        }
        this(indexReader, executor);
    }

    @NotNull
    protected final LeafSlice[] slices(@NotNull List<LeafReaderContext> leaves) {
        Intrinsics.checkNotNullParameter(leaves, (String)"leaves");
        return Companion.slices(leaves, 250000, 5, false);
    }

    @NotNull
    public final IndexReader getIndexReader() {
        return this.reader;
    }

    @NotNull
    public final StoredFields storedFields() throws IOException {
        return this.reader.storedFields();
    }

    public final int count(@NotNull Query query) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Query query2 = query;
        query2 = this.rewrite(new ConstantScoreQuery(query2));
        if (query2 instanceof ConstantScoreQuery) {
            query2 = ((ConstantScoreQuery)query2).getQuery();
        }
        if (query2 instanceof BooleanQuery && !this.reader.hasDeletions() && ((BooleanQuery)query2).isTwoClausePureDisjunctionWithTerms()) {
            Query[] queries2 = ((BooleanQuery)query2).rewriteTwoClauseDisjunctionWithTermsForCount(this);
            int countTerm1 = this.count(queries2[0]);
            int countTerm2 = this.count(queries2[1]);
            if (countTerm1 == 0 || countTerm2 == 0) {
                return java.lang.Math.max(countTerm1, countTerm2);
            }
            if ((double)java.lang.Math.min(countTerm1, countTerm2) / (double)java.lang.Math.max(countTerm1, countTerm2) < 0.1) {
                return countTerm1 + countTerm2 - this.count(queries2[2]);
            }
        }
        return ((Number)this.search((Query)new ConstantScoreQuery(query2), new TotalHitCountCollectorManager(this.getSlices()))).intValue();
    }

    @NotNull
    public final LeafSlice[] getSlices() {
        LeafSlice[] leafSliceArray = this.leafSlices;
        if (this.leafSlices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"leafSlices");
            leafSliceArray = null;
        }
        LeafSlice[] res = leafSliceArray;
        return res;
    }

    private final LeafSlice[] computeAndCacheSlices() {
        LeafSlice[] leafSliceArray = this.leafSlices;
        if (this.leafSlices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"leafSlices");
            leafSliceArray = null;
        }
        LeafSlice[] res = leafSliceArray;
        return res;
    }

    @NotNull
    public final TopDocs searchAfter(@Nullable ScoreDoc after, @NotNull Query query, int numHits) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        int limit = java.lang.Math.max(1, this.reader.maxDoc());
        if (!(after == null || after.getDoc() < limit)) {
            boolean $i$a$-require-IndexSearcher$searchAfter$22 = false;
            ScoreDoc scoreDoc = after;
            Intrinsics.checkNotNull((Object)scoreDoc);
            String $i$a$-require-IndexSearcher$searchAfter$22 = "after.doc exceeds the number of documents in the reader: after.doc=" + scoreDoc.getDoc() + " limit=" + limit;
            throw new IllegalArgumentException($i$a$-require-IndexSearcher$searchAfter$22.toString());
        }
        int cappedNumHits = java.lang.Math.min(numHits, limit);
        CollectorManager manager = new TopScoreDocCollectorManager(cappedNumHits, after, 1000);
        return (TopDocs)this.search(query, manager);
    }

    @Nullable
    public final QueryTimeout getTimeout() {
        return this.queryTimeout;
    }

    public final void setTimeout(@Nullable QueryTimeout queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @NotNull
    public final TopDocs search(@NotNull Query query, int n) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.searchAfter(null, query, n);
    }

    @Deprecated(message="This method is being deprecated in favor of {@link IndexSearcher#search(Query,\n   *     CollectorManager)} due to its support for concurrency in IndexSearcher")
    public final void search(@NotNull Query query, @NotNull Collector collector2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Query query2 = query;
        query2 = this.rewrite(query2, collector2.scoreMode().needsScores());
        Weight weight = this.createWeight(query2, collector2.scoreMode(), 1.0f);
        collector2.setWeight(weight);
        for (LeafReaderContext ctx : this.leafContexts) {
            this.searchLeaf(ctx, 0, Integer.MAX_VALUE, weight, collector2);
        }
    }

    public final boolean timedOut() {
        return this.partialResult;
    }

    @NotNull
    public final TopFieldDocs search(@NotNull Query query, int n, @NotNull Sort sort2, boolean doDocScores) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        return this.searchAfter(null, query, n, sort2, doDocScores);
    }

    @NotNull
    public final TopFieldDocs search(@NotNull Query query, int n, @NotNull Sort sort2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        return this.searchAfter(null, query, n, sort2, false);
    }

    @NotNull
    public final TopDocs searchAfter(@NotNull ScoreDoc after, @NotNull Query query, int n, @NotNull Sort sort2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        return this.searchAfter(after, query, n, sort2, false);
    }

    @NotNull
    public final TopFieldDocs searchAfter(@Nullable ScoreDoc after, @NotNull Query query, int numHits, @NotNull Sort sort2, boolean doDocScores) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        if (!(after == null || after instanceof FieldDoc)) {
            boolean bl = false;
            String string = "after must be a FieldDoc; got " + after;
            throw new IllegalArgumentException(string.toString());
        }
        ScoreDoc scoreDoc = after;
        return this.searchAfter(scoreDoc instanceof FieldDoc ? (FieldDoc)scoreDoc : null, query, numHits, sort2, doDocScores);
    }

    private final TopFieldDocs searchAfter(FieldDoc after, Query query, int numHits, Sort sort2, boolean doDocScores) throws IOException {
        int limit = java.lang.Math.max(1, this.reader.maxDoc());
        if (!(after == null || after.getDoc() < limit)) {
            boolean $i$a$-require-IndexSearcher$searchAfter$42 = false;
            FieldDoc fieldDoc = after;
            Intrinsics.checkNotNull((Object)fieldDoc);
            String $i$a$-require-IndexSearcher$searchAfter$42 = "after.doc exceeds the number of documents in the reader: after.doc=" + fieldDoc.getDoc() + " limit=" + limit;
            throw new IllegalArgumentException($i$a$-require-IndexSearcher$searchAfter$42.toString());
        }
        int cappedNumHits = java.lang.Math.min(numHits, limit);
        Sort rewrittenSort = sort2.rewrite(this);
        CollectorManager manager = new TopFieldCollectorManager(rewrittenSort, cappedNumHits, after, 1000);
        TopFieldDocs topDocs = (TopFieldDocs)this.search(query, manager);
        if (doDocScores) {
            TopFieldCollector.Companion.populateScores(topDocs.getScoreDocs(), this, query);
        }
        return topDocs;
    }

    public final <C extends Collector, T> T search(@NotNull Query query, @NotNull CollectorManager<C, T> collectorManager) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(collectorManager, (String)"collectorManager");
        Query query2 = query;
        C firstCollector = collectorManager.newCollector();
        query2 = this.rewrite(query2, firstCollector.scoreMode().needsScores());
        Weight weight = this.createWeight(query2, firstCollector.scoreMode(), 1.0f);
        return this.search(weight, collectorManager, firstCollector);
    }

    private final <C extends Collector, T> T search(Weight weight, CollectorManager<C, T> collectorManager, C firstCollector) throws IOException {
        LeafSlice[] leafSlices = this.getSlices();
        if (leafSlices.length == 0) {
            boolean condition$iv22 = this.leafContexts.isEmpty();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv22) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            Object[] condition$iv22 = new Collector[]{firstCollector};
            return collectorManager.reduce(CollectionsKt.mutableListOf((Object[])condition$iv22));
        }
        List collectors = new ArrayList(leafSlices.length);
        collectors.add(firstCollector);
        ScoreMode scoreMode = firstCollector.scoreMode();
        int $i$a$-assert-AssertKt$assert$22 = leafSlices.length;
        for (int i = 1; i < $i$a$-assert-AssertKt$assert$22; ++i) {
            C collector2 = collectorManager.newCollector();
            collectors.add(collector2);
            if (scoreMode == collector2.scoreMode()) continue;
            boolean $i$a$-check-IndexSearcher$search$22 = false;
            String $i$a$-check-IndexSearcher$search$22 = "CollectorManager does not always produce collectors with the same score mode";
            throw new IllegalStateException($i$a$-check-IndexSearcher$search$22.toString());
        }
        List listTasks = new ArrayList(leafSlices.length);
        int n = leafSlices.length;
        for (int i = 0; i < n; ++i) {
            LeafReaderContextPartition[] leaves = leafSlices[i].getPartitions();
            Collector collector3 = (Collector)collectors.get(i);
            listTasks.add(() -> IndexSearcher.search$lambda$6(this, leaves, weight, collector3));
        }
        List results2 = (List)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super List<C>>, Object>(this, listTasks, null){
            int label;
            final /* synthetic */ IndexSearcher this$0;
            final /* synthetic */ List<Callable<C>> $listTasks;
            {
                this.this$0 = $receiver;
                this.$listTasks = $listTasks;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = IndexSearcher.access$getTaskExecutor$p(this.this$0).invokeAll((Collection)this.$listTasks, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<C>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)1, null);
        return collectorManager.reduce(results2);
    }

    protected final void search(@NotNull LeafReaderContextPartition[] partitions, @NotNull Weight weight, @NotNull Collector collector2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)partitions, (String)"partitions");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        collector2.setWeight(weight);
        for (LeafReaderContextPartition partition2 : partitions) {
            this.searchLeaf(partition2.getCtx(), partition2.getMinDocId(), partition2.getMaxDocId(), weight, collector2);
        }
    }

    protected final void searchLeaf(@NotNull LeafReaderContext ctx, int minDocId, int maxDocId, @NotNull Weight weight, @NotNull Collector collector2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        LeafCollector leafCollector = null;
        try {
            leafCollector = collector2.getLeafCollector(ctx);
        }
        catch (CollectionTerminatedException e) {
            return;
        }
        ScorerSupplier scorerSupplier2 = weight.scorerSupplier(ctx);
        if (scorerSupplier2 != null) {
            scorerSupplier2.setTopLevelScoringClause();
            BulkScorer bulkScorer = scorerSupplier2.bulkScorer();
            Intrinsics.checkNotNull((Object)bulkScorer);
            BulkScorer scorer2 = bulkScorer;
            if (this.queryTimeout != null) {
                QueryTimeout queryTimeout = this.queryTimeout;
                Intrinsics.checkNotNull((Object)queryTimeout);
                scorer2 = new TimeLimitingBulkScorer(scorer2, queryTimeout);
            }
            try {
                Bits acceptDocs = ScorerUtil.INSTANCE.likelyLiveDocs(ctx.reader().getLiveDocs());
                Integer n = scorer2.score(leafCollector, acceptDocs, minDocId, maxDocId);
            }
            catch (CollectionTerminatedException e) {
                Unit unit = Unit.INSTANCE;
            }
            catch (TimeLimitingBulkScorer.TimeExceededException e) {
                this.partialResult = true;
                Unit unit = Unit.INSTANCE;
            }
        }
        leafCollector.finish();
    }

    @NotNull
    public final Query rewrite(@NotNull Query original) throws IOException {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Query query = original;
        Query rewrittenQuery = query.rewrite(this);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this);
        }
        query.visit(IndexSearcher.Companion.getNumClausesCheckVisitor());
        return query;
    }

    private final Query rewrite(Query original, boolean needsScores) throws IOException {
        return needsScores ? this.rewrite(original) : this.rewrite(new ConstantScoreQuery(original));
    }

    @NotNull
    public final Explanation explain(@NotNull Query query, int doc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Query query2 = query;
        query2 = this.rewrite(query2);
        return this.explain(this.createWeight(query2, ScoreMode.COMPLETE, 1.0f), doc);
    }

    @NotNull
    protected final Explanation explain(@NotNull Weight weight, int doc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)weight, (String)"weight");
        int n = ReaderUtil.INSTANCE.subIndex(doc, this.leafContexts);
        LeafReaderContext ctx = this.leafContexts.get(n);
        int deBasedDoc = doc - ctx.getDocBase();
        Bits liveDocs2 = ctx.reader().getLiveDocs();
        if (liveDocs2 != null && !liveDocs2.get(deBasedDoc)) {
            return Explanation.Companion.noMatch("Document " + doc + " is deleted", new Explanation[0]);
        }
        return weight.explain(ctx, deBasedDoc);
    }

    @NotNull
    public final Weight createWeight(@NotNull Query query, @NotNull ScoreMode scoreMode, float boost) throws IOException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        QueryCache queryCache = this.queryCache;
        Weight weight = query.createWeight(this, scoreMode, boost);
        if (!scoreMode.needsScores() && queryCache != null) {
            weight = queryCache.doCache(weight, this.queryCachingPolicy);
        }
        return weight;
    }

    @NotNull
    public final IndexReaderContext getTopReaderContext() {
        return this.readerContext;
    }

    @NotNull
    public String toString() {
        return "IndexSearcher(" + this.reader + "; taskExecutor=" + this.taskExecutor + ")";
    }

    @NotNull
    public final TermStatistics termStatistics(@NotNull Term term, int docFreq, long totalTermFreq) throws IOException {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        return new TermStatistics(term.bytes(), docFreq, totalTermFreq);
    }

    @Nullable
    public final CollectionStatistics collectionStatistics(@NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        long docCount = 0L;
        long sumTotalTermFreq = 0L;
        long sumDocFreq = 0L;
        for (LeafReaderContext leaf : this.reader.leaves()) {
            Terms terms = Terms.Companion.getTerms(leaf.reader(), field);
            docCount += (long)terms.getDocCount();
            sumTotalTermFreq += terms.getSumTotalTermFreq();
            sumDocFreq += terms.getSumDocFreq();
        }
        if (docCount == 0L) {
            return null;
        }
        return new CollectionStatistics(field, this.reader.maxDoc(), docCount, sumTotalTermFreq, sumDocFreq);
    }

    @NotNull
    public final TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    private static final Collector search$lambda$6(IndexSearcher this$0, LeafReaderContextPartition[] $leaves, Weight $weight, Collector $collector) {
        this$0.search($leaves, $weight, $collector);
        return $collector;
    }

    public static final /* synthetic */ TaskExecutor access$getTaskExecutor$p(IndexSearcher $this) {
        return $this.taskExecutor;
    }

    static {
        DEFAULT_CACHING_POLICY = new UsageTrackingQueryCachingPolicy(0, 1, null);
        int maxCachedQueries = 1000;
        long maxRamBytesUsed = 0x100000000L;
        DEFAULT_QUERY_CACHE = new LRUQueryCache(maxCachedQueries, maxRamBytesUsed, null, 0.0f, 12, null);
        defaultSimilarity = new BM25Similarity(0.0f, 0.0f, false, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0011J7\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020#H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010.\u001a\u00020/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/search/IndexSearcher$Companion;", "", "<init>", "()V", "maxClauseCount", "", "getMaxClauseCount", "()I", "setMaxClauseCount", "(I)V", "get", "set", "", "value", "DEFAULT_QUERY_CACHE", "Lorg/gnit/lucenekmp/search/QueryCache;", "DEFAULT_CACHING_POLICY", "Lorg/gnit/lucenekmp/search/QueryCachingPolicy;", "TOTAL_HITS_THRESHOLD", "MAX_DOCS_PER_SLICE", "MAX_SEGMENTS_PER_SLICE", "defaultSimilarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "getDefaultSimilarity", "()Lorg/gnit/lucenekmp/search/similarities/Similarity;", "defaultQueryCache", "getDefaultQueryCache", "()Lorg/gnit/lucenekmp/search/QueryCache;", "setDefaultQueryCache", "defaultQueryCachingPolicy", "getDefaultQueryCachingPolicy", "()Lorg/gnit/lucenekmp/search/QueryCachingPolicy;", "setDefaultQueryCachingPolicy", "slices", "", "Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "leaves", "", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "maxDocsPerSlice", "maxSegmentsPerSlice", "allowSegmentPartitions", "", "(Ljava/util/List;IIZ)[Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "enforceDistinctLeaves", "leafSlice", "numClausesCheckVisitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "getNumClausesCheckVisitor", "()Lorg/gnit/lucenekmp/search/QueryVisitor;", "core"})
    @SourceDebugExtension(value={"SMAP\nIndexSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 5 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,1262:1\n1#2:1263\n1021#3,2:1264\n1563#3:1284\n1634#3,3:1285\n3#4,8:1266\n3#4,8:1275\n10#5:1274\n10#5:1283\n*S KotlinDebug\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher$Companion\n*L\n1103#1:1264,2\n1196#1:1284\n1196#1:1285,3\n1111#1:1266,8\n1169#1:1275,8\n1111#1:1274\n1169#1:1283\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMaxClauseCount() {
            return maxClauseCount;
        }

        public final void setMaxClauseCount(int n) {
            maxClauseCount = n;
        }

        public final int get() {
            return this.getMaxClauseCount();
        }

        public final void set(int value) {
            if (!(value >= 1)) {
                boolean bl = false;
                String string = "maxClauseCount must be >= 1";
                throw new IllegalArgumentException(string.toString());
            }
            this.setMaxClauseCount(value);
        }

        @NotNull
        public final Similarity getDefaultSimilarity() {
            return defaultSimilarity;
        }

        @NotNull
        public final QueryCache getDefaultQueryCache() {
            return DEFAULT_QUERY_CACHE;
        }

        public final void setDefaultQueryCache(@NotNull QueryCache defaultQueryCache) {
            Intrinsics.checkNotNullParameter((Object)defaultQueryCache, (String)"defaultQueryCache");
            DEFAULT_QUERY_CACHE = defaultQueryCache;
        }

        @NotNull
        public final QueryCachingPolicy getDefaultQueryCachingPolicy() {
            return DEFAULT_CACHING_POLICY;
        }

        public final void setDefaultQueryCachingPolicy(@NotNull QueryCachingPolicy defaultQueryCachingPolicy) {
            Intrinsics.checkNotNullParameter((Object)defaultQueryCachingPolicy, (String)"defaultQueryCachingPolicy");
            DEFAULT_CACHING_POLICY = defaultQueryCachingPolicy;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LeafSlice[] slices(@NotNull List<LeafReaderContext> leaves, int maxDocsPerSlice, int maxSegmentsPerSlice, boolean allowSegmentPartitions) {
            List sortedLeaves;
            Intrinsics.checkNotNullParameter(leaves, (String)"leaves");
            List $this$sortByDescending$iv = sortedLeaves = (List)new ArrayList(leaves);
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        LeafReaderContext it = (LeafReaderContext)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.reader().maxDoc());
                        it = (LeafReaderContext)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.reader().maxDoc()));
                    }
                });
            }
            if (allowSegmentPartitions) {
                List groupedLeafPartitions = new ArrayList();
                int currentSliceNumDocs = 0;
                List group = null;
                for (LeafReaderContext ctx : sortedLeaves) {
                    if (ctx.reader().maxDoc() > maxDocsPerSlice) {
                        int numDocs;
                        boolean condition$iv = group == null;
                        boolean $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            boolean $i$a$-assert-AssertKt$assert$22 = false;
                            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                        }
                        int numSlices = java.lang.Math.min(5, Math.INSTANCE.ceilDiv(ctx.reader().maxDoc(), maxDocsPerSlice));
                        int maxDocId = numDocs = ctx.reader().maxDoc() / numSlices;
                        int minDocId = 0;
                        int n = numSlices - 1;
                        for (int i = 0; i < n; ++i) {
                            Object[] objectArray = new LeafReaderContextPartition[]{LeafReaderContextPartition.Companion.createFromAndTo(ctx, minDocId, maxDocId)};
                            groupedLeafPartitions.add(CollectionsKt.mutableListOf((Object[])objectArray));
                            minDocId = maxDocId;
                            maxDocId += numDocs;
                        }
                        Object[] i = new LeafReaderContextPartition[]{LeafReaderContextPartition.Companion.createFromAndTo(ctx, minDocId, ctx.reader().maxDoc())};
                        groupedLeafPartitions.add(CollectionsKt.mutableListOf((Object[])i));
                        continue;
                    }
                    if (group == null) {
                        group = new ArrayList();
                        groupedLeafPartitions.add(group);
                    }
                    group.add(LeafReaderContextPartition.Companion.createForEntireSegment(ctx));
                    if (group.size() < maxSegmentsPerSlice && (currentSliceNumDocs += ctx.reader().maxDoc()) <= maxDocsPerSlice) continue;
                    group = null;
                    currentSliceNumDocs = 0;
                }
                LeafSlice[] slices = new LeafSlice[groupedLeafPartitions.size()];
                int upto = 0;
                for (List currentGroup : groupedLeafPartitions) {
                    slices[upto] = new LeafSlice(currentGroup);
                    ++upto;
                }
                return slices;
            }
            List groupedLeaves = new ArrayList();
            long docSum = 0L;
            List group = null;
            for (LeafReaderContext ctx : sortedLeaves) {
                if (ctx.reader().maxDoc() > maxDocsPerSlice) {
                    boolean condition$iv = group == null;
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean $i$a$-assert-AssertKt$assert$32 = false;
                        String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
                    }
                    Object[] objectArray = new LeafReaderContext[]{ctx};
                    groupedLeaves.add(CollectionsKt.mutableListOf((Object[])objectArray));
                    continue;
                }
                if (group == null) {
                    group = new ArrayList();
                    group.add(ctx);
                    v0 = groupedLeaves.add(group);
                } else {
                    v0 = group.add(ctx);
                }
                if (group.size() < maxSegmentsPerSlice && (docSum += (long)ctx.reader().maxDoc()) <= (long)maxDocsPerSlice) continue;
                group = null;
                docSum = 0L;
            }
            LeafSlice[] slices = new LeafSlice[groupedLeaves.size()];
            int upto = 0;
            for (List currentLeaf : groupedLeaves) {
                Collection<LeafReaderContextPartition> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable $i$f$assert = currentLeaf;
                int n = upto;
                LeafSlice[] leafSliceArray = slices;
                boolean $i$f$map = false;
                void var16_36 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void ctx;
                    LeafReaderContext leafReaderContext = (LeafReaderContext)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LeafReaderContextPartition.Companion.createForEntireSegment((LeafReaderContext)ctx));
                }
                collection = (List)destination$iv$iv;
                Collection collection2 = CollectionsKt.toList((Iterable)collection);
                List list = new ArrayList(collection2);
                leafSliceArray[n] = new LeafSlice(list);
                ++upto;
            }
            return slices;
        }

        private final void enforceDistinctLeaves(LeafSlice leafSlice) {
            Set distinctLeaves = new HashSet();
            for (LeafReaderContextPartition leafPartition : leafSlice.getPartitions()) {
                if (distinctLeaves.add(leafPartition.getCtx())) continue;
                boolean bl = false;
                String string = "The same slice targets multiple leaf partitions of the same leaf reader context. A physical segment should rather get partitioned to be searched concurrently from as many slices as the number of leaf partitions it is split into.";
                throw new IllegalStateException(string.toString());
            }
        }

        private final QueryVisitor getNumClausesCheckVisitor() {
            return new QueryVisitor(){
                private int numClauses;

                public final int getNumClauses() {
                    return this.numClauses;
                }

                public final void setNumClauses(int n) {
                    this.numClauses = n;
                }

                public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                    Intrinsics.checkNotNullParameter((Object)((Object)occur), (String)"occur");
                    Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                    return this;
                }

                public void visitLeaf(Query query) {
                    if (this.numClauses > IndexSearcher.Companion.getMaxClauseCount()) {
                        throw new TooManyNestedClauses();
                    }
                    ++this.numClauses;
                }

                public void consumeTerms(Query query, Term ... terms) {
                    Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                    Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
                    if (this.numClauses > IndexSearcher.Companion.getMaxClauseCount()) {
                        throw new TooManyNestedClauses();
                    }
                    ++this.numClauses;
                }

                public void consumeTermsMatching(Query query, String field, Function0<ByteRunAutomaton> automaton) {
                    Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    Intrinsics.checkNotNullParameter(automaton, (String)"automaton");
                    if (this.numClauses > IndexSearcher.Companion.getMaxClauseCount()) {
                        throw new TooManyNestedClauses();
                    }
                    ++this.numClauses;
                }
            };
        }

        public static final /* synthetic */ void access$enforceDistinctLeaves(Companion $this, LeafSlice leafSlice) {
            $this.enforceDistinctLeaves(leafSlice);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition;", "", "leafReaderContext", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "minDocId", "", "maxDocId", "maxDocs", "<init>", "(Lorg/gnit/lucenekmp/index/LeafReaderContext;III)V", "getMinDocId", "()I", "getMaxDocId", "ctx", "getCtx", "()Lorg/gnit/lucenekmp/index/LeafReaderContext;", "getMaxDocs", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nIndexSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1262:1\n1#2:1263\n*E\n"})
    public static final class LeafReaderContextPartition {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int minDocId;
        private final int maxDocId;
        @NotNull
        private final LeafReaderContext ctx;
        private final int maxDocs;

        private LeafReaderContextPartition(LeafReaderContext leafReaderContext, int minDocId, int maxDocId, int maxDocs) {
            if (!(minDocId < maxDocId)) {
                boolean $i$a$-require-IndexSearcher$LeafReaderContextPartition$42 = false;
                String $i$a$-require-IndexSearcher$LeafReaderContextPartition$42 = "minDocId is greater than or equal to maxDocId: [" + minDocId + "] > [" + maxDocId + "]";
                throw new IllegalArgumentException($i$a$-require-IndexSearcher$LeafReaderContextPartition$42.toString());
            }
            if (!(minDocId >= 0)) {
                boolean $i$a$-require-IndexSearcher$LeafReaderContextPartition$52 = false;
                String $i$a$-require-IndexSearcher$LeafReaderContextPartition$52 = "minDocId is lower than 0: [" + minDocId + "]";
                throw new IllegalArgumentException($i$a$-require-IndexSearcher$LeafReaderContextPartition$52.toString());
            }
            if (!(minDocId < leafReaderContext.reader().maxDoc())) {
                boolean bl = false;
                String string = "minDocId is greater than than maxDoc: [" + minDocId + "] > [" + leafReaderContext.reader().maxDoc() + "]";
                throw new IllegalArgumentException(string.toString());
            }
            this.ctx = leafReaderContext;
            this.minDocId = minDocId;
            this.maxDocId = maxDocId;
            this.maxDocs = maxDocs;
        }

        public final int getMinDocId() {
            return this.minDocId;
        }

        public final int getMaxDocId() {
            return this.maxDocId;
        }

        @NotNull
        public final LeafReaderContext getCtx() {
            return this.ctx;
        }

        public final int getMaxDocs() {
            return this.maxDocs;
        }

        public /* synthetic */ LeafReaderContextPartition(LeafReaderContext leafReaderContext, int minDocId, int maxDocId, int maxDocs, DefaultConstructorMarker $constructor_marker) {
            this(leafReaderContext, minDocId, maxDocId, maxDocs);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition$Companion;", "", "<init>", "()V", "createForEntireSegment", "Lorg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition;", "ctx", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "createFromAndTo", "minDocId", "", "maxDocId", "core"})
        @SourceDebugExtension(value={"SMAP\nIndexSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition$Companion\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,1262:1\n3#2,8:1263\n10#3:1271\n*S KotlinDebug\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition$Companion\n*L\n888#1:1263,8\n888#1:1271\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LeafReaderContextPartition createForEntireSegment(@NotNull LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return new LeafReaderContextPartition(ctx, 0, Integer.MAX_VALUE, ctx.reader().maxDoc(), null);
            }

            @NotNull
            public final LeafReaderContextPartition createFromAndTo(@NotNull LeafReaderContext ctx, int minDocId, int maxDocId) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                boolean condition$iv = maxDocId != Integer.MAX_VALUE;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                return new LeafReaderContextPartition(ctx, minDocId, maxDocId, maxDocId - minDocId, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "", "leafReaderContextPartitions", "", "Lorg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition;", "<init>", "(Ljava/util/List;)V", "partitions", "", "getPartitions", "()[Lorg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition;", "[Lorg/gnit/lucenekmp/search/IndexSearcher$LeafReaderContextPartition;", "maxDocs", "", "getMaxDocs", "()I", "core"})
    @SourceDebugExtension(value={"SMAP\nIndexSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher$LeafSlice\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1262:1\n37#2:1263\n36#2,3:1264\n1#3:1267\n*S KotlinDebug\n*F\n+ 1 IndexSearcher.kt\norg/gnit/lucenekmp/search/IndexSearcher$LeafSlice\n*L\n818#1:1263\n818#1:1264,3\n*E\n"})
    public static final class LeafSlice {
        @NotNull
        private final LeafReaderContextPartition[] partitions;
        private final int maxDocs;

        /*
         * WARNING - void declaration
         */
        public LeafSlice(@NotNull List<LeafReaderContextPartition> leafReaderContextPartitions) {
            int n;
            Intrinsics.checkNotNullParameter(leafReaderContextPartitions, (String)"leafReaderContextPartitions");
            LeafReaderContextPartition[] leafReaderContextPartitionArray = (LeafReaderContextPartition[])new Comparator(){

                public final int compare(T a, T b) {
                    LeafReaderContextPartition it = (LeafReaderContextPartition)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCtx().getDocBase());
                    it = (LeafReaderContextPartition)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getCtx().getDocBase()));
                }
            };
            CollectionsKt.sortWith(leafReaderContextPartitions, (Comparator)new Comparator((Comparator)leafReaderContextPartitionArray){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        LeafReaderContextPartition it = (LeafReaderContextPartition)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getMinDocId());
                        it = (LeafReaderContextPartition)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getMinDocId()));
                    }
                    return n;
                }
            });
            Collection $this$toTypedArray$iv = leafReaderContextPartitions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            leafReaderContextPartitionArray = this.partitions = thisCollection$iv.toArray(new LeafReaderContextPartition[0]);
            LeafSlice leafSlice = this;
            int n2 = 0;
            int n3 = leafReaderContextPartitionArray.length;
            for (int i = 0; i < n3; ++i) {
                void it;
                LeafReaderContextPartition leafReaderContextPartition;
                LeafReaderContextPartition leafReaderContextPartition2 = leafReaderContextPartition = leafReaderContextPartitionArray[i];
                n = n2;
                boolean bl = false;
                int n4 = it.getMaxDocs();
                n2 = n + n4;
            }
            leafSlice.maxDocs = n = n2;
        }

        @NotNull
        public final LeafReaderContextPartition[] getPartitions() {
            return this.partitions;
        }

        public final int getMaxDocs() {
            return this.maxDocs;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/search/IndexSearcher$TooManyClauses;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "msg", "", "<init>", "(Ljava/lang/String;)V", "maxClauseCount", "", "getMaxClauseCount", "()I", "core"})
    public static class TooManyClauses
    extends RuntimeException {
        private final int maxClauseCount;

        public TooManyClauses(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
            this.maxClauseCount = Companion.getMaxClauseCount();
        }

        public /* synthetic */ TooManyClauses(String object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                object = "maxClauseCount is set to " + Companion.getMaxClauseCount();
            }
            this((String)object);
        }

        public final int getMaxClauseCount() {
            return this.maxClauseCount;
        }

        public TooManyClauses() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/gnit/lucenekmp/search/IndexSearcher$TooManyNestedClauses;", "Lorg/gnit/lucenekmp/search/IndexSearcher$TooManyClauses;", "<init>", "()V", "core"})
    public static final class TooManyNestedClauses
    extends TooManyClauses {
        public TooManyNestedClauses() {
            super("Query contains too many nested clauses; maxClauseCount is set to " + Companion.getMaxClauseCount());
        }
    }
}

