/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.AbstractKnnVectorQuery;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopDocsCollector;
import org.gnit.lucenekmp.search.VectorScorer;
import org.gnit.lucenekmp.search.knn.KnnCollectorManager;
import org.gnit.lucenekmp.search.knn.KnnSearchStrategy;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0007H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010#\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/search/KnnByteVectorQuery;", "Lorg/gnit/lucenekmp/search/AbstractKnnVectorQuery;", "field", "", "target", "", "k", "", "filter", "Lorg/gnit/lucenekmp/search/Query;", "searchStrategy", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "<init>", "(Ljava/lang/String;[BILorg/gnit/lucenekmp/search/Query;Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;)V", "getTarget", "()[B", "approximateSearch", "Lorg/gnit/lucenekmp/search/TopDocs;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "visitedLimit", "knnCollectorManager", "Lorg/gnit/lucenekmp/search/knn/KnnCollectorManager;", "createVectorScorer", "Lorg/gnit/lucenekmp/search/VectorScorer;", "fi", "Lorg/gnit/lucenekmp/index/FieldInfo;", "toString", "equals", "", "o", "", "hashCode", "targetCopy", "getTargetCopy", "Companion", "core"})
public class KnnByteVectorQuery
extends AbstractKnnVectorQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] target;
    @NotNull
    private static final TopDocs NO_RESULTS = TopDocsCollector.Companion.getEMPTY_TOPDOCS();

    @JvmOverloads
    public KnnByteVectorQuery(@NotNull String field, @NotNull byte[] target, int k, @Nullable Query filter, @NotNull KnnSearchStrategy searchStrategy) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)searchStrategy, (String)"searchStrategy");
        super(field, k, filter, searchStrategy);
        this.target = target;
    }

    public /* synthetic */ KnnByteVectorQuery(String string, byte[] byArray, int n, Query query, KnnSearchStrategy knnSearchStrategy, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            query = null;
        }
        if ((n2 & 0x10) != 0) {
            knnSearchStrategy = KnnSearchStrategy.Hnsw.Companion.getDEFAULT();
        }
        this(string, byArray, n, query, knnSearchStrategy);
    }

    @NotNull
    protected final byte[] getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    protected TopDocs approximateSearch(@NotNull LeafReaderContext context, @NotNull Bits acceptDocs, int visitedLimit, @NotNull KnnCollectorManager knnCollectorManager) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)acceptDocs, (String)"acceptDocs");
        Intrinsics.checkNotNullParameter((Object)knnCollectorManager, (String)"knnCollectorManager");
        KnnCollector knnCollector = knnCollectorManager.newCollector(visitedLimit, this.getSearchStrategy(), context);
        LeafReader reader2 = context.reader();
        ByteVectorValues byteVectorValues = reader2.getByteVectorValues(this.getField());
        if (byteVectorValues == null) {
            ByteVectorValues.Companion.checkField(reader2, this.getField());
            return NO_RESULTS;
        }
        if (Math.min(knnCollector.k(), byteVectorValues.size()) == 0) {
            return NO_RESULTS;
        }
        reader2.searchNearestVectors(this.getField(), this.target, knnCollector, acceptDocs);
        TopDocs results2 = knnCollector.topDocs();
        TopDocs topDocs = results2;
        if (topDocs == null) {
            topDocs = NO_RESULTS;
        }
        return topDocs;
    }

    @Override
    @Nullable
    public VectorScorer createVectorScorer(@NotNull LeafReaderContext context, @NotNull FieldInfo fi) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fi, (String)"fi");
        LeafReader reader2 = context.reader();
        ByteVectorValues vectorValues = reader2.getByteVectorValues(this.getField());
        if (vectorValues == null) {
            ByteVectorValues.Companion.checkField(reader2, this.getField());
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ":");
        buffer.append(this.getField() + "[" + this.target[0] + ",...]");
        buffer.append("[" + this.getK() + "]");
        if (this.getFilter() != null) {
            buffer.append("[" + this.getFilter() + "]");
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.KnnByteVectorQuery");
        KnnByteVectorQuery that = (KnnByteVectorQuery)o;
        return Arrays.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), Arrays.hashCode(this.target)};
        return Objects.INSTANCE.hash(objectArray);
    }

    @NotNull
    public final byte[] getTargetCopy() {
        return ArrayUtil.Companion.copyArray(this.target);
    }

    @JvmOverloads
    public KnnByteVectorQuery(@NotNull String field, @NotNull byte[] target, int k, @Nullable Query filter) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this(field, target, k, filter, null, 16, null);
    }

    @JvmOverloads
    public KnnByteVectorQuery(@NotNull String field, @NotNull byte[] target, int k) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this(field, target, k, null, null, 24, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/search/KnnByteVectorQuery$Companion;", "", "<init>", "()V", "NO_RESULTS", "Lorg/gnit/lucenekmp/search/TopDocs;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

