/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.DenseConjunctionBulkScorer;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/MatchAllScorerSupplier;", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "score", "", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "maxDoc", "", "<init>", "(FLorg/gnit/lucenekmp/search/ScoreMode;I)V", "get", "Lorg/gnit/lucenekmp/search/Scorer;", "leadCost", "", "bulkScorer", "Lorg/gnit/lucenekmp/search/BulkScorer;", "cost", "core"})
public final class MatchAllScorerSupplier
extends ScorerSupplier {
    private final float score;
    @NotNull
    private final ScoreMode scoreMode;
    private final int maxDoc;

    public MatchAllScorerSupplier(float score2, @NotNull ScoreMode scoreMode, int maxDoc) {
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        this.score = score2;
        this.scoreMode = scoreMode;
        this.maxDoc = maxDoc;
    }

    @Override
    @NotNull
    public Scorer get(long leadCost) throws IOException {
        return new ConstantScoreScorer(this.score, this.scoreMode, DocIdSetIterator.Companion.all(this.maxDoc));
    }

    @Override
    @Nullable
    public BulkScorer bulkScorer() throws IOException {
        if (this.maxDoc >= 2048) {
            return new DenseConjunctionBulkScorer(new ArrayList(), this.maxDoc, this.score);
        }
        return super.bulkScorer();
    }

    @Override
    public long cost() {
        return this.maxDoc;
    }
}

