/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.Impact;
import org.gnit.lucenekmp.index.Impacts;
import org.gnit.lucenekmp.index.ImpactsSource;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0016\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000fJ\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0002J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/search/MaxScoreCache;", "", "impactsSource", "Lorg/gnit/lucenekmp/index/ImpactsSource;", "scorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "<init>", "(Lorg/gnit/lucenekmp/index/ImpactsSource;Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;)V", "globalMaxScore", "", "maxScoreCache", "", "maxScoreCacheUpTo", "", "advanceShallow", "", "target", "ensureCacheSize", "", "size", "computeMaxScore", "impacts", "", "Lorg/gnit/lucenekmp/index/Impact;", "getMaxScore", "upTo", "getLevel", "maxScoreForLevelZero", "getMaxScoreForLevelZero", "()F", "getMaxScoreForLevel", "level", "getSkipLevel", "Lorg/gnit/lucenekmp/index/Impacts;", "minScore", "getSkipUpTo", "core"})
@SourceDebugExtension(value={"SMAP\nMaxScoreCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxScoreCache.kt\norg/gnit/lucenekmp/search/MaxScoreCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class MaxScoreCache {
    @NotNull
    private final ImpactsSource impactsSource;
    @NotNull
    private final Similarity.SimScorer scorer;
    private final float globalMaxScore;
    @NotNull
    private float[] maxScoreCache;
    @NotNull
    private int[] maxScoreCacheUpTo;

    public MaxScoreCache(@NotNull ImpactsSource impactsSource2, @NotNull Similarity.SimScorer scorer2) {
        Intrinsics.checkNotNullParameter((Object)impactsSource2, (String)"impactsSource");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        this.impactsSource = impactsSource2;
        this.scorer = scorer2;
        this.globalMaxScore = scorer2.score(Float.MAX_VALUE, 1L);
        this.maxScoreCache = new float[0];
        this.maxScoreCacheUpTo = new int[0];
    }

    public final int advanceShallow(int target) throws IOException {
        this.impactsSource.advanceShallow(target);
        Impacts impacts2 = this.impactsSource.getImpacts();
        return impacts2.getDocIdUpTo(0);
    }

    private final void ensureCacheSize(int size2) {
        if (this.maxScoreCache.length < size2) {
            int oldLength = this.maxScoreCache.length;
            this.maxScoreCache = ArrayUtil.Companion.grow(this.maxScoreCache, size2);
            this.maxScoreCacheUpTo = ArrayUtil.Companion.growExact(this.maxScoreCacheUpTo, this.maxScoreCache.length);
            Arrays.INSTANCE.fill(this.maxScoreCacheUpTo, oldLength, this.maxScoreCacheUpTo.length, -1);
        }
    }

    private final float computeMaxScore(List<Impact> impacts2) {
        float maxScore = 0.0f;
        Similarity.SimScorer scorer2 = this.scorer;
        int length = impacts2.size();
        for (int i = 0; i < length; ++i) {
            Impact impact = impacts2.get(i);
            maxScore = Math.max(scorer2.score(impact.getFreq(), impact.getNorm()), maxScore);
        }
        return maxScore;
    }

    public final float getMaxScore(int upTo) throws IOException {
        int level = this.getLevel(upTo);
        if (level == -1) {
            return this.globalMaxScore;
        }
        return this.getMaxScoreForLevel(level);
    }

    private final int getLevel(int upTo) throws IOException {
        Impacts impacts2 = this.impactsSource.getImpacts();
        int numLevels = impacts2.numLevels();
        for (int level = 0; level < numLevels; ++level) {
            int impactsUpTo = impacts2.getDocIdUpTo(level);
            if (upTo > impactsUpTo) continue;
            return level;
        }
        return -1;
    }

    public final float getMaxScoreForLevelZero() {
        return this.getMaxScoreForLevel(0);
    }

    private final float getMaxScoreForLevel(int level) throws IOException {
        if (!(level >= 0)) {
            boolean $i$a$-require-MaxScoreCache$getMaxScoreForLevel$22 = false;
            String $i$a$-require-MaxScoreCache$getMaxScoreForLevel$22 = "level must not be a negative integer; got " + level;
            throw new IllegalArgumentException($i$a$-require-MaxScoreCache$getMaxScoreForLevel$22.toString());
        }
        Impacts impacts2 = this.impactsSource.getImpacts();
        this.ensureCacheSize(level + 1);
        int levelUpTo = impacts2.getDocIdUpTo(level);
        if (this.maxScoreCacheUpTo[level] < levelUpTo) {
            this.maxScoreCache[level] = this.computeMaxScore(impacts2.getImpacts(level));
            this.maxScoreCacheUpTo[level] = levelUpTo;
        }
        return this.maxScoreCache[level];
    }

    private final int getSkipLevel(Impacts impacts2, float minScore) throws IOException {
        int numLevels = impacts2.numLevels();
        for (int level = 0; level < numLevels; ++level) {
            if (!(this.getMaxScoreForLevel(level) >= minScore)) continue;
            return level - 1;
        }
        return numLevels - 1;
    }

    public final int getSkipUpTo(float minScore) throws IOException {
        Impacts impacts2 = this.impactsSource.getImpacts();
        int level = this.getSkipLevel(impacts2, minScore);
        if (level == -1) {
            return -1;
        }
        return impacts2.getDocIdUpTo(level);
    }
}

