/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.BlendedTermQuery;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.DocValuesRewriteMethod;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MultiTermQueryConstantScoreBlendedWrapper;
import org.gnit.lucenekmp.search.MultiTermQueryConstantScoreWrapper;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.ScoringRewrite;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.search.TopTermsRewrite;
import org.gnit.lucenekmp.util.AttributeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b&\u0018\u0000 $2\u00020\u0001:\u0005 !\"#$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0000H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/search/MultiTermQuery;", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "rewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;)V", "getField", "()Ljava/lang/String;", "getRewriteMethod", "()Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "getTermsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "atts", "Lorg/gnit/lucenekmp/util/AttributeSource;", "termsCount", "", "getTermsCount", "()J", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "hashCode", "", "equals", "", "other", "", "equalsTo", "RewriteMethod", "TopTermsScoringBooleanQueryRewrite", "TopTermsBlendedFreqScoringRewrite", "TopTermsBoostOnlyBooleanQueryRewrite", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMultiTermQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiTermQuery.kt\norg/gnit/lucenekmp/search/MultiTermQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1#2:306\n*E\n"})
public abstract class MultiTermQuery
extends Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    @NotNull
    private final RewriteMethod rewriteMethod;
    @NotNull
    private static final RewriteMethod CONSTANT_SCORE_BLENDED_REWRITE = new RewriteMethod(){

        public Query rewrite(IndexSearcher indexSearcher, MultiTermQuery query) {
            Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MultiTermQueryConstantScoreBlendedWrapper<MultiTermQuery>(query);
        }
    };
    @NotNull
    private static final RewriteMethod CONSTANT_SCORE_REWRITE = new RewriteMethod(){

        public Query rewrite(IndexSearcher indexSearcher, MultiTermQuery query) {
            Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return new MultiTermQueryConstantScoreWrapper<MultiTermQuery>(query);
        }
    };
    @NotNull
    private static final RewriteMethod DOC_VALUES_REWRITE = new DocValuesRewriteMethod();
    @NotNull
    private static final RewriteMethod SCORING_BOOLEAN_REWRITE = ScoringRewrite.Companion.getSCORING_BOOLEAN_REWRITE();
    @NotNull
    private static final RewriteMethod CONSTANT_SCORE_BOOLEAN_REWRITE = ScoringRewrite.Companion.getCONSTANT_SCORE_BOOLEAN_REWRITE();

    public MultiTermQuery(@NotNull String field, @NotNull RewriteMethod rewriteMethod) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)rewriteMethod, (String)"rewriteMethod");
        this.field = field;
        this.rewriteMethod = rewriteMethod;
    }

    @NotNull
    public String getField() {
        return this.field;
    }

    @NotNull
    public final RewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    @NotNull
    protected abstract TermsEnum getTermsEnum(@NotNull Terms var1, @NotNull AttributeSource var2) throws IOException;

    @NotNull
    public final TermsEnum getTermsEnum(@NotNull Terms terms) throws IOException {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        return this.getTermsEnum(terms, new AttributeSource());
    }

    public long getTermsCount() {
        return -1L;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        return this.rewriteMethod.rewrite(indexSearcher, this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = prime * result + this.rewriteMethod.hashCode();
        result = prime * result + this.getField().hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other) && this.equalsTo((MultiTermQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean equalsTo(MultiTermQuery other) {
        return Intrinsics.areEqual((Object)this.rewriteMethod, (Object)other.rewriteMethod) && Intrinsics.areEqual((Object)this.getField(), (Object)other.getField());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/MultiTermQuery$Companion;", "", "<init>", "()V", "CONSTANT_SCORE_BLENDED_REWRITE", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "getCONSTANT_SCORE_BLENDED_REWRITE", "()Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "CONSTANT_SCORE_REWRITE", "getCONSTANT_SCORE_REWRITE", "DOC_VALUES_REWRITE", "getDOC_VALUES_REWRITE", "SCORING_BOOLEAN_REWRITE", "getSCORING_BOOLEAN_REWRITE", "CONSTANT_SCORE_BOOLEAN_REWRITE", "getCONSTANT_SCORE_BOOLEAN_REWRITE", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RewriteMethod getCONSTANT_SCORE_BLENDED_REWRITE() {
            return CONSTANT_SCORE_BLENDED_REWRITE;
        }

        @NotNull
        public final RewriteMethod getCONSTANT_SCORE_REWRITE() {
            return CONSTANT_SCORE_REWRITE;
        }

        @NotNull
        public final RewriteMethod getDOC_VALUES_REWRITE() {
            return DOC_VALUES_REWRITE;
        }

        @NotNull
        public final RewriteMethod getSCORING_BOOLEAN_REWRITE() {
            return SCORING_BOOLEAN_REWRITE;
        }

        @NotNull
        public final RewriteMethod getCONSTANT_SCORE_BOOLEAN_REWRITE() {
            return CONSTANT_SCORE_BOOLEAN_REWRITE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "", "<init>", "()V", "rewrite", "Lorg/gnit/lucenekmp/search/Query;", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "query", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "getTermsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "atts", "Lorg/gnit/lucenekmp/util/AttributeSource;", "core"})
    public static abstract class RewriteMethod {
        @NotNull
        public abstract Query rewrite(@NotNull IndexSearcher var1, @NotNull MultiTermQuery var2) throws IOException;

        @NotNull
        protected final TermsEnum getTermsEnum(@NotNull MultiTermQuery query, @NotNull Terms terms, @NotNull AttributeSource atts) throws IOException {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
            Intrinsics.checkNotNullParameter((Object)atts, (String)"atts");
            return query.getTermsEnum(terms, atts);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00028TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/MultiTermQuery$TopTermsBlendedFreqScoringRewrite;", "Lorg/gnit/lucenekmp/search/TopTermsRewrite;", "Lorg/gnit/lucenekmp/search/BlendedTermQuery$Builder;", "size", "", "<init>", "(I)V", "maxSize", "getMaxSize", "()I", "topLevelBuilder", "getTopLevelBuilder", "()Lorg/gnit/lucenekmp/search/BlendedTermQuery$Builder;", "build", "Lorg/gnit/lucenekmp/search/Query;", "builder", "addClause", "", "topLevel", "term", "Lorg/gnit/lucenekmp/index/Term;", "docCount", "boost", "", "states", "Lorg/gnit/lucenekmp/index/TermStates;", "core"})
    public static final class TopTermsBlendedFreqScoringRewrite
    extends TopTermsRewrite<BlendedTermQuery.Builder> {
        public TopTermsBlendedFreqScoringRewrite(int size2) {
            super(size2);
        }

        @Override
        protected int getMaxSize() {
            return IndexSearcher.Companion.getMaxClauseCount();
        }

        @Override
        @NotNull
        protected BlendedTermQuery.Builder getTopLevelBuilder() {
            BlendedTermQuery.Builder builder = new BlendedTermQuery.Builder();
            builder.setRewriteMethod(BlendedTermQuery.Companion.getBOOLEAN_REWRITE());
            return builder;
        }

        @Override
        @NotNull
        protected Query build(@NotNull BlendedTermQuery.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return builder.build();
        }

        @Override
        protected void addClause(@NotNull BlendedTermQuery.Builder topLevel, @NotNull Term term, int docCount, float boost, @Nullable TermStates states) {
            Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            topLevel.add(term, boost, states);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00028TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/MultiTermQuery$TopTermsBoostOnlyBooleanQueryRewrite;", "Lorg/gnit/lucenekmp/search/TopTermsRewrite;", "Lorg/gnit/lucenekmp/search/BooleanQuery$Builder;", "size", "", "<init>", "(I)V", "maxSize", "getMaxSize", "()I", "topLevelBuilder", "getTopLevelBuilder", "()Lorg/gnit/lucenekmp/search/BooleanQuery$Builder;", "build", "Lorg/gnit/lucenekmp/search/Query;", "builder", "addClause", "", "topLevel", "term", "Lorg/gnit/lucenekmp/index/Term;", "docFreq", "boost", "", "states", "Lorg/gnit/lucenekmp/index/TermStates;", "core"})
    public static final class TopTermsBoostOnlyBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery.Builder> {
        public TopTermsBoostOnlyBooleanQueryRewrite(int size2) {
            super(size2);
        }

        @Override
        protected int getMaxSize() {
            return IndexSearcher.Companion.getMaxClauseCount();
        }

        @Override
        @NotNull
        protected BooleanQuery.Builder getTopLevelBuilder() {
            return new BooleanQuery.Builder();
        }

        @Override
        @NotNull
        protected Query build(@NotNull BooleanQuery.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return builder.build();
        }

        @Override
        protected void addClause(@NotNull BooleanQuery.Builder topLevel, @NotNull Term term, int docFreq, float boost, @Nullable TermStates states) {
            Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            TermStates termStates = states;
            Intrinsics.checkNotNull((Object)termStates);
            Query q = new ConstantScoreQuery(new TermQuery(term, termStates));
            topLevel.add(new BoostQuery(q, boost), BooleanClause.Occur.SHOULD);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00028TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/MultiTermQuery$TopTermsScoringBooleanQueryRewrite;", "Lorg/gnit/lucenekmp/search/TopTermsRewrite;", "Lorg/gnit/lucenekmp/search/BooleanQuery$Builder;", "size", "", "<init>", "(I)V", "maxSize", "getMaxSize", "()I", "topLevelBuilder", "getTopLevelBuilder", "()Lorg/gnit/lucenekmp/search/BooleanQuery$Builder;", "build", "Lorg/gnit/lucenekmp/search/Query;", "builder", "addClause", "", "topLevel", "term", "Lorg/gnit/lucenekmp/index/Term;", "docCount", "boost", "", "states", "Lorg/gnit/lucenekmp/index/TermStates;", "core"})
    public static final class TopTermsScoringBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery.Builder> {
        public TopTermsScoringBooleanQueryRewrite(int size2) {
            super(size2);
        }

        @Override
        protected int getMaxSize() {
            return IndexSearcher.Companion.getMaxClauseCount();
        }

        @Override
        @NotNull
        protected BooleanQuery.Builder getTopLevelBuilder() {
            return new BooleanQuery.Builder();
        }

        @Override
        @NotNull
        protected Query build(@NotNull BooleanQuery.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return builder.build();
        }

        @Override
        protected void addClause(@NotNull BooleanQuery.Builder topLevel, @NotNull Term term, int docCount, float boost, @Nullable TermStates states) {
            Intrinsics.checkNotNullParameter((Object)topLevel, (String)"topLevel");
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            TermStates termStates = states;
            Intrinsics.checkNotNull((Object)termStates);
            TermQuery tq = new TermQuery(term, termStates);
            topLevel.add(new BoostQuery(tq, boost), BooleanClause.Occur.SHOULD);
        }
    }
}

