/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.Term;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0010\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u0016R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000f\"\u0004\b$\u0010\u0016R\u001a\u0010%\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000f\"\u0004\b'\u0010\u0016\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/search/PhrasePositions;", "", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "o", "", "ord", "terms", "", "Lorg/gnit/lucenekmp/index/Term;", "<init>", "(Lorg/gnit/lucenekmp/index/PostingsEnum;II[Lorg/gnit/lucenekmp/index/Term;)V", "getPostings", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "getOrd", "()I", "getTerms", "()[Lorg/gnit/lucenekmp/index/Term;", "[Lorg/gnit/lucenekmp/index/Term;", "position", "getPosition", "setPosition", "(I)V", "count", "getCount", "setCount", "offset", "getOffset", "setOffset", "next", "getNext", "()Lorg/gnit/lucenekmp/search/PhrasePositions;", "setNext", "(Lorg/gnit/lucenekmp/search/PhrasePositions;)V", "rptGroup", "getRptGroup", "setRptGroup", "rptInd", "getRptInd", "setRptInd", "firstPosition", "", "nextPosition", "", "toString", "", "core"})
public final class PhrasePositions {
    @NotNull
    private final PostingsEnum postings;
    private final int ord;
    @Nullable
    private final Term[] terms;
    private int position;
    private int count;
    private int offset;
    @Nullable
    private PhrasePositions next;
    private int rptGroup;
    private int rptInd;

    public PhrasePositions(@NotNull PostingsEnum postings, int o, int ord, @Nullable Term[] terms) {
        Intrinsics.checkNotNullParameter((Object)postings, (String)"postings");
        this.postings = postings;
        this.ord = ord;
        this.terms = terms;
        this.offset = o;
        this.rptGroup = -1;
    }

    @NotNull
    public final PostingsEnum getPostings() {
        return this.postings;
    }

    public final int getOrd() {
        return this.ord;
    }

    @Nullable
    public final Term[] getTerms() {
        return this.terms;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int n) {
        this.count = n;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    @Nullable
    public final PhrasePositions getNext() {
        return this.next;
    }

    public final void setNext(@Nullable PhrasePositions phrasePositions) {
        this.next = phrasePositions;
    }

    public final int getRptGroup() {
        return this.rptGroup;
    }

    public final void setRptGroup(int n) {
        this.rptGroup = n;
    }

    public final int getRptInd() {
        return this.rptInd;
    }

    public final void setRptInd(int n) {
        this.rptInd = n;
    }

    public final void firstPosition() throws IOException {
        this.count = this.postings.freq();
        this.nextPosition();
    }

    public final boolean nextPosition() throws IOException {
        int n = this.count;
        this.count = n + -1;
        if (n > 0) {
            this.position = this.postings.nextPosition() - this.offset;
            return true;
        }
        return false;
    }

    @NotNull
    public String toString() {
        String s = "o:" + this.offset + " p:" + this.position + " c:" + this.count;
        if (this.rptGroup >= 0) {
            s = s + " rpt:" + this.rptGroup + ",i" + this.rptInd;
        }
        return s;
    }
}

