/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.ConstantScoreScorerSupplier;
import org.gnit.lucenekmp.search.ConstantScoreWeight;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchAllScorerSupplier;
import org.gnit.lucenekmp.search.PointRangeQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.DocIdSetBuilder;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IntsRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b&\u0018\u0000 *2\u00020\u0001:\u0001*B)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\bH\u0016J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0000H\u0002J\u0012\u0010(\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0005H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/search/PointRangeQuery;", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "lowerPoint", "", "upperPoint", "numDims", "", "<init>", "(Ljava/lang/String;[B[BI)V", "getField", "()Ljava/lang/String;", "getNumDims", "()I", "bytesPerDim", "getBytesPerDim", "value", "getLowerPoint", "()[B", "getUpperPoint", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "hashCode", "equals", "", "o", "", "equalsTo", "other", "toString", "dimension", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPointRangeQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointRangeQuery.kt\norg/gnit/lucenekmp/search/PointRangeQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,542:1\n1#2:543\n*E\n"})
public abstract class PointRangeQuery
extends Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    private final int numDims;
    private final int bytesPerDim;
    @NotNull
    private byte[] lowerPoint;
    @NotNull
    private byte[] upperPoint;

    protected PointRangeQuery(@NotNull String field, @NotNull byte[] lowerPoint, @NotNull byte[] upperPoint, int numDims) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)lowerPoint, (String)"lowerPoint");
        Intrinsics.checkNotNullParameter((Object)upperPoint, (String)"upperPoint");
        this.lowerPoint = lowerPoint;
        this.upperPoint = upperPoint;
        Companion.checkArgs(field, lowerPoint, upperPoint);
        this.field = field;
        if (!(numDims > 0)) {
            boolean $i$a$-require-PointRangeQuery$52 = false;
            String $i$a$-require-PointRangeQuery$52 = "numDims must be positive, got " + numDims;
            throw new IllegalArgumentException($i$a$-require-PointRangeQuery$52.toString());
        }
        if (!(!(lowerPoint.length == 0))) {
            boolean $i$a$-require-PointRangeQuery$62 = false;
            String $i$a$-require-PointRangeQuery$62 = "lowerPoint has length of zero";
            throw new IllegalArgumentException($i$a$-require-PointRangeQuery$62.toString());
        }
        if (!(lowerPoint.length % numDims == 0)) {
            boolean $i$a$-require-PointRangeQuery$72 = false;
            String $i$a$-require-PointRangeQuery$72 = "lowerPoint is not a fixed multiple of numDims";
            throw new IllegalArgumentException($i$a$-require-PointRangeQuery$72.toString());
        }
        if (!(lowerPoint.length == upperPoint.length)) {
            boolean bl = false;
            String string = "lowerPoint has length=" + lowerPoint.length + " but upperPoint has different length=" + upperPoint.length;
            throw new IllegalArgumentException(string.toString());
        }
        this.numDims = numDims;
        this.bytesPerDim = lowerPoint.length / numDims;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    public final int getNumDims() {
        return this.numDims;
    }

    public final int getBytesPerDim() {
        return this.bytesPerDim;
    }

    @NotNull
    public final byte[] getLowerPoint() {
        byte[] byArray = Arrays.copyOf(this.lowerPoint, this.lowerPoint.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getUpperPoint() {
        byte[] byArray = Arrays.copyOf(this.upperPoint, this.upperPoint.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        return byArray;
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.field)) {
            visitor2.visitLeaf(this);
        }
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        return new ConstantScoreWeight(this, boost, scoreMode){
            private final ArrayUtil.Companion.ByteArrayComparator comparator;
            final /* synthetic */ PointRangeQuery this$0;
            final /* synthetic */ ScoreMode $scoreMode;
            {
                this.this$0 = $receiver;
                this.$scoreMode = $scoreMode;
                super($receiver, $boost);
                this.comparator = ArrayUtil.Companion.getUnsignedComparator($receiver.getBytesPerDim());
            }

            public final boolean matches(byte[] packedValue) {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                int offset = 0;
                int dim = 0;
                while (dim < this.this$0.getNumDims()) {
                    if (this.comparator.compare(packedValue, offset, this.this$0.getLowerPoint(), offset) < 0) {
                        return false;
                    }
                    if (this.comparator.compare(packedValue, offset, this.this$0.getUpperPoint(), offset) > 0) {
                        return false;
                    }
                    ++dim;
                    offset += this.this$0.getBytesPerDim();
                }
                return true;
            }

            public final PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                boolean crosses = false;
                int offset = 0;
                int dim = 0;
                while (dim < this.this$0.getNumDims()) {
                    if (this.comparator.compare(minPackedValue, offset, this.this$0.getUpperPoint(), offset) > 0 || this.comparator.compare(maxPackedValue, offset, this.this$0.getLowerPoint(), offset) < 0) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    crosses |= this.comparator.compare(minPackedValue, offset, this.this$0.getLowerPoint(), offset) < 0 || this.comparator.compare(maxPackedValue, offset, this.this$0.getUpperPoint(), offset) > 0;
                    ++dim;
                    offset += this.this$0.getBytesPerDim();
                }
                return crosses ? PointValues.Relation.CELL_CROSSES_QUERY : PointValues.Relation.CELL_INSIDE_QUERY;
            }

            public final PointValues.IntersectVisitor getIntersectVisitor(DocIdSetBuilder result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                return new PointValues.IntersectVisitor(result, this){
                    private DocIdSetBuilder.BulkAdder adder;
                    final /* synthetic */ DocIdSetBuilder $result;
                    final /* synthetic */ createWeight.1 this$0;
                    {
                        this.$result = $result;
                        this.this$0 = $receiver;
                    }

                    public final DocIdSetBuilder.BulkAdder getAdder() {
                        return this.adder;
                    }

                    public final void setAdder(DocIdSetBuilder.BulkAdder bulkAdder) {
                        this.adder = bulkAdder;
                    }

                    public void grow(int count) {
                        this.adder = this.$result.grow(count);
                    }

                    public void visit(int docID) {
                        DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                        Intrinsics.checkNotNull((Object)bulkAdder);
                        bulkAdder.add(docID);
                    }

                    public void visit(DocIdSetIterator iterator2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                        DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                        Intrinsics.checkNotNull((Object)bulkAdder);
                        bulkAdder.add(iterator2);
                    }

                    public void visit(IntsRef ref) {
                        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                        DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                        Intrinsics.checkNotNull((Object)bulkAdder);
                        bulkAdder.add(ref);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (this.this$0.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (this.this$0.matches(packedValue)) {
                            DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                            Intrinsics.checkNotNull((Object)bulkAdder);
                            bulkAdder.add(iterator2);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                        Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                        return this.this$0.relate(minPackedValue, maxPackedValue);
                    }
                };
            }

            public final PointValues.IntersectVisitor getInverseIntersectVisitor(FixedBitSet result, long[] cost) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Intrinsics.checkNotNullParameter((Object)cost, (String)"cost");
                return new PointValues.IntersectVisitor(result, cost, this){
                    final /* synthetic */ FixedBitSet $result;
                    final /* synthetic */ long[] $cost;
                    final /* synthetic */ createWeight.1 this$0;
                    {
                        this.$result = $result;
                        this.$cost = $cost;
                        this.this$0 = $receiver;
                    }

                    public void visit(int docID) {
                        this.$result.clear(docID);
                        long[] lArray = this.$cost;
                        long l = lArray[0];
                        lArray[0] = l + -1L;
                    }

                    public void visit(DocIdSetIterator iterator2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                        this.$result.andNot(iterator2);
                        this.$cost[0] = Math.max(0L, this.$cost[0] - iterator2.cost());
                    }

                    public void visit(IntsRef ref) {
                        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                        int n = ref.getOffset() + ref.getLength();
                        for (int i = ref.getOffset(); i < n; ++i) {
                            this.$result.clear(ref.getInts()[i]);
                        }
                        this.$cost[0] = Math.max(0L, this.$cost[0] - (long)ref.getLength());
                    }

                    public void visit(int docID, byte[] packedValue) {
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (!this.this$0.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (!this.this$0.matches(packedValue)) {
                            this.visit(iterator2);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                        Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                        PointValues.Relation relation = this.this$0.relate(minPackedValue, maxPackedValue);
                        return switch (createWeight.getInverseIntersectVisitor.WhenMappings.$EnumSwitchMapping$0[relation.ordinal()]) {
                            case 1 -> PointValues.Relation.CELL_OUTSIDE_QUERY;
                            case 2 -> PointValues.Relation.CELL_INSIDE_QUERY;
                            case 3 -> relation;
                            default -> throw new NoWhenBranchMatchedException();
                        };
                    }

                    public void grow(int count) {
                        PointValues.IntersectVisitor.super.grow(count);
                    }
                };
            }

            public final boolean checkValidPointValues(PointValues values2) throws IOException {
                if (values2 == null) {
                    return false;
                }
                boolean bl = values2.getNumIndexDimensions() == this.this$0.getNumDims();
                PointRangeQuery pointRangeQuery = this.this$0;
                if (!bl) {
                    boolean $i$a$-require-PointRangeQuery$createWeight$1$checkValidPointValues$32 = false;
                    String $i$a$-require-PointRangeQuery$createWeight$1$checkValidPointValues$32 = "field=\"" + pointRangeQuery.getField() + "\" was indexed with numIndexDimensions=" + values2.getNumIndexDimensions() + " but this query has numDims=" + pointRangeQuery.getNumDims();
                    throw new IllegalArgumentException($i$a$-require-PointRangeQuery$createWeight$1$checkValidPointValues$32.toString());
                }
                bl = this.this$0.getBytesPerDim() == values2.getBytesPerDimension();
                pointRangeQuery = this.this$0;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "field=\"" + pointRangeQuery.getField() + "\" was indexed with bytesPerDim=" + values2.getBytesPerDimension() + " but this query has bytesPerDim=" + pointRangeQuery.getBytesPerDim();
                    throw new IllegalArgumentException(string.toString());
                }
                return true;
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                LeafReader reader2 = context.reader();
                PointValues valuesToCheck = reader2.getPointValues(this.this$0.getField());
                if (!this.checkValidPointValues(valuesToCheck)) {
                    return null;
                }
                PointValues pointValues = valuesToCheck;
                Intrinsics.checkNotNull((Object)pointValues);
                PointValues values2 = pointValues;
                if (values2.getDocCount() == 0) {
                    return null;
                }
                byte[] fieldPackedLower = values2.getMinPackedValue();
                byte[] fieldPackedUpper = values2.getMaxPackedValue();
                int n = this.this$0.getNumDims();
                for (int i = 0; i < n; ++i) {
                    int offset = i * this.this$0.getBytesPerDim();
                    if (this.comparator.compare(this.this$0.getLowerPoint(), offset, fieldPackedUpper, offset) <= 0 && this.comparator.compare(this.this$0.getUpperPoint(), offset, fieldPackedLower, offset) >= 0) continue;
                    return null;
                }
                boolean allDocsMatch = false;
                if (values2.getDocCount() == reader2.maxDoc()) {
                    byte[] fieldPackedLower2 = values2.getMinPackedValue();
                    byte[] fieldPackedUpper2 = values2.getMaxPackedValue();
                    allDocsMatch = true;
                    int n2 = this.this$0.getNumDims();
                    for (int i = 0; i < n2; ++i) {
                        int offset = i * this.this$0.getBytesPerDim();
                        if (this.comparator.compare(this.this$0.getLowerPoint(), offset, fieldPackedLower2, offset) <= 0 && this.comparator.compare(this.this$0.getUpperPoint(), offset, fieldPackedUpper2, offset) >= 0) continue;
                        allDocsMatch = false;
                        break;
                    }
                } else {
                    allDocsMatch = false;
                }
                if (allDocsMatch) {
                    return new MatchAllScorerSupplier(this.score(), this.$scoreMode, reader2.maxDoc());
                }
                float f = this.score();
                int n3 = reader2.maxDoc();
                return new ConstantScoreScorerSupplier(reader2, values2, this, this.$scoreMode, f, n3){
                    private final DocIdSetBuilder result;
                    private final PointValues.IntersectVisitor visitor;
                    private long cost;
                    final /* synthetic */ LeafReader $reader;
                    final /* synthetic */ PointValues $values;
                    final /* synthetic */ createWeight.1 this$0;
                    {
                        this.$reader = $reader;
                        this.$values = $values;
                        this.this$0 = $receiver;
                        super($super_call_param$1, $scoreMode, $super_call_param$2);
                        this.result = new DocIdSetBuilder($reader.maxDoc(), $values);
                        this.visitor = $receiver.getIntersectVisitor(this.result);
                        this.cost = -1L;
                    }

                    public final DocIdSetBuilder getResult() {
                        return this.result;
                    }

                    public final PointValues.IntersectVisitor getVisitor() {
                        return this.visitor;
                    }

                    public final long getCost() {
                        return this.cost;
                    }

                    public final void setCost(long l) {
                        this.cost = l;
                    }

                    public DocIdSetIterator iterator(long leadCost) throws IOException {
                        if (this.$values.getDocCount() == this.$reader.maxDoc() && (long)this.$values.getDocCount() == this.$values.size() && this.cost() > (long)(this.$reader.maxDoc() / 2)) {
                            FixedBitSet result = new FixedBitSet(this.$reader.maxDoc());
                            result.set(0, this.$reader.maxDoc());
                            long[] lArray = new long[]{this.$reader.maxDoc()};
                            long[] cost = lArray;
                            this.$values.intersect(this.this$0.getInverseIntersectVisitor(result, cost));
                            return new BitSetIterator(result, cost[0]);
                        }
                        this.$values.intersect(this.visitor);
                        return this.result.build().iterator();
                    }

                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = this.$values.estimateDocCount(this.visitor);
                            if (!(this.cost >= 0L)) {
                                String string = "Failed requirement.";
                                throw new IllegalArgumentException(string.toString());
                            }
                        }
                        return this.cost;
                    }
                };
            }

            public int count(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                LeafReader reader2 = context.reader();
                PointValues values2 = reader2.getPointValues(this.this$0.getField());
                if (!this.checkValidPointValues(values2)) {
                    return 0;
                }
                if (values2 != null && !reader2.hasDeletions()) {
                    if (this.relate(values2.getMinPackedValue(), values2.getMaxPackedValue()) == PointValues.Relation.CELL_INSIDE_QUERY) {
                        return values2.getDocCount();
                    }
                    if (this.this$0.getNumDims() == 1 && (long)values2.getDocCount() == values2.size()) {
                        return (int)this.pointCount(values2.getPointTree(), (Function2<? super byte[], ? super byte[], ? extends PointValues.Relation>)((Function2)(arg_0, arg_1) -> createWeight.1.count$lambda$2(this, arg_0, arg_1)), (Function1<? super byte[], Boolean>)((Function1)arg_0 -> createWeight.1.count$lambda$3(this, arg_0)));
                    }
                }
                return super.count(context);
            }

            public final long pointCount(PointValues.PointTree pointTree2, Function2<? super byte[], ? super byte[], ? extends PointValues.Relation> nodeComparator, Function1<? super byte[], Boolean> leafComparator) throws IOException {
                Intrinsics.checkNotNullParameter((Object)pointTree2, (String)"pointTree");
                Intrinsics.checkNotNullParameter(nodeComparator, (String)"nodeComparator");
                Intrinsics.checkNotNullParameter(leafComparator, (String)"leafComparator");
                long[] lArray = new long[]{0L};
                long[] matchingNodeCount = lArray;
                PointValues.IntersectVisitor visitor2 = new PointValues.IntersectVisitor(leafComparator, matchingNodeCount, nodeComparator){
                    final /* synthetic */ Function1<byte[], Boolean> $leafComparator;
                    final /* synthetic */ long[] $matchingNodeCount;
                    final /* synthetic */ Function2<byte[], byte[], PointValues.Relation> $nodeComparator;
                    {
                        this.$leafComparator = $leafComparator;
                        this.$matchingNodeCount = $matchingNodeCount;
                        this.$nodeComparator = $nodeComparator;
                    }

                    public void visit(int docID) {
                        throw new UnsupportedOperationException("This IntersectVisitor does not perform any actions on a docID=" + docID + " node being visited");
                    }

                    public void visit(int docID, byte[] packedValue) {
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (((Boolean)this.$leafComparator.invoke((Object)packedValue)).booleanValue()) {
                            long[] lArray = this.$matchingNodeCount;
                            long l = lArray[0];
                            lArray[0] = l + 1L;
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                        Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                        return (PointValues.Relation)((Object)this.$nodeComparator.invoke((Object)minPackedValue, (Object)maxPackedValue));
                    }

                    public void visit(DocIdSetIterator iterator2) throws IOException {
                        PointValues.IntersectVisitor.super.visit(iterator2);
                    }

                    public void visit(IntsRef ref) throws IOException {
                        PointValues.IntersectVisitor.super.visit(ref);
                    }

                    public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                        PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
                    }

                    public void grow(int count) {
                        PointValues.IntersectVisitor.super.grow(count);
                    }
                };
                this.pointCount(visitor2, pointTree2, matchingNodeCount);
                return matchingNodeCount[0];
            }

            public final void pointCount(PointValues.IntersectVisitor visitor2, PointValues.PointTree pointTree2, long[] matchingNodeCount) throws IOException {
                Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)pointTree2, (String)"pointTree");
                Intrinsics.checkNotNullParameter((Object)matchingNodeCount, (String)"matchingNodeCount");
                PointValues.Relation r = visitor2.compare(pointTree2.getMinPackedValue(), pointTree2.getMaxPackedValue());
                switch (createWeight.WhenMappings.$EnumSwitchMapping$0[r.ordinal()]) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        matchingNodeCount[0] = matchingNodeCount[0] + pointTree2.size();
                        return;
                    }
                    case 3: {
                        if (pointTree2.moveToChild()) {
                            do {
                                this.pointCount(visitor2, pointTree2, matchingNodeCount);
                            } while (pointTree2.moveToSibling());
                            pointTree2.moveToParent();
                        } else {
                            pointTree2.visitDocValues(visitor2);
                        }
                        return;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return true;
            }

            private static final PointValues.Relation count$lambda$2(createWeight.1 this$0, byte[] minPackedValue, byte[] maxPackedValue) {
                Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                return this$0.relate(minPackedValue, maxPackedValue);
            }

            private static final boolean count$lambda$3(createWeight.1 this$0, byte[] packedValue) {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                return this$0.matches(packedValue);
            }
        };
    }

    @Override
    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.getLowerPoint());
        hash = 31 * hash + Arrays.hashCode(this.getUpperPoint());
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + Objects.INSTANCE.hashCode(this.bytesPerDim);
        return hash;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this.sameClassAs(o) && this.equalsTo((PointRangeQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)o));
    }

    private final boolean equalsTo(PointRangeQuery other) {
        return Intrinsics.areEqual((Object)this.field, (Object)other.field) && this.numDims == other.numDims && this.bytesPerDim == other.bytesPerDim && Arrays.equals(this.getLowerPoint(), other.getLowerPoint()) && Arrays.equals(this.getUpperPoint(), other.getUpperPoint());
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder sb = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.field, (Object)field)) {
            sb.append(this.field);
            sb.append(':');
        }
        int n = this.numDims;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            int startOffset = this.bytesPerDim * i;
            sb.append('[');
            sb.append(this.toString(i, ArrayUtil.Companion.copyOfSubArray(this.getLowerPoint(), startOffset, startOffset + this.bytesPerDim)));
            sb.append(" TO ");
            sb.append(this.toString(i, ArrayUtil.Companion.copyOfSubArray(this.getUpperPoint(), startOffset, startOffset + this.bytesPerDim)));
            sb.append(']');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    protected abstract String toString(int var1, @NotNull byte[] var2);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/search/PointRangeQuery$Companion;", "", "<init>", "()V", "checkArgs", "", "field", "", "lowerPoint", "upperPoint", "core"})
    @SourceDebugExtension(value={"SMAP\nPointRangeQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointRangeQuery.kt\norg/gnit/lucenekmp/search/PointRangeQuery$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,542:1\n1#2:543\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkArgs(@NotNull String field, @NotNull Object lowerPoint, @NotNull Object upperPoint) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)lowerPoint, (String)"lowerPoint");
            Intrinsics.checkNotNullParameter((Object)upperPoint, (String)"upperPoint");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

