/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.IndexReaderContext;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.BooleanClause;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BoostAttribute;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.TermCollectingRewrite;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefHash;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u0011*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH$J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/search/ScoringRewrite;", "B", "Lorg/gnit/lucenekmp/search/TermCollectingRewrite;", "<init>", "()V", "checkMaxClauseCount", "", "count", "", "rewrite", "Lorg/gnit/lucenekmp/search/Query;", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "query", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "ParallelArraysTermCollector", "TermFreqBoostByteStart", "Companion", "core"})
public abstract class ScoringRewrite<B>
extends TermCollectingRewrite<B> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ScoringRewrite<BooleanQuery.Builder> SCORING_BOOLEAN_REWRITE = new ScoringRewrite<BooleanQuery.Builder>(){

        protected BooleanQuery.Builder getTopLevelBuilder() {
            return new BooleanQuery.Builder();
        }

        protected Query build(BooleanQuery.Builder builder) {
            BooleanQuery.Builder builder2 = builder;
            Intrinsics.checkNotNull((Object)builder2);
            return builder2.build();
        }

        protected void addClause(BooleanQuery.Builder topLevel, Term term, int docCount, float boost, TermStates states) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            TermStates termStates = states;
            Intrinsics.checkNotNull((Object)termStates);
            TermQuery tq = new TermQuery(term, termStates);
            BooleanQuery.Builder builder = topLevel;
            Intrinsics.checkNotNull((Object)builder);
            builder.add(new BoostQuery(tq, boost), BooleanClause.Occur.SHOULD);
        }

        protected void checkMaxClauseCount(int count) {
            if (count > IndexSearcher.Companion.getMaxClauseCount()) {
                throw new IndexSearcher.TooManyClauses(null, 1, null);
            }
        }
    };
    @NotNull
    private static final MultiTermQuery.RewriteMethod CONSTANT_SCORE_BOOLEAN_REWRITE = new MultiTermQuery.RewriteMethod(){

        public Query rewrite(IndexSearcher indexSearcher, MultiTermQuery query) throws IOException {
            Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Query bq = ScoringRewrite.Companion.getSCORING_BOOLEAN_REWRITE().rewrite(indexSearcher, query);
            return new ConstantScoreQuery(bq);
        }
    };

    protected abstract void checkMaxClauseCount(int var1) throws IOException;

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher, @NotNull MultiTermQuery query) throws IOException {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        IndexReader reader2 = indexSearcher.getIndexReader();
        Object builder = this.getTopLevelBuilder();
        ParallelArraysTermCollector col = new ParallelArraysTermCollector();
        this.collectTerms(reader2, query, col);
        int size2 = col.getTerms().size();
        if (size2 > 0) {
            int[] sort2 = col.getTerms().sort();
            float[] fArray = col.getArray().getBoost();
            Intrinsics.checkNotNull((Object)fArray);
            float[] boost = fArray;
            TermStates[] termStatesArray = col.getArray().getTermState();
            Intrinsics.checkNotNull((Object)termStatesArray);
            TermStates[] termStates = termStatesArray;
            for (int i = 0; i < size2; ++i) {
                int pos = sort2[i];
                Term term = new Term(query.getField(), col.getTerms().get(pos, new BytesRef()));
                int n = reader2.docFreq(term);
                TermStates termStates2 = termStates[pos];
                Intrinsics.checkNotNull((Object)termStates2);
                if (!(n == termStates2.docFreq())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                TermStates termStates3 = termStates[pos];
                Intrinsics.checkNotNull((Object)termStates3);
                this.addClause(builder, term, termStates3.docFreq(), boost[pos], termStates[pos]);
            }
        }
        return this.build(builder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/search/ScoringRewrite$Companion;", "", "<init>", "()V", "SCORING_BOOLEAN_REWRITE", "Lorg/gnit/lucenekmp/search/ScoringRewrite;", "Lorg/gnit/lucenekmp/search/BooleanQuery$Builder;", "getSCORING_BOOLEAN_REWRITE", "()Lorg/gnit/lucenekmp/search/ScoringRewrite;", "CONSTANT_SCORE_BOOLEAN_REWRITE", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "getCONSTANT_SCORE_BOOLEAN_REWRITE", "()Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScoringRewrite<BooleanQuery.Builder> getSCORING_BOOLEAN_REWRITE() {
            return SCORING_BOOLEAN_REWRITE;
        }

        @NotNull
        public final MultiTermQuery.RewriteMethod getCONSTANT_SCORE_BOOLEAN_REWRITE() {
            return CONSTANT_SCORE_BOOLEAN_REWRITE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/ScoringRewrite$ParallelArraysTermCollector;", "Lorg/gnit/lucenekmp/search/TermCollectingRewrite$TermCollector;", "<init>", "(Lorg/gnit/lucenekmp/search/ScoringRewrite;)V", "array", "Lorg/gnit/lucenekmp/search/ScoringRewrite$TermFreqBoostByteStart;", "getArray", "()Lorg/gnit/lucenekmp/search/ScoringRewrite$TermFreqBoostByteStart;", "terms", "Lorg/gnit/lucenekmp/util/BytesRefHash;", "getTerms", "()Lorg/gnit/lucenekmp/util/BytesRefHash;", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "getTermsEnum", "()Lorg/gnit/lucenekmp/index/TermsEnum;", "setTermsEnum", "(Lorg/gnit/lucenekmp/index/TermsEnum;)V", "boostAtt", "Lorg/gnit/lucenekmp/search/BoostAttribute;", "setNextEnum", "", "collect", "", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    public final class ParallelArraysTermCollector
    extends TermCollectingRewrite.TermCollector {
        @NotNull
        private final TermFreqBoostByteStart array = new TermFreqBoostByteStart(16);
        @NotNull
        private final BytesRefHash terms = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectAllocator()), 16, this.array);
        @Nullable
        private TermsEnum termsEnum;
        @Nullable
        private BoostAttribute boostAtt;

        @NotNull
        public final TermFreqBoostByteStart getArray() {
            return this.array;
        }

        @NotNull
        public final BytesRefHash getTerms() {
            return this.terms;
        }

        @Nullable
        public final TermsEnum getTermsEnum() {
            return this.termsEnum;
        }

        public final void setTermsEnum(@Nullable TermsEnum termsEnum) {
            this.termsEnum = termsEnum;
        }

        @Override
        public void setNextEnum(@NotNull TermsEnum termsEnum) {
            Intrinsics.checkNotNullParameter((Object)termsEnum, (String)"termsEnum");
            this.termsEnum = termsEnum;
            this.boostAtt = (BoostAttribute)termsEnum.attributes().addAttribute(Reflection.getOrCreateKotlinClass(BoostAttribute.class));
        }

        @Override
        public boolean collect(@NotNull BytesRef bytes) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int e = this.terms.add(bytes);
            TermsEnum termsEnum = this.termsEnum;
            Intrinsics.checkNotNull((Object)termsEnum);
            TermState termState2 = termsEnum.termState();
            if (termState2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            TermState state2 = termState2;
            if (e < 0) {
                int pos = -e - 1;
                TermStates[] termStatesArray = this.array.getTermState();
                Intrinsics.checkNotNull((Object)termStatesArray);
                TermStates termStates = termStatesArray[pos];
                Intrinsics.checkNotNull((Object)termStates);
                LeafReaderContext leafReaderContext = this.getReaderContext();
                Intrinsics.checkNotNull((Object)leafReaderContext);
                int n = leafReaderContext.getOrd();
                TermsEnum termsEnum2 = this.termsEnum;
                Intrinsics.checkNotNull((Object)termsEnum2);
                int n2 = termsEnum2.docFreq();
                TermsEnum termsEnum3 = this.termsEnum;
                Intrinsics.checkNotNull((Object)termsEnum3);
                termStates.register(state2, n, n2, termsEnum3.totalTermFreq());
                float[] fArray = this.array.getBoost();
                Intrinsics.checkNotNull((Object)fArray);
                float f = fArray[pos];
                BoostAttribute boostAttribute = this.boostAtt;
                Intrinsics.checkNotNull((Object)boostAttribute);
                if (!(f == boostAttribute.getBoost())) {
                    boolean bl = false;
                    String string = "boost should be equal in all segment TermsEnums";
                    throw new IllegalArgumentException(string.toString());
                }
            } else {
                float[] fArray = this.array.getBoost();
                Intrinsics.checkNotNull((Object)fArray);
                BoostAttribute boostAttribute = this.boostAtt;
                Intrinsics.checkNotNull((Object)boostAttribute);
                fArray[e] = boostAttribute.getBoost();
                TermStates[] termStatesArray = this.array.getTermState();
                Intrinsics.checkNotNull((Object)termStatesArray);
                IndexReaderContext indexReaderContext = this.getTopReaderContext();
                Intrinsics.checkNotNull((Object)indexReaderContext);
                LeafReaderContext leafReaderContext = this.getReaderContext();
                Intrinsics.checkNotNull((Object)leafReaderContext);
                int n = leafReaderContext.getOrd();
                TermsEnum termsEnum4 = this.termsEnum;
                Intrinsics.checkNotNull((Object)termsEnum4);
                int n3 = termsEnum4.docFreq();
                TermsEnum termsEnum5 = this.termsEnum;
                Intrinsics.checkNotNull((Object)termsEnum5);
                termStatesArray[e] = new TermStates(indexReaderContext, state2, n, n3, termsEnum5.totalTermFreq());
                ScoringRewrite.this.checkMaxClauseCount(this.terms.size());
            }
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/search/ScoringRewrite$TermFreqBoostByteStart;", "Lorg/gnit/lucenekmp/util/BytesRefHash$DirectBytesStartArray;", "initSize", "", "<init>", "(I)V", "boost", "", "getBoost", "()[F", "setBoost", "([F)V", "termState", "", "Lorg/gnit/lucenekmp/index/TermStates;", "getTermState", "()[Lorg/gnit/lucenekmp/index/TermStates;", "setTermState", "([Lorg/gnit/lucenekmp/index/TermStates;)V", "[Lorg/gnit/lucenekmp/index/TermStates;", "init", "", "grow", "clear", "core"})
    public static final class TermFreqBoostByteStart
    extends BytesRefHash.DirectBytesStartArray {
        @Nullable
        private float[] boost;
        @Nullable
        private TermStates[] termState;

        public TermFreqBoostByteStart(int initSize) {
            super(initSize, null, 2, null);
        }

        @Nullable
        public final float[] getBoost() {
            return this.boost;
        }

        public final void setBoost(@Nullable float[] fArray) {
            this.boost = fArray;
        }

        @Nullable
        public final TermStates[] getTermState() {
            return this.termState;
        }

        public final void setTermState(@Nullable TermStates[] termStatesArray) {
            this.termState = termStatesArray;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public int[] init() {
            ord = super.init();
            this.boost = new float[ArrayUtil.Companion.oversize(ord.length, 4)];
            this.termState = new TermStates[ArrayUtil.Companion.oversize(ord.length, 4)];
            Intrinsics.checkNotNull((Object)this.termState);
            if (this.termState.length < ord.length) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)this.boost);
            if (this.boost.length >= ord.length) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) {
                var2_2 = "Failed requirement.";
                throw new IllegalArgumentException(var2_2.toString());
            }
            return ord;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public int[] grow() {
            ord = super.grow();
            Intrinsics.checkNotNull((Object)this.boost);
            this.boost = ArrayUtil.Companion.grow(this.boost, ord.length);
            Intrinsics.checkNotNull((Object)this.termState);
            if (this.termState.length < ord.length) {
                tmpTermState = new TermStates[ArrayUtil.Companion.oversize(ord.length, 4)];
                Intrinsics.checkNotNull((Object)this.termState);
                Intrinsics.checkNotNull((Object)this.termState);
                ArraysKt.copyInto((Object[])this.termState, (Object[])tmpTermState, (int)0, (int)0, (int)this.termState.length);
                this.termState = tmpTermState;
            }
            Intrinsics.checkNotNull((Object)this.termState);
            if (this.termState.length < ord.length) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)this.boost);
            if (this.boost.length >= ord.length) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) {
                var3_3 = "Failed requirement.";
                throw new IllegalArgumentException(var3_3.toString());
            }
            return ord;
        }

        @Override
        @Nullable
        public int[] clear() {
            this.boost = null;
            this.termState = null;
            return super.clear();
        }
    }
}

