/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.Impact;
import org.gnit.lucenekmp.index.Impacts;
import org.gnit.lucenekmp.index.ImpactsSource;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.internal.hppc.IntHashSet;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.search.ConjunctionUtils;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.ImpactsDISI;
import org.gnit.lucenekmp.search.MaxScoreCache;
import org.gnit.lucenekmp.search.PhraseMatcher;
import org.gnit.lucenekmp.search.PhrasePositions;
import org.gnit.lucenekmp.search.PhraseQuery;
import org.gnit.lucenekmp.search.PhraseQueue;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010(\u001a\u00020\fH\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\fH\u0016J\b\u0010,\u001a\u00020\u000eH\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0012H\u0002J\b\u0010/\u001a\u00020\u0006H\u0016J\b\u00100\u001a\u00020\u0006H\u0016J\b\u00101\u001a\u00020\u0006H\u0016J\b\u00102\u001a\u00020\u0006H\u0016J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0012H\u0002J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0012H\u0002J\u0018\u00105\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u0012H\u0002J\u0010\u00107\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0012H\u0002J\b\u00108\u001a\u00020\u000eH\u0002J\b\u00109\u001a\u00020*H\u0002J\b\u0010:\u001a\u00020\u000eH\u0002J\b\u0010;\u001a\u00020*H\u0002J\b\u0010<\u001a\u00020*H\u0002J\b\u0010=\u001a\u00020\u000eH\u0002J\b\u0010>\u001a\u00020\u000eH\u0002J@\u0010?\u001a\u00020*26\u0010@\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00120Aj\b\u0012\u0004\u0012\u00020\u0012`B0Aj\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00120Aj\b\u0012\u0004\u0012\u00020\u0012`B`BH\u0002J\\\u0010C\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00120Aj\b\u0012\u0004\u0012\u00020\u0012`B0Aj\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00120Aj\b\u0012\u0004\u0012\u00020\u0012`B`B2\"\u0010D\u001a\u001e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u00060Ej\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u0006`GH\u0002J\u0010\u0010H\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0012H\u0002J$\u0010I\u001a\u001e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u00060Ej\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u0006`GH\u0002J7\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\"\u0010D\u001a\u001e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u00060Ej\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u0006`GH\u0002\u00a2\u0006\u0002\u0010KJO\u0010L\u001a\u0012\u0012\u0004\u0012\u00020M0Aj\b\u0012\u0004\u0012\u00020M`B2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\"\u0010O\u001a\u001e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u00060Ej\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u0006`GH\u0002\u00a2\u0006\u0002\u0010PJ \u0010Q\u001a\u00020*2\u0016\u0010R\u001a\u0012\u0012\u0004\u0012\u00020M0Aj\b\u0012\u0004\u0012\u00020M`BH\u0002J`\u0010S\u001a\u001e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u00060Tj\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u0006`U2\"\u0010O\u001a\u001e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u00060Ej\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\u0006`G2\u0016\u0010R\u001a\u0012\u0012\u0004\u0012\u00020M0Aj\b\u0012\u0004\u0012\u00020M`BH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00030\u0003X\u0082.\u00a2\u0006\u0004\n\u0002\u0010$R\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010&\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lorg/gnit/lucenekmp/search/SloppyPhraseMatcher;", "Lorg/gnit/lucenekmp/search/PhraseMatcher;", "postings", "", "Lorg/gnit/lucenekmp/search/PhraseQuery$PostingsAndFreq;", "slop", "", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "scorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "matchCost", "", "captureLeadMatch", "", "<init>", "([Lorg/gnit/lucenekmp/search/PhraseQuery$PostingsAndFreq;ILorg/gnit/lucenekmp/search/ScoreMode;Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;FZ)V", "phrasePositions", "Lorg/gnit/lucenekmp/search/PhrasePositions;", "[Lorg/gnit/lucenekmp/search/PhrasePositions;", "numPostings", "pq", "Lorg/gnit/lucenekmp/search/PhraseQueue;", "approximation", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "impactsApproximation", "Lorg/gnit/lucenekmp/search/ImpactsDISI;", "end", "leadPosition", "leadOffset", "leadEndOffset", "leadOrd", "hasRpts", "checkedRpts", "hasMultiTermRpts", "rptGroups", "[[Lorg/gnit/lucenekmp/search/PhrasePositions;", "rptStack", "positioned", "matchLength", "maxFreq", "reset", "", "sloppyWeight", "nextMatch", "captureLead", "pp", "startPosition", "endPosition", "startOffset", "endOffset", "advancePP", "advanceRpts", "lesser", "pp2", "collide", "initPhrasePositions", "initSimple", "initComplex", "placeFirstPositions", "fillQueue", "advanceRepeatGroups", "initFirstTime", "sortRptGroups", "rgs", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "gatherRptGroups", "rptTerms", "Ljava/util/LinkedHashMap;", "Lorg/gnit/lucenekmp/index/Term;", "Lkotlin/collections/LinkedHashMap;", "tpPos", "repeatingTerms", "repeatingPPs", "(Ljava/util/LinkedHashMap;)[Lorg/gnit/lucenekmp/search/PhrasePositions;", "ppTermsBitSets", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "rpp", "tord", "([Lorg/gnit/lucenekmp/search/PhrasePositions;Ljava/util/LinkedHashMap;)Ljava/util/ArrayList;", "unionTermGroups", "bb", "termGroups", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "core"})
@SourceDebugExtension(value={"SMAP\nSloppyPhraseMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SloppyPhraseMatcher.kt\norg/gnit/lucenekmp/search/SloppyPhraseMatcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 6 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,679:1\n11228#2:680\n11563#2,3:681\n1#3:684\n37#4:685\n36#4,3:686\n37#4:698\n36#4,3:699\n37#4:702\n36#4,3:703\n3#5,8:689\n10#6:697\n*S KotlinDebug\n*F\n+ 1 SloppyPhraseMatcher.kt\norg/gnit/lucenekmp/search/SloppyPhraseMatcher\n*L\n53#1:680\n53#1:681,3\n504#1:685\n504#1:686,3\n608#1:698\n608#1:699,3\n663#1:702\n663#1:703,3\n563#1:689,8\n563#1:697\n*E\n"})
public final class SloppyPhraseMatcher
extends PhraseMatcher {
    private final int slop;
    private final boolean captureLeadMatch;
    @NotNull
    private final PhrasePositions[] phrasePositions;
    private final int numPostings;
    @NotNull
    private final PhraseQueue pq;
    @NotNull
    private final DocIdSetIterator approximation;
    @NotNull
    private final ImpactsDISI impactsApproximation;
    private int end;
    private int leadPosition;
    private int leadOffset;
    private int leadEndOffset;
    private int leadOrd;
    private boolean hasRpts;
    private boolean checkedRpts;
    private boolean hasMultiTermRpts;
    private PhrasePositions[][] rptGroups;
    private PhrasePositions[] rptStack;
    private boolean positioned;
    private int matchLength;

    /*
     * WARNING - void declaration
     */
    public SloppyPhraseMatcher(@NotNull PhraseQuery.PostingsAndFreq[] postings, int slop, @NotNull ScoreMode scoreMode, @NotNull Similarity.SimScorer scorer2, float matchCost, boolean captureLeadMatch) {
        Collection<PostingsEnum> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)postings, (String)"postings");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        super(matchCost);
        this.slop = slop;
        this.captureLeadMatch = captureLeadMatch;
        int n = 0;
        int n2 = postings.length;
        PhrasePositions[] phrasePositionsArray = new PhrasePositions[n2];
        SloppyPhraseMatcher sloppyPhraseMatcher = this;
        while (n < n2) {
            int n3 = n++;
            phrasePositionsArray[n3] = new PhrasePositions(postings[n3].getPostings(), postings[n3].getPosition(), n3, postings[n3].getTerms());
        }
        sloppyPhraseMatcher.phrasePositions = phrasePositionsArray;
        this.numPostings = postings.length;
        this.pq = new PhraseQueue(postings.length);
        PhraseQuery.PostingsAndFreq[] postingsAndFreqArray = postings;
        ConjunctionUtils conjunctionUtils = ConjunctionUtils.INSTANCE;
        sloppyPhraseMatcher = this;
        boolean $i$f$map = false;
        phrasePositionsArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n4 = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n4; ++i) {
            void p;
            void item$iv$iv;
            void var15_19 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p.getPostings());
        }
        collection = (List)destination$iv$iv;
        sloppyPhraseMatcher.approximation = conjunctionUtils.intersectIterators(CollectionsKt.toMutableList((Collection)collection));
        ImpactsSource impactsSource2 = new ImpactsSource(){

            public Impacts getImpacts() {
                return new Impacts(){

                    public int numLevels() {
                        return 1;
                    }

                    public List<Impact> getImpacts(int level) {
                        Object[] objectArray = new Impact[]{new Impact(Integer.MAX_VALUE, 1L)};
                        return CollectionsKt.mutableListOf((Object[])objectArray);
                    }

                    public int getDocIdUpTo(int level) {
                        return Integer.MAX_VALUE;
                    }
                };
            }

            public void advanceShallow(int target) throws IOException {
            }
        };
        this.impactsApproximation = new ImpactsDISI(this.approximation, new MaxScoreCache(impactsSource2, scorer2));
    }

    @Override
    @NotNull
    public DocIdSetIterator approximation() {
        return this.approximation;
    }

    @Override
    @NotNull
    public ImpactsDISI impactsApproximation() {
        return this.impactsApproximation;
    }

    @Override
    public float maxFreq() throws IOException {
        float maxFreq = 0.0f;
        for (PhrasePositions phrasePosition : this.phrasePositions) {
            maxFreq += (float)phrasePosition.getPostings().freq();
        }
        return maxFreq;
    }

    @Override
    public void reset() throws IOException {
        this.positioned = this.initPhrasePositions();
        this.matchLength = Integer.MAX_VALUE;
        this.leadPosition = Integer.MAX_VALUE;
    }

    @Override
    public float sloppyWeight() {
        return 1.0f / (1.0f + (float)this.matchLength);
    }

    @Override
    public boolean nextMatch() throws IOException {
        if (!this.positioned) {
            return false;
        }
        Object t = this.pq.pop();
        if (t == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        PhrasePositions pp = (PhrasePositions)t;
        this.captureLead(pp);
        this.matchLength = this.end - pp.getPosition();
        int next = ((PhrasePositions)this.pq.top()).getPosition();
        while (this.advancePP(pp) && (!this.hasRpts || this.advanceRpts(pp))) {
            if (pp.getPosition() > next) {
                this.pq.add(pp);
                if (this.matchLength <= this.slop) {
                    return true;
                }
                Object t2 = this.pq.pop();
                Intrinsics.checkNotNull(t2);
                pp = (PhrasePositions)t2;
                next = ((PhrasePositions)this.pq.top()).getPosition();
                if (pp == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                this.matchLength = this.end - pp.getPosition();
            } else {
                int matchLength2 = this.end - pp.getPosition();
                if (matchLength2 < this.matchLength) {
                    this.matchLength = matchLength2;
                }
            }
            this.captureLead(pp);
        }
        this.positioned = false;
        return this.matchLength <= this.slop;
    }

    private final void captureLead(PhrasePositions pp) throws IOException {
        if (!this.captureLeadMatch) {
            return;
        }
        this.leadOrd = pp.getOrd();
        this.leadPosition = pp.getPosition() + pp.getOffset();
        this.leadOffset = pp.getPostings().startOffset();
        this.leadEndOffset = pp.getPostings().endOffset();
    }

    @Override
    public int startPosition() {
        int leadPosition = this.leadPosition;
        for (PhrasePositions pp : this.phrasePositions) {
            leadPosition = Math.min(leadPosition, pp.getPosition() + pp.getOffset());
        }
        return leadPosition;
    }

    @Override
    public int endPosition() {
        int endPosition = this.leadPosition;
        for (PhrasePositions pp : this.phrasePositions) {
            if (pp.getOrd() == this.leadOrd) continue;
            endPosition = Math.max(endPosition, pp.getPosition() + pp.getOffset());
        }
        return endPosition;
    }

    @Override
    public int startOffset() throws IOException {
        int leadOffset = this.leadOffset;
        for (PhrasePositions pp : this.phrasePositions) {
            leadOffset = Math.min(leadOffset, pp.getPostings().startOffset());
        }
        return leadOffset;
    }

    @Override
    public int endOffset() throws IOException {
        int endOffset = this.leadEndOffset;
        for (PhrasePositions pp : this.phrasePositions) {
            if (pp.getOrd() == this.leadOrd) continue;
            endOffset = Math.max(endOffset, pp.getPostings().endOffset());
        }
        return endOffset;
    }

    private final boolean advancePP(PhrasePositions pp) throws IOException {
        if (!pp.nextPosition()) {
            return false;
        }
        if (pp.getPosition() > this.end) {
            this.end = pp.getPosition();
        }
        return true;
    }

    private final boolean advanceRpts(PhrasePositions pp) throws IOException {
        PhrasePositions pp2 = pp;
        if (pp2.getRptGroup() < 0) {
            return true;
        }
        PhrasePositions[][] phrasePositionsArray = this.rptGroups;
        if (this.rptGroups == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rptGroups");
            phrasePositionsArray = null;
        }
        PhrasePositions[] rg = phrasePositionsArray[pp2.getRptGroup()];
        FixedBitSet bits = new FixedBitSet(rg.length);
        int k0 = pp2.getRptInd();
        int k = 0;
        while (true) {
            int n;
            int it = n = this.collide(pp2);
            boolean bl = false;
            k = it;
            if (n < 0) break;
            if (!this.advancePP(pp2 = this.lesser(pp2, rg[k]))) {
                return false;
            }
            if (k == k0) continue;
            bits = FixedBitSet.Companion.ensureCapacity(bits, k);
            bits.set(k);
        }
        int n = 0;
        int numBits = bits.length();
        while (bits.cardinality() > 0) {
            Object t = this.pq.pop();
            Intrinsics.checkNotNull(t);
            PhrasePositions pp22 = (PhrasePositions)t;
            PhrasePositions[] phrasePositionsArray2 = this.rptStack;
            if (this.rptStack == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rptStack");
                phrasePositionsArray2 = null;
            }
            phrasePositionsArray2[n++] = pp22;
            if (pp22.getRptGroup() < 0 || pp22.getRptInd() >= numBits || !bits.get(pp22.getRptInd())) continue;
            bits.clear(pp22.getRptInd());
        }
        for (int i = n - 1; -1 < i; --i) {
            PhrasePositions[] phrasePositionsArray3 = this.rptStack;
            if (this.rptStack == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rptStack");
                phrasePositionsArray3 = null;
            }
            this.pq.add(phrasePositionsArray3[i]);
        }
        return true;
    }

    private final PhrasePositions lesser(PhrasePositions pp, PhrasePositions pp2) {
        if (pp.getPosition() < pp2.getPosition() || pp.getPosition() == pp2.getPosition() && pp.getOffset() < pp2.getOffset()) {
            return pp;
        }
        return pp2;
    }

    private final int collide(PhrasePositions pp) {
        int tpPos = this.tpPos(pp);
        PhrasePositions[][] phrasePositionsArray = this.rptGroups;
        if (this.rptGroups == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rptGroups");
            phrasePositionsArray = null;
        }
        for (PhrasePositions pp2 : phrasePositionsArray[pp.getRptGroup()]) {
            if (Intrinsics.areEqual((Object)pp2, (Object)pp) || this.tpPos(pp2) != tpPos) continue;
            return pp2.getRptInd();
        }
        return -1;
    }

    private final boolean initPhrasePositions() throws IOException {
        this.end = Integer.MIN_VALUE;
        if (!this.checkedRpts) {
            return this.initFirstTime();
        }
        if (!this.hasRpts) {
            this.initSimple();
            return true;
        }
        return this.initComplex();
    }

    private final void initSimple() throws IOException {
        this.pq.clear();
        for (PhrasePositions pp : this.phrasePositions) {
            pp.firstPosition();
            if (pp.getPosition() > this.end) {
                this.end = pp.getPosition();
            }
            this.pq.add(pp);
        }
    }

    private final boolean initComplex() throws IOException {
        this.placeFirstPositions();
        if (!this.advanceRepeatGroups()) {
            return false;
        }
        this.fillQueue();
        return true;
    }

    private final void placeFirstPositions() throws IOException {
        for (PhrasePositions pp : this.phrasePositions) {
            pp.firstPosition();
        }
    }

    private final void fillQueue() {
        this.pq.clear();
        for (PhrasePositions pp : this.phrasePositions) {
            if (pp.getPosition() > this.end) {
                this.end = pp.getPosition();
            }
            this.pq.add(pp);
        }
    }

    private final boolean advanceRepeatGroups() throws IOException {
        PhrasePositions[][] phrasePositionsArray = this.rptGroups;
        if (this.rptGroups == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rptGroups");
            phrasePositionsArray = null;
        }
        PhrasePositions[][] phrasePositionsArray2 = phrasePositionsArray;
        int n = ((Object[])phrasePositionsArray2).length;
        for (int i = 0; i < n; ++i) {
            PhrasePositions[] rg = phrasePositionsArray2[i];
            if (this.hasMultiTermRpts) {
                int incr = 0;
                block1: for (int i2 = 0; i2 < rg.length; i2 += incr) {
                    PhrasePositions pp2;
                    incr = 1;
                    PhrasePositions pp = rg[i2];
                    int k = 0;
                    do {
                        int n2;
                        int it = n2 = this.collide(pp);
                        boolean bl = false;
                        k = it;
                        if (n2 < 0) continue block1;
                        pp2 = this.lesser(pp, rg[k]);
                        if (this.advancePP(pp2)) continue;
                        return false;
                    } while (pp2.getRptInd() >= i2);
                    incr = 0;
                }
                continue;
            }
            int n3 = rg.length;
            for (int j = 1; j < n3; ++j) {
                for (int k = 0; k < j; ++k) {
                    if (rg[j].nextPosition()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private final boolean initFirstTime() throws IOException {
        this.checkedRpts = true;
        this.placeFirstPositions();
        LinkedHashMap<Term, Integer> rptTerms = this.repeatingTerms();
        boolean bl = this.hasRpts = !rptTerms.isEmpty();
        if (this.hasRpts) {
            this.rptStack = new PhrasePositions[this.numPostings];
            ArrayList<ArrayList<PhrasePositions>> rgs = this.gatherRptGroups(rptTerms);
            this.sortRptGroups(rgs);
            if (!this.advanceRepeatGroups()) {
                return false;
            }
        }
        this.fillQueue();
        return true;
    }

    private final void sortRptGroups(ArrayList<ArrayList<PhrasePositions>> rgs) {
        this.rptGroups = new PhrasePositions[rgs.size()][];
        Comparator cmprtr = new Comparator(){

            public final int compare(T a, T b) {
                PhrasePositions it = (PhrasePositions)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (PhrasePositions)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
            }
        };
        int i = 0;
        PhrasePositions[][] phrasePositionsArray = this.rptGroups;
        if (this.rptGroups == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rptGroups");
            phrasePositionsArray = null;
        }
        int n = ((Object[])phrasePositionsArray).length;
        while (i < n) {
            ArrayList<PhrasePositions> arrayList = rgs.get(i);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"get(...)");
            Collection $this$toTypedArray$iv = arrayList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            PhrasePositions[] rg = thisCollection$iv.toArray(new PhrasePositions[0]);
            Arrays.INSTANCE.sort(rg, cmprtr);
            PhrasePositions[][] phrasePositionsArray2 = this.rptGroups;
            if (this.rptGroups == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rptGroups");
                phrasePositionsArray2 = null;
            }
            phrasePositionsArray2[i] = rg;
            int n2 = rg.length;
            for (int j = 0; j < n2; ++j) {
                rg[j].setRptInd(j);
            }
            ++i;
        }
    }

    private final ArrayList<ArrayList<PhrasePositions>> gatherRptGroups(LinkedHashMap<Term, Integer> rptTerms) throws IOException {
        PhrasePositions[] rpp = this.repeatingPPs(rptTerms);
        ArrayList<ArrayList<PhrasePositions>> res = new ArrayList<ArrayList<PhrasePositions>>();
        if (!this.hasMultiTermRpts) {
            int n = rpp.length;
            for (int i = 0; i < n; ++i) {
                PhrasePositions pp = rpp[i];
                if (pp.getRptGroup() >= 0) continue;
                int tpPos = this.tpPos(pp);
                int n2 = rpp.length;
                for (int j = i + 1; j < n2; ++j) {
                    PhrasePositions pp2 = rpp[j];
                    if (pp2.getRptGroup() >= 0 || pp2.getOffset() == pp.getOffset() || this.tpPos(pp2) != tpPos) continue;
                    int g = pp.getRptGroup();
                    if (g < 0) {
                        g = res.size();
                        pp.setRptGroup(g);
                        ArrayList<PhrasePositions> rl = new ArrayList<PhrasePositions>(2);
                        rl.add(pp);
                        res.add(rl);
                    }
                    pp2.setRptGroup(g);
                    res.get(g).add(pp2);
                }
            }
        } else {
            ArrayList tmp = new ArrayList();
            ArrayList<FixedBitSet> bb = this.ppTermsBitSets(rpp, rptTerms);
            this.unionTermGroups(bb);
            HashMap<Term, Integer> tg = this.termGroups(rptTerms, bb);
            Collection<Integer> collection = tg.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            int numDistinctGroupIds = new IntHashSet(collection).size();
            for (int i = 0; i < numDistinctGroupIds; ++i) {
                tmp.add(new HashSet());
            }
            for (PhrasePositions pp : rpp) {
                Term[] termArray;
                Intrinsics.checkNotNull((Object)pp.getTerms());
                for (Term t : termArray) {
                    if (!rptTerms.containsKey(t)) continue;
                    Integer n = tg.get(t);
                    Intrinsics.checkNotNull((Object)n);
                    int g = ((Number)n).intValue();
                    ((HashSet)tmp.get(g)).add(pp);
                    boolean condition$iv = pp.getRptGroup() == -1 || pp.getRptGroup() == g;
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    pp.setRptGroup(g);
                }
            }
            Iterator iterator2 = tmp.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                HashSet hs = (HashSet)e;
                res.add(new ArrayList(hs));
            }
        }
        return res;
    }

    private final int tpPos(PhrasePositions pp) {
        return pp.getPosition() + pp.getOffset();
    }

    private final LinkedHashMap<Term, Integer> repeatingTerms() {
        LinkedHashMap<Term, Integer> tord = new LinkedHashMap<Term, Integer>();
        HashMap tcnt = new HashMap();
        for (PhrasePositions pp : this.phrasePositions) {
            Term[] termArray;
            Intrinsics.checkNotNull((Object)pp.getTerms());
            for (Term t : termArray) {
                Integer n = (Integer)tcnt.get(t);
                int cnt = (n != null ? n : 0) + 1;
                ((Map)tcnt).put(t, cnt);
                if (cnt != 2) continue;
                tord.put(t, tord.size());
            }
        }
        return tord;
    }

    private final PhrasePositions[] repeatingPPs(LinkedHashMap<Term, Integer> rptTerms) {
        ArrayList<PhrasePositions> rp = new ArrayList<PhrasePositions>();
        block0: for (PhrasePositions pp : this.phrasePositions) {
            Term[] termArray;
            Intrinsics.checkNotNull((Object)pp.getTerms());
            for (Term t : termArray) {
                if (!rptTerms.containsKey(t)) continue;
                rp.add(pp);
                this.hasMultiTermRpts |= pp.getTerms().length > 1;
                continue block0;
            }
        }
        Collection $this$toTypedArray$iv = rp;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PhrasePositions[0]);
    }

    private final ArrayList<FixedBitSet> ppTermsBitSets(PhrasePositions[] rpp, LinkedHashMap<Term, Integer> tord) {
        ArrayList<FixedBitSet> bb = new ArrayList<FixedBitSet>(rpp.length);
        for (PhrasePositions pp : rpp) {
            Term[] termArray;
            FixedBitSet b = new FixedBitSet(tord.size());
            int ord = 0;
            Intrinsics.checkNotNull((Object)pp.getTerms());
            for (Term t : termArray) {
                Integer n;
                Integer it = n = tord.get(t);
                boolean bl = false;
                Integer n2 = it;
                Intrinsics.checkNotNull((Object)n2);
                ord = n2;
                if (n == null) continue;
                b.set(ord);
            }
            bb.add(b);
        }
        return bb;
    }

    private final void unionTermGroups(ArrayList<FixedBitSet> bb) {
        int incr = 0;
        for (int i = 0; i < bb.size() - 1; i += incr) {
            incr = 1;
            int j = i + 1;
            while (j < bb.size()) {
                FixedBitSet fixedBitSet = bb.get(j);
                Intrinsics.checkNotNullExpressionValue((Object)fixedBitSet, (String)"get(...)");
                if (bb.get(i).intersects(fixedBitSet)) {
                    FixedBitSet fixedBitSet2 = bb.get(j);
                    Intrinsics.checkNotNullExpressionValue((Object)fixedBitSet2, (String)"get(...)");
                    bb.get(i).or(fixedBitSet2);
                    bb.remove(j);
                    incr = 0;
                    continue;
                }
                ++j;
            }
        }
    }

    private final HashMap<Term, Integer> termGroups(LinkedHashMap<Term, Integer> tord, ArrayList<FixedBitSet> bb) throws IOException {
        HashMap<Term, Integer> tg = new HashMap<Term, Integer>();
        Set<Term> set = tord.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Term[] t = thisCollection$iv.toArray(new Term[0]);
        int n = ((Collection)bb).size();
        for (int i = 0; i < n; ++i) {
            FixedBitSet bits;
            Intrinsics.checkNotNullExpressionValue((Object)bb.get(i), (String)"get(...)");
            int ord = bits.nextSetBit(0);
            while (ord != Integer.MAX_VALUE) {
                tg.put(t[ord], i);
                ord = ord + 1 >= bits.length() ? Integer.MAX_VALUE : bits.nextSetBit(ord + 1);
            }
        }
        return tg;
    }
}

