/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\n\u000b\f\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/search/SortedSetSelector;", "", "<init>", "()V", "wrap", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "sortedSet", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "selector", "Lorg/gnit/lucenekmp/search/SortedSetSelector$Type;", "Type", "MinValue", "MaxValue", "MiddleMinValue", "MiddleMaxValue", "core"})
public final class SortedSetSelector {
    @NotNull
    public static final SortedSetSelector INSTANCE = new SortedSetSelector();

    private SortedSetSelector() {
    }

    @NotNull
    public final SortedDocValues wrap(@NotNull SortedSetDocValues sortedSet, @NotNull Type selector) {
        Intrinsics.checkNotNullParameter((Object)sortedSet, (String)"sortedSet");
        Intrinsics.checkNotNullParameter((Object)((Object)selector), (String)"selector");
        if (sortedSet.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.INSTANCE.unwrapSingleton(sortedSet);
        if (singleton != null) {
            return singleton;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[selector.ordinal()]) {
            case 1: {
                return new MinValue(sortedSet);
            }
            case 2: {
                return new MaxValue(sortedSet);
            }
            case 3: {
                return new MiddleMinValue(sortedSet);
            }
            case 4: {
                return new MiddleMaxValue(sortedSet);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/search/SortedSetSelector$MaxValue;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "in", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/SortedSetDocValues;)V", "getIn", "()Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "ord", "", "docID", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "ordValue", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "valueCount", "getValueCount", "()I", "lookupTerm", "key", "setOrd", "", "core"})
    public static final class MaxValue
    extends SortedDocValues {
        @NotNull
        private final SortedSetDocValues in;
        private int ord;

        public MaxValue(@NotNull SortedSetDocValues in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
        }

        @NotNull
        public final SortedSetDocValues getIn() {
            return this.in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(@NotNull BytesRef key) throws IOException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (int)this.in.lookupTerm(key);
        }

        private final void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                int docValueCount = this.in.docValueCount();
                int n = docValueCount - 1;
                for (int i = 0; i < n; ++i) {
                    this.in.nextOrd();
                }
                this.ord = (int)this.in.nextOrd();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/search/SortedSetSelector$MiddleMaxValue;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "in", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/SortedSetDocValues;)V", "getIn", "()Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "ord", "", "docID", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "ordValue", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "valueCount", "getValueCount", "()I", "lookupTerm", "key", "setOrd", "", "core"})
    public static final class MiddleMaxValue
    extends SortedDocValues {
        @NotNull
        private final SortedSetDocValues in;
        private int ord;

        public MiddleMaxValue(@NotNull SortedSetDocValues in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
        }

        @NotNull
        public final SortedSetDocValues getIn() {
            return this.in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(@NotNull BytesRef key) throws IOException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (int)this.in.lookupTerm(key);
        }

        private final void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                int docValueCount = this.in.docValueCount();
                int targetIdx = docValueCount >>> 1;
                for (int i = 0; i < targetIdx; ++i) {
                    this.in.nextOrd();
                }
                this.ord = (int)this.in.nextOrd();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/search/SortedSetSelector$MiddleMinValue;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "in", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/SortedSetDocValues;)V", "getIn", "()Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "ord", "", "docID", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "ordValue", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "valueCount", "getValueCount", "()I", "lookupTerm", "key", "setOrd", "", "core"})
    public static final class MiddleMinValue
    extends SortedDocValues {
        @NotNull
        private final SortedSetDocValues in;
        private int ord;

        public MiddleMinValue(@NotNull SortedSetDocValues in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
        }

        @NotNull
        public final SortedSetDocValues getIn() {
            return this.in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(@NotNull BytesRef key) throws IOException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (int)this.in.lookupTerm(key);
        }

        private final void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                int docValueCount = this.in.docValueCount();
                int targetIdx = docValueCount - 1 >>> 1;
                for (int i = 0; i < targetIdx; ++i) {
                    this.in.nextOrd();
                }
                this.ord = (int)this.in.nextOrd();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/search/SortedSetSelector$MinValue;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "in", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/SortedSetDocValues;)V", "getIn", "()Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "ord", "", "docID", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "ordValue", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "valueCount", "getValueCount", "()I", "lookupTerm", "key", "setOrd", "", "core"})
    public static final class MinValue
    extends SortedDocValues {
        @NotNull
        private final SortedSetDocValues in;
        private int ord;

        public MinValue(@NotNull SortedSetDocValues in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
        }

        @NotNull
        public final SortedSetDocValues getIn() {
            return this.in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(@NotNull BytesRef key) throws IOException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (int)this.in.lookupTerm(key);
        }

        private final void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                this.ord = (int)this.in.nextOrd();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/SortedSetSelector$Type;", "", "<init>", "(Ljava/lang/String;I)V", "MIN", "MAX", "MIDDLE_MIN", "MIDDLE_MAX", "core"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type MIN = new Type();
        public static final /* enum */ Type MAX = new Type();
        public static final /* enum */ Type MIDDLE_MIN = new Type();
        public static final /* enum */ Type MIDDLE_MAX = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.MIN, Type.MAX, Type.MIDDLE_MIN, Type.MIDDLE_MAX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.MIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.MAX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.MIDDLE_MIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.MIDDLE_MAX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

