/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.index.FilteredTermsEnum;
import org.gnit.lucenekmp.index.PrefixCodedTerms;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.SortedSet;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.AttributeSource;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.BytesRefComparator;
import org.gnit.lucenekmp.util.BytesRefIterator;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.StringSorter;
import org.gnit.lucenekmp.util.automaton.Automata;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.ByteRunAutomaton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000234B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\fB\u0019\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0002J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0000H\u0002J\b\u0010'\u001a\u00020\u0013H\u0016J\u0012\u0010(\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010*\u001a\u00020\u0015H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u0005\u001a\u0002002\u0006\u00101\u001a\u000202H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00065"}, d2={"Lorg/gnit/lucenekmp/search/TermInSetQuery;", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "Lorg/gnit/lucenekmp/util/Accountable;", "field", "", "terms", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "<init>", "(Ljava/lang/String;Ljava/util/Collection;)V", "rewriteMethod", "Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;", "(Lorg/gnit/lucenekmp/search/MultiTermQuery$RewriteMethod;Ljava/lang/String;Ljava/util/Collection;)V", "termData", "Lorg/gnit/lucenekmp/index/PrefixCodedTerms;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/index/PrefixCodedTerms;)V", "getField", "()Ljava/lang/String;", "termDataHashCode", "", "termsCount", "", "getTermsCount", "()J", "bytesRefIterator", "Lorg/gnit/lucenekmp/util/BytesRefIterator;", "getBytesRefIterator", "()Lorg/gnit/lucenekmp/util/BytesRefIterator;", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "asByteRunAutomaton", "Lorg/gnit/lucenekmp/util/automaton/ByteRunAutomaton;", "equals", "", "other", "", "equalsTo", "hashCode", "toString", "defaultField", "ramBytesUsed", "childResources", "getChildResources", "()Ljava/util/Collection;", "getTermsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "Lorg/gnit/lucenekmp/index/Terms;", "atts", "Lorg/gnit/lucenekmp/util/AttributeSource;", "SetEnum", "Companion", "core"})
public final class TermInSetQuery
extends MultiTermQuery
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    @NotNull
    private final PrefixCodedTerms termData;
    private final int termDataHashCode;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(TermInSetQuery.class));

    @Override
    @NotNull
    public String getField() {
        return this.field;
    }

    public TermInSetQuery(@NotNull String field, @NotNull Collection<BytesRef> terms) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        this(field, TermInSetQuery.Companion.packTerms(field, terms));
    }

    public TermInSetQuery(@NotNull MultiTermQuery.RewriteMethod rewriteMethod, @NotNull String field, @NotNull Collection<BytesRef> terms) {
        Intrinsics.checkNotNullParameter((Object)rewriteMethod, (String)"rewriteMethod");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        super(field, rewriteMethod);
        this.field = field;
        this.termData = TermInSetQuery.Companion.packTerms(field, terms);
        this.termDataHashCode = this.termData.hashCode();
    }

    private TermInSetQuery(String field, PrefixCodedTerms termData) {
        super(field, MultiTermQuery.Companion.getCONSTANT_SCORE_BLENDED_REWRITE());
        this.field = field;
        this.termData = termData;
        this.termDataHashCode = termData.hashCode();
    }

    @Override
    public long getTermsCount() {
        return this.termData.size();
    }

    @NotNull
    public final BytesRefIterator getBytesRefIterator() {
        PrefixCodedTerms.TermIterator iterator2 = this.termData.iterator();
        return new BytesRefIterator(iterator2){
            final /* synthetic */ PrefixCodedTerms.TermIterator $iterator;
            {
                this.$iterator = $iterator;
            }

            public BytesRef next() {
                return this.$iterator.next();
            }
        };
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (!visitor2.acceptField(this.getField())) {
            return;
        }
        if (this.termData.size() == 1L) {
            Query query = this;
            Term[] termArray = new Term[1];
            String string = this.getField();
            BytesRef bytesRef = this.termData.iterator().next();
            Intrinsics.checkNotNull((Object)bytesRef);
            termArray[0] = new Term(string, bytesRef);
            visitor2.consumeTerms(query, termArray);
        }
        if (this.termData.size() > 1L) {
            visitor2.consumeTermsMatching(this, this.getField(), (Function0<ByteRunAutomaton>)((Function0)() -> TermInSetQuery.visit$lambda$0(this)));
        }
    }

    private final ByteRunAutomaton asByteRunAutomaton() {
        try {
            Automaton a = Automata.INSTANCE.makeBinaryStringUnion(this.termData.iterator());
            return new ByteRunAutomaton(a, true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermInSetQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean equalsTo(TermInSetQuery other) {
        return this.termDataHashCode == other.termDataHashCode && Intrinsics.areEqual((Object)this.termData, (Object)other.termData);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.termDataHashCode;
    }

    @Override
    @NotNull
    public String toString(@Nullable String defaultField) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getField());
        builder.append(":(");
        PrefixCodedTerms.TermIterator iterator2 = this.termData.iterator();
        boolean first = true;
        BytesRef term = iterator2.next();
        while (term != null) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(Term.Companion.toString(term));
            term = iterator2.next();
        }
        builder.append(')');
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.termData.ramBytesUsed();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return new ArrayList();
    }

    @Override
    @NotNull
    protected TermsEnum getTermsEnum(@NotNull Terms terms, @NotNull AttributeSource atts) throws IOException {
        Intrinsics.checkNotNullParameter((Object)terms, (String)"terms");
        Intrinsics.checkNotNullParameter((Object)atts, (String)"atts");
        return new SetEnum(terms.iterator());
    }

    private static final ByteRunAutomaton visit$lambda$0(TermInSetQuery this$0) {
        return this$0.asByteRunAutomaton();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/search/TermInSetQuery$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "packTerms", "Lorg/gnit/lucenekmp/index/PrefixCodedTerms;", "field", "", "terms", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    @SourceDebugExtension(value={"SMAP\nTermInSetQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermInSetQuery.kt\norg/gnit/lucenekmp/search/TermInSetQuery$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,272:1\n37#2:273\n36#2,3:274\n*S KotlinDebug\n*F\n+ 1 TermInSetQuery.kt\norg/gnit/lucenekmp/search/TermInSetQuery$Companion\n*L\n232#1:273\n232#1:274,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final PrefixCodedTerms packTerms(String field, Collection<BytesRef> terms) {
            boolean sorted;
            Collection<BytesRef> $this$toTypedArray$iv = terms;
            boolean $i$f$toTypedArray2 = false;
            Collection<BytesRef> thisCollection$iv = $this$toTypedArray$iv;
            BytesRef[] sortedTerms = thisCollection$iv.toArray(new BytesRef[0]);
            boolean bl = sorted = terms instanceof SortedSet && ((SortedSet)terms).comparator() == null;
            if (!sorted) {
                BytesRefComparator $i$f$toTypedArray2 = BytesRefComparator.Companion.getNATURAL();
                new StringSorter(sortedTerms, $i$f$toTypedArray2){
                    final /* synthetic */ BytesRef[] $sortedTerms;
                    {
                        this.$sortedTerms = $sortedTerms;
                        super($super_call_param$1);
                    }

                    protected void get(BytesRefBuilder builder, BytesRef result, int i) {
                        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                        BytesRef term = this.$sortedTerms[i];
                        result.setLength(term.getLength());
                        result.setOffset(term.getOffset());
                        result.setBytes(term.getBytes());
                    }

                    protected void swap(int i, int j) {
                        BytesRef b = this.$sortedTerms[i];
                        this.$sortedTerms[i] = this.$sortedTerms[j];
                        this.$sortedTerms[j] = b;
                    }
                }.sort(0, sortedTerms.length);
            }
            PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
            BytesRefBuilder previous = null;
            for (BytesRef term : sortedTerms) {
                if (previous == null) {
                    previous = new BytesRefBuilder();
                } else if (Intrinsics.areEqual((Object)previous.get(), (Object)term)) continue;
                builder.add(field, term);
                previous.copyBytes(term);
            }
            return builder.finish();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0014J\u0014\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/search/TermInSetQuery$SetEnum;", "Lorg/gnit/lucenekmp/index/FilteredTermsEnum;", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "<init>", "(Lorg/gnit/lucenekmp/search/TermInSetQuery;Lorg/gnit/lucenekmp/index/TermsEnum;)V", "iterator", "Lorg/gnit/lucenekmp/index/PrefixCodedTerms$TermIterator;", "seekTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "accept", "Lorg/gnit/lucenekmp/index/FilteredTermsEnum$AcceptStatus;", "term", "nextSeekTerm", "currentTerm", "core"})
    @SourceDebugExtension(value={"SMAP\nTermInSetQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermInSetQuery.kt\norg/gnit/lucenekmp/search/TermInSetQuery$SetEnum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n1#2:273\n*E\n"})
    private final class SetEnum
    extends FilteredTermsEnum {
        @NotNull
        private final PrefixCodedTerms.TermIterator iterator;
        @Nullable
        private BytesRef seekTerm;

        public SetEnum(TermsEnum termsEnum) {
            Intrinsics.checkNotNullParameter((Object)termsEnum, (String)"termsEnum");
            super(termsEnum);
            this.iterator = TermInSetQuery.this.termData.iterator();
            this.seekTerm = this.iterator.next();
        }

        @Override
        @NotNull
        protected FilteredTermsEnum.AcceptStatus accept(@NotNull BytesRef term) throws IOException {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            int cmp = 0;
            while (this.seekTerm != null) {
                int n;
                BytesRef bytesRef = this.seekTerm;
                Intrinsics.checkNotNull((Object)bytesRef);
                int it = n = bytesRef.compareTo(term);
                boolean bl = false;
                cmp = it;
                if (n >= 0) break;
                this.seekTerm = this.iterator.next();
            }
            return this.seekTerm == null ? FilteredTermsEnum.AcceptStatus.END : (cmp == 0 ? FilteredTermsEnum.AcceptStatus.YES_AND_SEEK : FilteredTermsEnum.AcceptStatus.NO_AND_SEEK);
        }

        @Override
        @Nullable
        protected BytesRef nextSeekTerm(@Nullable BytesRef currentTerm) throws IOException {
            if (currentTerm == null) {
                return this.seekTerm;
            }
            while (this.seekTerm != null) {
                BytesRef bytesRef = this.seekTerm;
                Intrinsics.checkNotNull((Object)bytesRef);
                if (bytesRef.compareTo(currentTerm) > 0) break;
                this.seekTerm = this.iterator.next();
            }
            return this.seekTerm;
        }
    }
}

