/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.IndexReaderContext;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.ReaderUtil;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.CollectionStatistics;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.ConstantScoreScorerSupplier;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.MatchesIterator;
import org.gnit.lucenekmp.search.MatchesUtils;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.TermMatchesIterator;
import org.gnit.lucenekmp.search.TermScorer;
import org.gnit.lucenekmp.search.TermStatistics;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.gnit.lucenekmp.util.IOSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0006\u0010\u000b\u001a\u00020\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/search/TermQuery;", "Lorg/gnit/lucenekmp/search/Query;", "t", "Lorg/gnit/lucenekmp/index/Term;", "<init>", "(Lorg/gnit/lucenekmp/index/Term;)V", "states", "Lorg/gnit/lucenekmp/index/TermStates;", "(Lorg/gnit/lucenekmp/index/Term;Lorg/gnit/lucenekmp/index/TermStates;)V", "term", "perReaderTermState", "getTerm", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "toString", "", "field", "termStates", "getTermStates", "()Lorg/gnit/lucenekmp/index/TermStates;", "equals", "", "other", "", "hashCode", "", "TermWeight", "core"})
public final class TermQuery
extends Query {
    @NotNull
    private final Term term;
    @Nullable
    private final TermStates perReaderTermState;

    public TermQuery(@NotNull Term t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.term = t;
        this.perReaderTermState = null;
    }

    public TermQuery(@NotNull Term t, @NotNull TermStates states) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        this.term = t;
        this.perReaderTermState = states;
    }

    @NotNull
    public final Term getTerm() {
        return this.term;
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        IndexReaderContext context = searcher.getTopReaderContext();
        TermStates termState2 = this.perReaderTermState == null || !this.perReaderTermState.wasBuiltFor(context) ? TermStates.Companion.build(searcher, this.term, scoreMode.needsScores()) : this.perReaderTermState;
        return new TermWeight(searcher, scoreMode, boost, termState2);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.term.field())) {
            Term[] termArray = new Term[]{this.term};
            visitor2.consumeTerms(this, termArray);
        }
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder buffer = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.term.field(), (Object)field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public final TermStates getTermStates() {
        return this.perReaderTermState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (!this.sameClassAs(other)) return false;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.search.TermQuery");
        if (!Intrinsics.areEqual((Object)this.term, (Object)((TermQuery)other).term)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/search/TermQuery$TermWeight;", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "termStates", "Lorg/gnit/lucenekmp/index/TermStates;", "<init>", "(Lorg/gnit/lucenekmp/search/TermQuery;Lorg/gnit/lucenekmp/search/IndexSearcher;Lorg/gnit/lucenekmp/search/ScoreMode;FLorg/gnit/lucenekmp/index/TermStates;)V", "similarity", "Lorg/gnit/lucenekmp/search/similarities/Similarity;", "simScorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "matches", "Lorg/gnit/lucenekmp/search/Matches;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "doc", "", "toString", "", "scorerSupplier", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "isCacheable", "", "ctx", "getTermsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "termNotInReader", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "term", "Lorg/gnit/lucenekmp/index/Term;", "explain", "Lorg/gnit/lucenekmp/search/Explanation;", "count", "core"})
    @SourceDebugExtension(value={"SMAP\nTermQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermQuery.kt\norg/gnit/lucenekmp/search/TermQuery$TermWeight\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n1#2:312\n*E\n"})
    public final class TermWeight
    extends Weight {
        @NotNull
        private final Similarity similarity;
        @Nullable
        private Similarity.SimScorer simScorer;
        @Nullable
        private final TermStates termStates;
        @NotNull
        private final ScoreMode scoreMode;

        public TermWeight(@NotNull IndexSearcher searcher, ScoreMode scoreMode, @Nullable float boost, TermStates termStates) {
            Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
            Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
            super(TermQuery.this);
            if (!(!scoreMode.needsScores() || termStates != null)) {
                boolean $i$a$-check-TermQuery$TermWeight$22 = false;
                String $i$a$-check-TermQuery$TermWeight$22 = "termStates are required when scores are needed";
                throw new IllegalStateException($i$a$-check-TermQuery$TermWeight$22.toString());
            }
            this.scoreMode = scoreMode;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity();
            CollectionStatistics collectionStats = null;
            TermStatistics termStats = null;
            if (scoreMode.needsScores()) {
                CollectionStatistics collectionStatistics = searcher.collectionStatistics(TermQuery.this.term.field());
                Intrinsics.checkNotNull((Object)collectionStatistics);
                collectionStats = collectionStatistics;
                TermStates termStates2 = termStates;
                Intrinsics.checkNotNull((Object)termStates2);
                termStats = termStates2.docFreq() > 0 ? searcher.termStatistics(TermQuery.this.term, termStates.docFreq(), termStates.totalTermFreq()) : null;
            } else {
                collectionStats = new CollectionStatistics(TermQuery.this.term.field(), 1L, 1L, 1L, 1L);
                termStats = new TermStatistics(TermQuery.this.term.bytes(), 1L, 1L);
            }
            if (termStats == null) {
                this.simScorer = null;
            } else if (scoreMode.needsScores()) {
                TermStatistics[] termStatisticsArray = new TermStatistics[]{termStats};
                this.simScorer = this.similarity.scorer(boost, collectionStats, termStatisticsArray);
            } else {
                this.simScorer = new Similarity.SimScorer(){

                    @Override
                    public float score(float freq, long norm) {
                        return 0.0f;
                    }
                };
            }
        }

        @Override
        @Nullable
        public Matches matches(@NotNull LeafReaderContext context, int doc) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            TermsEnum te = this.getTermsEnum(context);
            if (te == null) {
                return null;
            }
            PostingsEnum pe = te.postings(null, PostingsEnum.Companion.getOFFSETS());
            if (pe.advance(doc) != doc) {
                return null;
            }
            return MatchesUtils.INSTANCE.forField(TermQuery.this.term.field(), () -> TermWeight.matches$lambda$1(this, pe));
        }

        @NotNull
        public String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        @Override
        @Nullable
        public ScorerSupplier scorerSupplier(@NotNull LeafReaderContext context) throws IOException {
            IOSupplier<TermState> stateSupplier;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(this.termStates == null || this.termStates.wasBuiltFor(ReaderUtil.INSTANCE.getTopLevelContext(context)))) {
                boolean bl = false;
                String string = "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.INSTANCE.getTopLevelContext(context);
                throw new IllegalArgumentException(string.toString());
            }
            TermStates termStates = this.termStates;
            IOSupplier<TermState> iOSupplier = stateSupplier = termStates != null ? termStates.get(context) : null;
            if (stateSupplier == null) {
                return null;
            }
            return new ScorerSupplier(stateSupplier, context, TermQuery.this, this){
                private TermsEnum termsEnum;
                private boolean topLevelScoringClause;
                final /* synthetic */ IOSupplier<TermState> $stateSupplier;
                final /* synthetic */ LeafReaderContext $context;
                final /* synthetic */ TermQuery this$0;
                final /* synthetic */ TermWeight this$1;
                {
                    this.$stateSupplier = $stateSupplier;
                    this.$context = $context;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public final TermsEnum getTermsEnum() throws IOException {
                    if (this.termsEnum == null) {
                        TermState state2 = this.$stateSupplier.get();
                        if (state2 == null) {
                            return null;
                        }
                        Terms terms = this.$context.reader().terms(TermQuery.access$getTerm$p(this.this$0).field());
                        Intrinsics.checkNotNull((Object)terms);
                        TermsEnum termsEnum = this.termsEnum = terms.iterator();
                        Intrinsics.checkNotNull((Object)termsEnum);
                        termsEnum.seekExact(TermQuery.access$getTerm$p(this.this$0).bytes(), state2);
                    }
                    return this.termsEnum;
                }

                public Scorer get(long leadCost) throws IOException {
                    TermsEnum termsEnum = this.getTermsEnum();
                    if (termsEnum == null) {
                        return new ConstantScoreScorer(0.0f, TermWeight.access$getScoreMode$p(this.this$1), DocIdSetIterator.Companion.empty());
                    }
                    NumericDocValues norms = null;
                    if (TermWeight.access$getScoreMode$p(this.this$1).needsScores()) {
                        norms = this.$context.reader().getNormValues(TermQuery.access$getTerm$p(this.this$0).field());
                    }
                    if (TermWeight.access$getScoreMode$p(this.this$1) == ScoreMode.TOP_SCORES) {
                        ImpactsEnum impactsEnum = termsEnum.impacts(PostingsEnum.Companion.getFREQS());
                        Similarity.SimScorer simScorer = TermWeight.access$getSimScorer$p(this.this$1);
                        Intrinsics.checkNotNull((Object)simScorer);
                        NumericDocValues numericDocValues = norms;
                        Intrinsics.checkNotNull((Object)numericDocValues);
                        return new TermScorer(impactsEnum, simScorer, numericDocValues, this.topLevelScoringClause);
                    }
                    short flags = TermWeight.access$getScoreMode$p(this.this$1).needsScores() ? PostingsEnum.Companion.getFREQS() : (short)0;
                    PostingsEnum postingsEnum = termsEnum.postings(null, flags);
                    Similarity.SimScorer simScorer = TermWeight.access$getSimScorer$p(this.this$1);
                    Intrinsics.checkNotNull((Object)simScorer);
                    NumericDocValues numericDocValues = norms;
                    Intrinsics.checkNotNull((Object)numericDocValues);
                    return new TermScorer(postingsEnum, simScorer, numericDocValues);
                }

                public BulkScorer bulkScorer() throws IOException {
                    if (!TermWeight.access$getScoreMode$p(this.this$1).needsScores()) {
                        DocIdSetIterator iterator2 = this.get(Long.MAX_VALUE).iterator();
                        int maxDoc = this.$context.reader().maxDoc();
                        return ConstantScoreScorerSupplier.Companion.fromIterator(iterator2, 0.0f, TermWeight.access$getScoreMode$p(this.this$1), maxDoc).bulkScorer();
                    }
                    return super.bulkScorer();
                }

                public long cost() {
                    try {
                        TermsEnum te;
                        TermsEnum termsEnum = te = this.getTermsEnum();
                        return termsEnum != null ? (long)termsEnum.docFreq() : 0L;
                    }
                    catch (IOException e) {
                        throw new IOException(e.getMessage());
                    }
                }

                public void setTopLevelScoringClause() {
                    this.topLevelScoringClause = true;
                }
            };
        }

        @Override
        public boolean isCacheable(@NotNull LeafReaderContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return true;
        }

        private final TermsEnum getTermsEnum(LeafReaderContext context) throws IOException {
            TermState state2;
            IOSupplier<TermState> supplier;
            if (this.termStates == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            if (!this.termStates.wasBuiltFor(ReaderUtil.INSTANCE.getTopLevelContext(context))) {
                boolean $i$a$-require-TermQuery$TermWeight$getTermsEnum$32 = false;
                String $i$a$-require-TermQuery$TermWeight$getTermsEnum$32 = "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.INSTANCE.getTopLevelContext(context);
                throw new IllegalArgumentException($i$a$-require-TermQuery$TermWeight$getTermsEnum$32.toString());
            }
            IOSupplier<TermState> iOSupplier = supplier = this.termStates.get(context);
            TermState termState2 = state2 = iOSupplier != null ? iOSupplier.get() : null;
            if (state2 == null) {
                boolean bl = this.termNotInReader(context.reader(), TermQuery.this.term);
                TermQuery termQuery = TermQuery.this;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "no termstate found but term exists in reader term=" + termQuery.term;
                    throw new IllegalArgumentException(string.toString());
                }
                return null;
            }
            Terms terms = context.reader().terms(TermQuery.this.term.field());
            Intrinsics.checkNotNull((Object)terms);
            TermsEnum termsEnum = terms.iterator();
            termsEnum.seekExact(TermQuery.this.term.bytes(), state2);
            return termsEnum;
        }

        private final boolean termNotInReader(LeafReader reader2, Term term) throws IOException {
            return reader2.docFreq(term) == 0;
        }

        @Override
        @NotNull
        public Explanation explain(@NotNull LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Scorer scorer2 = this.scorer(context);
            if (scorer2 != null && (newDoc = scorer2.iterator().advance(doc)) == doc) {
                float freq = ((TermScorer)scorer2).freq();
                NumericDocValues norms = context.reader().getNormValues(TermQuery.this.term.field());
                long norm = 1L;
                if (norms != null && norms.advanceExact(doc)) {
                    norm = norms.longValue();
                }
                Explanation freqExplanation = Explanation.Companion.match((Number)Float.valueOf(freq), "freq, occurrences of term within document", new Explanation[0]);
                Similarity.SimScorer simScorer = this.simScorer;
                Intrinsics.checkNotNull((Object)simScorer);
                Explanation scoreExplanation = simScorer.explain(freqExplanation, norm);
                String description = "weight(" + this.getQuery() + " in " + doc + ") [" + Reflection.getOrCreateKotlinClass(this.similarity.getClass()).getSimpleName() + "], result of:";
                Object[] objectArray = new Explanation[]{scoreExplanation};
                return Explanation.Companion.match(scoreExplanation.getValue(), description, CollectionsKt.mutableListOf((Object[])objectArray));
            }
            return Explanation.Companion.noMatch("no matching term", new Explanation[0]);
        }

        @Override
        public int count(@NotNull LeafReaderContext context) throws IOException {
            int n;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!context.reader().hasDeletions()) {
                TermsEnum termsEnum;
                TermsEnum termsEnum2 = termsEnum = this.getTermsEnum(context);
                n = termsEnum2 != null ? termsEnum2.docFreq() : 0;
            } else {
                n = super.count(context);
            }
            return n;
        }

        private static final MatchesIterator matches$lambda$1(TermWeight this$0, PostingsEnum $pe) {
            return new TermMatchesIterator(this$0.getQuery(), $pe);
        }

        public static final /* synthetic */ ScoreMode access$getScoreMode$p(TermWeight $this) {
            return $this.scoreMode;
        }

        public static final /* synthetic */ Similarity.SimScorer access$getSimScorer$p(TermWeight $this) {
            return $this.simScorer;
        }
    }
}

