/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SlowImpactsEnum;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.ImpactsDISI;
import org.gnit.lucenekmp.search.MaxScoreCache;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.similarities.Similarity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0016H\u0016J\u0015\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\b#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/search/TermScorer;", "Lorg/gnit/lucenekmp/search/Scorer;", "postingsEnum", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "scorer", "Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;", "norms", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "<init>", "(Lorg/gnit/lucenekmp/index/PostingsEnum;Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;Lorg/gnit/lucenekmp/index/NumericDocValues;)V", "impactsEnum", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "topLevelScoringClause", "", "(Lorg/gnit/lucenekmp/index/ImpactsEnum;Lorg/gnit/lucenekmp/search/similarities/Similarity$SimScorer;Lorg/gnit/lucenekmp/index/NumericDocValues;Z)V", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "impactsDisi", "Lorg/gnit/lucenekmp/search/ImpactsDISI;", "maxScoreCache", "Lorg/gnit/lucenekmp/search/MaxScoreCache;", "docID", "", "freq", "score", "", "smoothingScore", "docId", "advanceShallow", "target", "getMaxScore", "upTo", "setMinCompetitiveScore", "", "minScore", "setMinCompetitiveScoreKt", "core"})
public final class TermScorer
extends Scorer {
    @NotNull
    private final PostingsEnum postingsEnum;
    @NotNull
    private final DocIdSetIterator iterator;
    @NotNull
    private final Similarity.SimScorer scorer;
    @NotNull
    private final NumericDocValues norms;
    @Nullable
    private final ImpactsDISI impactsDisi;
    @NotNull
    private final MaxScoreCache maxScoreCache;

    public TermScorer(@NotNull PostingsEnum postingsEnum, @NotNull Similarity.SimScorer scorer2, @NotNull NumericDocValues norms) {
        Intrinsics.checkNotNullParameter((Object)postingsEnum, (String)"postingsEnum");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
        this.postingsEnum = postingsEnum;
        this.iterator = this.postingsEnum;
        ImpactsEnum impactsEnum = new SlowImpactsEnum(postingsEnum);
        this.maxScoreCache = new MaxScoreCache(impactsEnum, scorer2);
        this.impactsDisi = null;
        this.scorer = scorer2;
        this.norms = norms;
    }

    public TermScorer(@NotNull ImpactsEnum impactsEnum, @NotNull Similarity.SimScorer scorer2, @NotNull NumericDocValues norms, boolean topLevelScoringClause) {
        Intrinsics.checkNotNullParameter((Object)impactsEnum, (String)"impactsEnum");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
        this.postingsEnum = impactsEnum;
        this.maxScoreCache = new MaxScoreCache(impactsEnum, scorer2);
        if (topLevelScoringClause) {
            this.impactsDisi = new ImpactsDISI(impactsEnum, this.maxScoreCache);
            this.iterator = this.impactsDisi;
        } else {
            this.impactsDisi = null;
            this.iterator = impactsEnum;
        }
        this.scorer = scorer2;
        this.norms = norms;
    }

    @Override
    public int docID() {
        return this.postingsEnum.docID();
    }

    public final int freq() throws IOException {
        return this.postingsEnum.freq();
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        return this.iterator;
    }

    @Override
    public float score() throws IOException {
        PostingsEnum postingsEnum = this.postingsEnum;
        NumericDocValues norms = this.norms;
        long norm = 1L;
        if (norms != null && norms.advanceExact(postingsEnum.docID())) {
            norm = norms.longValue();
        }
        return this.scorer.score(postingsEnum.freq(), norm);
    }

    @Override
    public float smoothingScore(int docId) throws IOException {
        long norm = 1L;
        if (this.norms != null && this.norms.advanceExact(docId)) {
            norm = this.norms.longValue();
        }
        return this.scorer.score(0.0f, norm);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.maxScoreCache.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreCache.getMaxScore(upTo);
    }

    @JvmName(name="setMinCompetitiveScoreKt")
    public final void setMinCompetitiveScoreKt(float minScore) {
        if (this.impactsDisi != null) {
            this.impactsDisi.setMinCompetitiveScore(minScore);
        }
    }
}

