/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.QueryTimeout;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TotalHits;
import org.gnit.lucenekmp.search.knn.KnnCollectorManager;
import org.gnit.lucenekmp.search.knn.KnnSearchStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\b\u001a\u0004\u0018\u00010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/search/TimeLimitingKnnCollectorManager;", "Lorg/gnit/lucenekmp/search/knn/KnnCollectorManager;", "delegate", "timeout", "Lorg/gnit/lucenekmp/index/QueryTimeout;", "<init>", "(Lorg/gnit/lucenekmp/search/knn/KnnCollectorManager;Lorg/gnit/lucenekmp/index/QueryTimeout;)V", "queryTimeout", "getQueryTimeout", "newCollector", "Lorg/gnit/lucenekmp/search/KnnCollector;", "visitedLimit", "", "searchStrategy", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "TimeLimitingKnnCollector", "core"})
public final class TimeLimitingKnnCollectorManager
implements KnnCollectorManager {
    @NotNull
    private final KnnCollectorManager delegate;
    @Nullable
    private final QueryTimeout queryTimeout;

    public TimeLimitingKnnCollectorManager(@NotNull KnnCollectorManager delegate, @Nullable QueryTimeout timeout) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.queryTimeout = timeout;
    }

    @Nullable
    public final QueryTimeout getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    @NotNull
    public KnnCollector newCollector(int visitedLimit, @NotNull KnnSearchStrategy searchStrategy, @NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)searchStrategy, (String)"searchStrategy");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KnnCollector collector2 = this.delegate.newCollector(visitedLimit, searchStrategy, context);
        if (this.queryTimeout == null) {
            return collector2;
        }
        return new TimeLimitingKnnCollector(collector2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/search/TimeLimitingKnnCollectorManager$TimeLimitingKnnCollector;", "Lorg/gnit/lucenekmp/search/KnnCollector$Decorator;", "collector", "Lorg/gnit/lucenekmp/search/KnnCollector;", "<init>", "(Lorg/gnit/lucenekmp/search/TimeLimitingKnnCollectorManager;Lorg/gnit/lucenekmp/search/KnnCollector;)V", "earlyTerminated", "", "topDocs", "Lorg/gnit/lucenekmp/search/TopDocs;", "core"})
    public final class TimeLimitingKnnCollector
    extends KnnCollector.Decorator {
        public TimeLimitingKnnCollector(KnnCollector collector2) {
            Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
            super(collector2);
        }

        @Override
        public boolean earlyTerminated() {
            QueryTimeout queryTimeout = TimeLimitingKnnCollectorManager.this.queryTimeout;
            Intrinsics.checkNotNull((Object)queryTimeout);
            return queryTimeout.shouldExit() || super.earlyTerminated();
        }

        @Override
        @NotNull
        public TopDocs topDocs() {
            TopDocs docs = super.topDocs();
            QueryTimeout queryTimeout = TimeLimitingKnnCollectorManager.this.queryTimeout;
            Intrinsics.checkNotNull((Object)queryTimeout);
            TotalHits.Relation relation = queryTimeout.shouldExit() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : docs.getTotalHits().getRelation();
            return new TopDocs(new TotalHits(docs.getTotalHits().getValue(), relation), docs.getScoreDocs());
        }
    }
}

