/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.Collector;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TotalHits;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 #*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001#B\u0017\b\u0004\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001a2\u0006\u0010\u001f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u000bH\u0014J\b\u0010\"\u001a\u00020\u001eH\u0016J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bJ\u0016\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/search/TopDocsCollector;", "T", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "Lorg/gnit/lucenekmp/search/Collector;", "pq", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "<init>", "(Lorg/gnit/lucenekmp/util/PriorityQueue;)V", "getPq", "()Lorg/gnit/lucenekmp/util/PriorityQueue;", "value", "", "totalHits", "getTotalHits", "()I", "setTotalHits", "(I)V", "totalHitsRelation", "Lorg/gnit/lucenekmp/search/TotalHits$Relation;", "getTotalHitsRelation", "()Lorg/gnit/lucenekmp/search/TotalHits$Relation;", "setTotalHitsRelation", "(Lorg/gnit/lucenekmp/search/TotalHits$Relation;)V", "populateResults", "", "results", "", "howMany", "([Lorg/gnit/lucenekmp/search/ScoreDoc;I)V", "newTopDocs", "Lorg/gnit/lucenekmp/search/TopDocs;", "start", "([Lorg/gnit/lucenekmp/search/ScoreDoc;I)Lorg/gnit/lucenekmp/search/TopDocs;", "topDocsSize", "topDocs", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTopDocsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopDocsCollector.kt\norg/gnit/lucenekmp/search/TopDocsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public abstract class TopDocsCollector<T extends ScoreDoc>
implements Collector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PriorityQueue<T> pq;
    private int totalHits;
    @NotNull
    private TotalHits.Relation totalHitsRelation;
    @NotNull
    private static final TopDocs EMPTY_TOPDOCS = new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);

    protected TopDocsCollector(@NotNull PriorityQueue<T> pq2) {
        Intrinsics.checkNotNullParameter(pq2, (String)"pq");
        this.pq = pq2;
        this.totalHitsRelation = TotalHits.Relation.EQUAL_TO;
    }

    @NotNull
    protected final PriorityQueue<T> getPq() {
        return this.pq;
    }

    public final int getTotalHits() {
        return this.totalHits;
    }

    protected final void setTotalHits(int n) {
        this.totalHits = n;
    }

    @NotNull
    protected final TotalHits.Relation getTotalHitsRelation() {
        return this.totalHitsRelation;
    }

    protected final void setTotalHitsRelation(@NotNull TotalHits.Relation relation) {
        Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"<set-?>");
        this.totalHitsRelation = relation;
    }

    protected void populateResults(@NotNull ScoreDoc[] results2, int howMany) {
        Intrinsics.checkNotNullParameter((Object)results2, (String)"results");
        for (int i = howMany - 1; -1 < i; --i) {
            Intrinsics.checkNotNull(this.pq.pop());
        }
    }

    @NotNull
    protected TopDocs newTopDocs(@Nullable ScoreDoc[] results2, int start) {
        return results2 == null ? EMPTY_TOPDOCS : new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results2);
    }

    protected int topDocsSize() {
        return Math.min(this.totalHits, this.pq.size());
    }

    @NotNull
    public TopDocs topDocs() {
        return this.topDocs(0, this.topDocsSize());
    }

    @NotNull
    public final TopDocs topDocs(int start) {
        return this.topDocs(start, this.topDocsSize());
    }

    @NotNull
    public final TopDocs topDocs(int start, int howMany) {
        int howMany2 = 0;
        howMany2 = howMany;
        int size2 = this.topDocsSize();
        if (!(howMany2 >= 0)) {
            boolean $i$a$-require-TopDocsCollector$topDocs$32 = false;
            String $i$a$-require-TopDocsCollector$topDocs$32 = "Number of hits requested must be greater than 0 but value was " + howMany2;
            throw new IllegalArgumentException($i$a$-require-TopDocsCollector$topDocs$32.toString());
        }
        if (!(start >= 0)) {
            boolean $i$a$-require-TopDocsCollector$topDocs$42 = false;
            String $i$a$-require-TopDocsCollector$topDocs$42 = "Expected value of starting position is between 0 and " + size2 + ", got " + start;
            throw new IllegalArgumentException($i$a$-require-TopDocsCollector$topDocs$42.toString());
        }
        if (start >= size2 || howMany2 == 0) {
            return this.newTopDocs(null, start);
        }
        howMany2 = Math.min(size2 - start, howMany2);
        ScoreDoc[] results2 = new ScoreDoc[howMany2];
        for (int i = this.pq.size() - start - howMany2; 0 < i; --i) {
            this.pq.pop();
        }
        this.populateResults(results2, howMany2);
        return this.newTopDocs(results2, start);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/search/TopDocsCollector$Companion;", "", "<init>", "()V", "EMPTY_TOPDOCS", "Lorg/gnit/lucenekmp/search/TopDocs;", "getEMPTY_TOPDOCS", "()Lorg/gnit/lucenekmp/search/TopDocs;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TopDocs getEMPTY_TOPDOCS() {
            return EMPTY_TOPDOCS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

