/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.CollectorManager;
import org.gnit.lucenekmp.search.FieldDoc;
import org.gnit.lucenekmp.search.FieldValueHitQueue;
import org.gnit.lucenekmp.search.MaxScoreAccumulator;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopFieldCollector;
import org.gnit.lucenekmp.search.TopFieldDocs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fB3\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0010J\b\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/search/TopFieldCollectorManager;", "Lorg/gnit/lucenekmp/search/CollectorManager;", "Lorg/gnit/lucenekmp/search/TopFieldCollector;", "Lorg/gnit/lucenekmp/search/TopFieldDocs;", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "numHits", "", "after", "Lorg/gnit/lucenekmp/search/FieldDoc;", "totalHitsThreshold", "<init>", "(Lorg/gnit/lucenekmp/search/Sort;ILorg/gnit/lucenekmp/search/FieldDoc;I)V", "supportsConcurrency", "", "(Lorg/gnit/lucenekmp/search/Sort;ILorg/gnit/lucenekmp/search/FieldDoc;IZ)V", "(Lorg/gnit/lucenekmp/search/Sort;II)V", "minScoreAcc", "Lorg/gnit/lucenekmp/search/MaxScoreAccumulator;", "collectors", "", "getCollectors", "()Ljava/util/List;", "newCollector", "reduce", "", "core"})
@SourceDebugExtension(value={"SMAP\nTopFieldCollectorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopFieldCollectorManager.kt\norg/gnit/lucenekmp/search/TopFieldCollectorManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1#2:174\n*E\n"})
public final class TopFieldCollectorManager
implements CollectorManager<TopFieldCollector, TopFieldDocs> {
    @NotNull
    private final Sort sort;
    private final int numHits;
    @Nullable
    private final FieldDoc after;
    private final int totalHitsThreshold;
    @Nullable
    private final MaxScoreAccumulator minScoreAcc;
    @NotNull
    private final List<TopFieldCollector> collectors;

    public TopFieldCollectorManager(@NotNull Sort sort2, int numHits, @Nullable FieldDoc after, int totalHitsThreshold) {
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        if (!(totalHitsThreshold >= 0)) {
            boolean $i$a$-require-TopFieldCollectorManager$42 = false;
            String $i$a$-require-TopFieldCollectorManager$42 = "totalHitsThreshold must be >= 0, got " + totalHitsThreshold;
            throw new IllegalArgumentException($i$a$-require-TopFieldCollectorManager$42.toString());
        }
        if (!(numHits > 0)) {
            boolean $i$a$-require-TopFieldCollectorManager$62 = false;
            String $i$a$-require-TopFieldCollectorManager$62 = "numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count";
            throw new IllegalArgumentException($i$a$-require-TopFieldCollectorManager$62.toString());
        }
        if (!(!(sort2.getSort().length == 0))) {
            boolean $i$a$-require-TopFieldCollectorManager$72 = false;
            String $i$a$-require-TopFieldCollectorManager$72 = "Sort must contain at least one field";
            throw new IllegalArgumentException($i$a$-require-TopFieldCollectorManager$72.toString());
        }
        if (after != null) {
            if (after.getFields() == null) {
                boolean $i$a$-requireNotNull-TopFieldCollectorManager$52 = false;
                String $i$a$-requireNotNull-TopFieldCollectorManager$52 = "after.fields wasn't set; you must pass fillFields=true for the previous search";
                throw new IllegalArgumentException($i$a$-requireNotNull-TopFieldCollectorManager$52.toString());
            }
            Object[] objectArray = after.getFields();
            Intrinsics.checkNotNull((Object)objectArray);
            if (!(objectArray.length == sort2.getSort().length)) {
                boolean bl = false;
                Object[] objectArray2 = after.getFields();
                Intrinsics.checkNotNull((Object)objectArray2);
                String string = "after.fields has " + objectArray2.length + " values but sort has " + sort2.getSort().length;
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.sort = sort2;
        this.numHits = numHits;
        this.after = after;
        this.totalHitsThreshold = totalHitsThreshold;
        this.minScoreAcc = totalHitsThreshold != Integer.MAX_VALUE ? new MaxScoreAccumulator() : null;
        this.collectors = new ArrayList();
    }

    @NotNull
    public final List<TopFieldCollector> getCollectors() {
        return this.collectors;
    }

    @Deprecated(message="Use {@link #TopFieldCollectorManager(Sort, int, FieldDoc, int)}, the\n        supportsConcurrency parameter is now a no-op.")
    public TopFieldCollectorManager(@NotNull Sort sort2, int numHits, @Nullable FieldDoc after, int totalHitsThreshold, boolean supportsConcurrency) {
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        this(sort2, numHits, after, totalHitsThreshold);
    }

    public TopFieldCollectorManager(@NotNull Sort sort2, int numHits, int totalHitsThreshold) {
        Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
        this(sort2, numHits, null, totalHitsThreshold, true);
    }

    @Override
    @NotNull
    public TopFieldCollector newCollector() {
        FieldValueHitQueue<FieldValueHitQueue.Entry> queue2 = FieldValueHitQueue.Companion.create(this.sort.getSort(), this.numHits);
        TopFieldCollector collector2 = null;
        if (this.after == null) {
            if (queue2.getComparators().length == 1) {
                queue2.getComparators()[0].setSingleSort();
            }
            collector2 = new TopFieldCollector.SimpleFieldCollector(this.sort, queue2, this.numHits, this.totalHitsThreshold, this.minScoreAcc);
        } else {
            if (this.after.getFields() == null) {
                boolean $i$a$-requireNotNull-TopFieldCollectorManager$newCollector$22 = false;
                String $i$a$-requireNotNull-TopFieldCollectorManager$newCollector$22 = "after.fields wasn't set; you must pass fillFields=true for the previous search";
                throw new IllegalArgumentException($i$a$-requireNotNull-TopFieldCollectorManager$newCollector$22.toString());
            }
            Object[] objectArray = this.after.getFields();
            Intrinsics.checkNotNull((Object)objectArray);
            if (!(objectArray.length == this.sort.getSort().length)) {
                boolean bl = false;
                Object[] objectArray2 = this.after.getFields();
                Intrinsics.checkNotNull((Object)objectArray2);
                String string = "after.fields has " + objectArray2.length + " values but sort has " + this.sort.getSort().length;
                throw new IllegalArgumentException(string.toString());
            }
            collector2 = new TopFieldCollector.PagingFieldCollector(this.sort, queue2, this.after, this.numHits, this.totalHitsThreshold, this.minScoreAcc);
        }
        this.collectors.add(collector2);
        return collector2;
    }

    @Override
    @NotNull
    public TopFieldDocs reduce(@NotNull Collection<TopFieldCollector> collectors) throws IOException {
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        TopFieldDocs[] topDocs = new TopFieldDocs[collectors.size()];
        int i = 0;
        for (TopFieldCollector collector2 : collectors) {
            topDocs[i++] = collector2.topDocs();
        }
        return TopDocs.Companion.merge(this.sort, 0, this.numHits, topDocs);
    }
}

