/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.AbstractKnnCollector;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TotalHits;
import org.gnit.lucenekmp.search.knn.KnnSearchStrategy;
import org.gnit.lucenekmp.util.hnsw.NeighborQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/search/TopKnnCollector;", "Lorg/gnit/lucenekmp/search/AbstractKnnCollector;", "k", "", "visitLimit", "searchStrategy", "Lorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;", "<init>", "(IILorg/gnit/lucenekmp/search/knn/KnnSearchStrategy;)V", "queue", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "getQueue", "()Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "collect", "", "docId", "similarity", "", "minCompetitiveSimilarity", "topDocs", "Lorg/gnit/lucenekmp/search/TopDocs;", "numCollected", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nTopKnnCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopKnnCollector.kt\norg/gnit/lucenekmp/search/TopKnnCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public class TopKnnCollector
extends AbstractKnnCollector {
    @NotNull
    private final NeighborQueue queue;

    @JvmOverloads
    public TopKnnCollector(int k, int visitLimit, @Nullable KnnSearchStrategy searchStrategy) {
        super(k, visitLimit, searchStrategy);
        this.queue = new NeighborQueue(k, false);
    }

    public /* synthetic */ TopKnnCollector(int n, int n2, KnnSearchStrategy knnSearchStrategy, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            knnSearchStrategy = null;
        }
        this(n, n2, knnSearchStrategy);
    }

    @NotNull
    protected final NeighborQueue getQueue() {
        return this.queue;
    }

    @Override
    public boolean collect(int docId, float similarity) {
        return this.queue.insertWithOverflow(docId, similarity);
    }

    @Override
    public float minCompetitiveSimilarity() {
        return this.queue.size() >= this.k() ? this.queue.topScore() : Float.NEGATIVE_INFINITY;
    }

    @Override
    @NotNull
    public TopDocs topDocs() {
        if (!(this.queue.size() <= this.k())) {
            boolean $i$a$-require-TopKnnCollector$topDocs$22 = false;
            String $i$a$-require-TopKnnCollector$topDocs$22 = "Tried to collect more results than the maximum number allowed";
            throw new IllegalArgumentException($i$a$-require-TopKnnCollector$topDocs$22.toString());
        }
        int i = 1;
        ScoreDoc[] scoreDocs = new ScoreDoc[this.queue.size()];
        int n = scoreDocs.length;
        if (i <= n) {
            while (true) {
                scoreDocs[scoreDocs.length - i] = new ScoreDoc(this.queue.topNode(), this.queue.topScore(), 0, 4, null);
                this.queue.pop();
                if (i == n) break;
                ++i;
            }
        }
        TotalHits.Relation relation = this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        long l = this.visitedCount();
        TotalHits.Relation relation2 = relation;
        Intrinsics.checkNotNull((Object)((Object)relation2));
        return new TopDocs(new TotalHits(l, relation2), scoreDocs);
    }

    @Override
    public int numCollected() {
        return this.queue.size();
    }

    @NotNull
    public String toString() {
        return "TopKnnCollector[k=" + this.k() + ", size=" + this.queue.size() + "]";
    }

    @JvmOverloads
    public TopKnnCollector(int k, int visitLimit) {
        this(k, visitLimit, (KnnSearchStrategy)null, 4, (DefaultConstructorMarker)null);
    }
}

