/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.CollectorManager;
import org.gnit.lucenekmp.search.MaxScoreAccumulator;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopScoreDocCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nB+\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0016\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/search/TopScoreDocCollectorManager;", "Lorg/gnit/lucenekmp/search/CollectorManager;", "Lorg/gnit/lucenekmp/search/TopScoreDocCollector;", "Lorg/gnit/lucenekmp/search/TopDocs;", "numHits", "", "after", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "totalHitsThreshold", "<init>", "(ILorg/gnit/lucenekmp/search/ScoreDoc;I)V", "supportsConcurrency", "", "(ILorg/gnit/lucenekmp/search/ScoreDoc;IZ)V", "(II)V", "minScoreAcc", "Lorg/gnit/lucenekmp/search/MaxScoreAccumulator;", "newCollector", "reduce", "collectors", "", "core"})
@SourceDebugExtension(value={"SMAP\nTopScoreDocCollectorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopScoreDocCollectorManager.kt\norg/gnit/lucenekmp/search/TopScoreDocCollectorManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class TopScoreDocCollectorManager
implements CollectorManager<TopScoreDocCollector, TopDocs> {
    private final int numHits;
    @Nullable
    private final ScoreDoc after;
    private final int totalHitsThreshold;
    @Nullable
    private final MaxScoreAccumulator minScoreAcc;

    public TopScoreDocCollectorManager(int numHits, @Nullable ScoreDoc after, int totalHitsThreshold) {
        if (!(totalHitsThreshold >= 0)) {
            boolean $i$a$-require-TopScoreDocCollectorManager$32 = false;
            String $i$a$-require-TopScoreDocCollectorManager$32 = "totalHitsThreshold must be >= 0, got " + totalHitsThreshold;
            throw new IllegalArgumentException($i$a$-require-TopScoreDocCollectorManager$32.toString());
        }
        if (!(numHits > 0)) {
            boolean bl = false;
            String string = "numHits must be > 0; please use TotalHitCountCollectorManager if you just need the total hit count";
            throw new IllegalArgumentException(string.toString());
        }
        this.numHits = numHits;
        this.after = after;
        this.totalHitsThreshold = Math.max(totalHitsThreshold, numHits);
        this.minScoreAcc = totalHitsThreshold != Integer.MAX_VALUE ? new MaxScoreAccumulator() : null;
    }

    @Deprecated(message="Use {@link #TopScoreDocCollectorManager(int, ScoreDoc, int)}, the\n        supportsConcurrency parameter is now a no-op.")
    public TopScoreDocCollectorManager(int numHits, @Nullable ScoreDoc after, int totalHitsThreshold, boolean supportsConcurrency) {
        this(numHits, after, totalHitsThreshold);
    }

    public TopScoreDocCollectorManager(int numHits, int totalHitsThreshold) {
        this(numHits, null, totalHitsThreshold, true);
    }

    @Override
    @NotNull
    public TopScoreDocCollector newCollector() {
        return new TopScoreDocCollector(this.numHits, this.after, this.totalHitsThreshold, this.minScoreAcc);
    }

    @Override
    @NotNull
    public TopDocs reduce(@NotNull Collection<TopScoreDocCollector> collectors) throws IOException {
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        TopDocs[] topDocs = new TopDocs[collectors.size()];
        int i = 0;
        for (TopScoreDocCollector collector2 : collectors) {
            topDocs[i++] = collector2.topDocs();
        }
        return TopDocs.Companion.merge(0, this.numHits, topDocs);
    }
}

