/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.index.TermStates;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.PriorityQueue;
import org.gnit.lucenekmp.search.BoostAttribute;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MaxNonCompetitiveBoostAttribute;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.TermCollectingRewrite;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/search/TopTermsRewrite;", "B", "Lorg/gnit/lucenekmp/search/TermCollectingRewrite;", "size", "", "<init>", "(I)V", "getSize", "()I", "maxSize", "getMaxSize", "rewrite", "Lorg/gnit/lucenekmp/search/Query;", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "query", "Lorg/gnit/lucenekmp/search/MultiTermQuery;", "hashCode", "equals", "", "obj", "", "ScoreTerm", "core"})
public abstract class TopTermsRewrite<B>
extends TermCollectingRewrite<B> {
    private final int size;

    public TopTermsRewrite(int size2) {
        this.size = size2;
    }

    public final int getSize() {
        return this.size;
    }

    protected abstract int getMaxSize();

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher, @NotNull MultiTermQuery query) throws IOException {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        int maxSize = Math.min(this.size, this.getMaxSize());
        PriorityQueue<ScoreTerm> stQueue = new PriorityQueue<ScoreTerm>(0, null, 3, null);
        this.collectTerms(indexSearcher.getIndexReader(), query, new TermCollectingRewrite.TermCollector(stQueue, maxSize){
            private final MaxNonCompetitiveBoostAttribute maxBoostAtt;
            private final Map<BytesRef, ScoreTerm> visitedTerms;
            private TermsEnum termsEnum;
            private BoostAttribute boostAtt;
            private ScoreTerm st;
            private BytesRefBuilder lastTerm;
            final /* synthetic */ PriorityQueue<ScoreTerm> $stQueue;
            final /* synthetic */ int $maxSize;
            {
                this.$stQueue = $stQueue;
                this.$maxSize = $maxSize;
                this.maxBoostAtt = (MaxNonCompetitiveBoostAttribute)this.getAttributes().addAttribute(Reflection.getOrCreateKotlinClass(MaxNonCompetitiveBoostAttribute.class));
                this.visitedTerms = new LinkedHashMap<K, V>();
            }

            public void setNextEnum(TermsEnum termsEnum) {
                Intrinsics.checkNotNullParameter((Object)termsEnum, (String)"termsEnum");
                this.termsEnum = termsEnum;
                if (!this.compareToLastTerm(null)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.st == null) {
                    this.st = new ScoreTerm(new TermStates(this.getTopReaderContext()));
                }
                this.boostAtt = (BoostAttribute)termsEnum.attributes().addAttribute(Reflection.getOrCreateKotlinClass(BoostAttribute.class));
            }

            public final boolean compareToLastTerm(BytesRef t) {
                if (this.lastTerm == null && t != null) {
                    BytesRefBuilder bytesRefBuilder = this.lastTerm = new BytesRefBuilder();
                    Intrinsics.checkNotNull((Object)bytesRefBuilder);
                    bytesRefBuilder.append(t);
                } else if (t == null) {
                    this.lastTerm = null;
                } else {
                    BytesRefBuilder bytesRefBuilder = this.lastTerm;
                    Intrinsics.checkNotNull((Object)bytesRefBuilder);
                    if (!(bytesRefBuilder.get().compareTo(t) < 0)) {
                        boolean bl = false;
                        String string = "lastTerm=" + this.lastTerm + " t=" + t;
                        throw new IllegalArgumentException(string.toString());
                    }
                    BytesRefBuilder bytesRefBuilder2 = this.lastTerm;
                    Intrinsics.checkNotNull((Object)bytesRefBuilder2);
                    bytesRefBuilder2.copyBytes(t);
                }
                return true;
            }

            public boolean collect(BytesRef bytes) throws IOException {
                ScoreTerm t;
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                BoostAttribute boostAttribute = this.boostAtt;
                Intrinsics.checkNotNull((Object)boostAttribute);
                float boost = boostAttribute.getBoost();
                if (!this.compareToLastTerm(bytes)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.$stQueue.size() == this.$maxSize) {
                    ScoreTerm scoreTerm = this.$stQueue.peek();
                    Intrinsics.checkNotNull((Object)scoreTerm);
                    t = scoreTerm;
                    if (boost < t.getBoost()) {
                        return true;
                    }
                    if (boost == t.getBoost() && bytes.compareTo(t.getBytes().get()) > 0) {
                        return true;
                    }
                }
                t = this.visitedTerms.get(bytes);
                TermsEnum termsEnum = this.termsEnum;
                Intrinsics.checkNotNull((Object)termsEnum);
                TermState termState2 = termsEnum.termState();
                if (termState2 == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                TermState state2 = termState2;
                if (t != null) {
                    if (!(t.getBoost() == boost)) {
                        boolean $i$a$-require-TopTermsRewrite$rewrite$1$collect$32 = false;
                        String $i$a$-require-TopTermsRewrite$rewrite$1$collect$32 = "boost should be equal in all segment TermsEnums";
                        throw new IllegalArgumentException($i$a$-require-TopTermsRewrite$rewrite$1$collect$32.toString());
                    }
                    TermStates termStates = t.getTermState();
                    LeafReaderContext leafReaderContext = this.getReaderContext();
                    Intrinsics.checkNotNull((Object)leafReaderContext);
                    int n = leafReaderContext.getOrd();
                    TermsEnum termsEnum2 = this.termsEnum;
                    Intrinsics.checkNotNull((Object)termsEnum2);
                    int n2 = termsEnum2.docFreq();
                    TermsEnum termsEnum3 = this.termsEnum;
                    Intrinsics.checkNotNull((Object)termsEnum3);
                    termStates.register(state2, n, n2, termsEnum3.totalTermFreq());
                } else {
                    ScoreTerm scoreTerm = this.st;
                    Intrinsics.checkNotNull((Object)scoreTerm);
                    scoreTerm.getBytes().copyBytes(bytes);
                    ScoreTerm scoreTerm2 = this.st;
                    Intrinsics.checkNotNull((Object)scoreTerm2);
                    scoreTerm2.setBoost(boost);
                    ScoreTerm scoreTerm3 = this.st;
                    Intrinsics.checkNotNull((Object)scoreTerm3);
                    BytesRef bytesRef = scoreTerm3.getBytes().get();
                    ScoreTerm scoreTerm4 = this.st;
                    Intrinsics.checkNotNull((Object)scoreTerm4);
                    this.visitedTerms.put(bytesRef, scoreTerm4);
                    ScoreTerm scoreTerm5 = this.st;
                    Intrinsics.checkNotNull((Object)scoreTerm5);
                    if (!(scoreTerm5.getTermState().docFreq() == 0)) {
                        String $i$a$-require-TopTermsRewrite$rewrite$1$collect$32 = "Failed requirement.";
                        throw new IllegalArgumentException($i$a$-require-TopTermsRewrite$rewrite$1$collect$32.toString());
                    }
                    ScoreTerm scoreTerm6 = this.st;
                    Intrinsics.checkNotNull((Object)scoreTerm6);
                    TermStates termStates = scoreTerm6.getTermState();
                    LeafReaderContext leafReaderContext = this.getReaderContext();
                    Intrinsics.checkNotNull((Object)leafReaderContext);
                    int n = leafReaderContext.getOrd();
                    TermsEnum termsEnum4 = this.termsEnum;
                    Intrinsics.checkNotNull((Object)termsEnum4);
                    int n3 = termsEnum4.docFreq();
                    TermsEnum termsEnum5 = this.termsEnum;
                    Intrinsics.checkNotNull((Object)termsEnum5);
                    termStates.register(state2, n, n3, termsEnum5.totalTermFreq());
                    this.$stQueue.offer(this.st);
                    if (this.$stQueue.size() > this.$maxSize) {
                        ScoreTerm scoreTerm7 = this.st = this.$stQueue.poll();
                        Intrinsics.checkNotNull((Object)scoreTerm7);
                        this.visitedTerms.remove(scoreTerm7.getBytes().get());
                        ScoreTerm scoreTerm8 = this.st;
                        Intrinsics.checkNotNull((Object)scoreTerm8);
                        scoreTerm8.getTermState().clear();
                    } else {
                        this.st = new ScoreTerm(new TermStates(this.getTopReaderContext()));
                    }
                    if (!(this.$stQueue.size() <= this.$maxSize)) {
                        boolean bl = false;
                        String string = "the PQ size must be limited to maxSize";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (this.$stQueue.size() == this.$maxSize) {
                        ScoreTerm scoreTerm9 = t = this.$stQueue.peek();
                        Intrinsics.checkNotNull((Object)scoreTerm9);
                        this.maxBoostAtt.setMaxNonCompetitiveBoost(scoreTerm9.getBoost());
                        this.maxBoostAtt.setCompetitiveTerm(t.getBytes().get());
                    }
                }
                return true;
            }
        });
        Object b = this.getTopLevelBuilder();
        ScoreTerm[] scoreTerms = stQueue.toTypedArray();
        ArrayUtil.Companion.timSort(scoreTerms, (arg_0, arg_1) -> TopTermsRewrite.rewrite$lambda$1(TopTermsRewrite::rewrite$lambda$0, arg_0, arg_1));
        for (ScoreTerm st : scoreTerms) {
            Term term = new Term(query.getField(), st.getBytes().toBytesRef());
            this.addClause(b, term, st.getTermState().docFreq(), Math.max(0.0f, st.getBoost()), st.getTermState());
        }
        return this.build(b);
    }

    public int hashCode() {
        return 31 * this.size;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopTermsRewrite other = (TopTermsRewrite)obj;
        return this.size == other.size;
    }

    private static final int rewrite$lambda$0(ScoreTerm st1, ScoreTerm st2) {
        return st1.getBytes().get().compareTo(st2.getBytes().get());
    }

    private static final int rewrite$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/search/TopTermsRewrite$ScoreTerm;", "", "termState", "Lorg/gnit/lucenekmp/index/TermStates;", "<init>", "(Lorg/gnit/lucenekmp/index/TermStates;)V", "getTermState", "()Lorg/gnit/lucenekmp/index/TermStates;", "bytes", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "getBytes", "()Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "boost", "", "getBoost", "()F", "setBoost", "(F)V", "compareTo", "", "other", "core"})
    public static final class ScoreTerm
    implements Comparable<ScoreTerm> {
        @NotNull
        private final TermStates termState;
        @NotNull
        private final BytesRefBuilder bytes;
        private float boost;

        public ScoreTerm(@NotNull TermStates termState2) {
            Intrinsics.checkNotNullParameter((Object)termState2, (String)"termState");
            this.termState = termState2;
            this.bytes = new BytesRefBuilder();
        }

        @NotNull
        public final TermStates getTermState() {
            return this.termState;
        }

        @NotNull
        public final BytesRefBuilder getBytes() {
            return this.bytes;
        }

        public final float getBoost() {
            return this.boost;
        }

        public final void setBoost(float f) {
            this.boost = f;
        }

        @Override
        public int compareTo(@NotNull ScoreTerm other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.boost == other.boost ? other.bytes.get().compareTo(this.bytes.get()) : FloatExtKt.compare(FloatCompanionObject.INSTANCE, this.boost, other.boost);
        }
    }
}

