/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.search.CollectionTerminatedException;
import org.gnit.lucenekmp.search.Collector;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.DocIdStream;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Scorable;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0004R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/search/TotalHitCountCollector;", "Lorg/gnit/lucenekmp/search/Collector;", "<init>", "()V", "weight", "Lorg/gnit/lucenekmp/search/Weight;", "getWeight", "()Lorg/gnit/lucenekmp/search/Weight;", "setWeight", "(Lorg/gnit/lucenekmp/search/Weight;)V", "value", "", "totalHits", "getTotalHits", "()I", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "getLeafCollector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "createLeafCollector", "core"})
public class TotalHitCountCollector
implements Collector {
    @Nullable
    private Weight weight;
    private int totalHits;

    @Override
    @Nullable
    public Weight getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(@Nullable Weight weight) {
        this.weight = weight;
    }

    public final int getTotalHits() {
        return this.totalHits;
    }

    @Override
    @NotNull
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    @NotNull
    public LeafCollector getLeafCollector(@NotNull LeafReaderContext context) throws IOException {
        int leafCount;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.getWeight() == null) {
            v0 = -1;
        } else {
            Weight weight = this.getWeight();
            Intrinsics.checkNotNull((Object)weight);
            v0 = leafCount = weight.count(context);
        }
        if (leafCount != -1) {
            this.totalHits += leafCount;
            throw new CollectionTerminatedException();
        }
        return this.createLeafCollector();
    }

    @NotNull
    protected final LeafCollector createLeafCollector() {
        return new LeafCollector(this){
            final /* synthetic */ TotalHitCountCollector this$0;
            {
                this.this$0 = $receiver;
            }

            public Scorable getScorer() {
                throw new UnsupportedOperationException("Scoring is not supported by TotalHitCountCollector");
            }

            public void setScorer(Scorable scorer2) {
            }

            public void collect(int doc) {
                int n = this.this$0.getTotalHits();
                TotalHitCountCollector.access$setTotalHits$p(this.this$0, n + 1);
            }

            public void collect(DocIdStream stream) throws IOException {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                TotalHitCountCollector.access$setTotalHits$p(this.this$0, this.this$0.getTotalHits() + stream.count());
            }

            public DocIdSetIterator competitiveIterator() throws IOException {
                return LeafCollector.super.competitiveIterator();
            }

            public void finish() throws IOException {
                LeafCollector.super.finish();
            }
        };
    }

    public static final /* synthetic */ void access$setTotalHits$p(TotalHitCountCollector $this, int n) {
        $this.totalHits = n;
    }
}

