/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.ExecutionException;
import org.gnit.lucenekmp.search.CollectionTerminatedException;
import org.gnit.lucenekmp.search.CollectorManager;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.TotalHitCountCollector;
import org.gnit.lucenekmp.util.ThreadInterruptedException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0004\u0018\u0000 \u00152\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0014\u0015B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u001b\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/search/TotalHitCountCollectorManager;", "Lorg/gnit/lucenekmp/search/CollectorManager;", "Lorg/gnit/lucenekmp/search/TotalHitCountCollector;", "", "leafSlices", "", "Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "<init>", "([Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;)V", "hasSegmentPartitions", "", "earlyTerminatedMap", "", "", "Lkotlinx/coroutines/CompletableDeferred;", "newCollector", "reduce", "collectors", "", "(Ljava/util/Collection;)Ljava/lang/Integer;", "LeafPartitionAwareTotalHitCountCollector", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTotalHitCountCollectorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TotalHitCountCollectorManager.kt\norg/gnit/lucenekmp/search/TotalHitCountCollectorManager\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,127:1\n3#2,8:128\n10#3:136\n*S KotlinDebug\n*F\n+ 1 TotalHitCountCollectorManager.kt\norg/gnit/lucenekmp/search/TotalHitCountCollectorManager\n*L\n56#1:128,8\n56#1:136\n*E\n"})
public final class TotalHitCountCollectorManager
implements CollectorManager<TotalHitCountCollector, Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasSegmentPartitions;
    @NotNull
    private final Map<Object, CompletableDeferred<Boolean>> earlyTerminatedMap;

    public TotalHitCountCollectorManager(@NotNull IndexSearcher.LeafSlice[] leafSlices) {
        Intrinsics.checkNotNullParameter((Object)leafSlices, (String)"leafSlices");
        this.hasSegmentPartitions = TotalHitCountCollectorManager.Companion.hasSegmentPartitions(leafSlices);
        this.earlyTerminatedMap = new LinkedHashMap();
    }

    @Override
    @NotNull
    public TotalHitCountCollector newCollector() throws IOException {
        if (this.hasSegmentPartitions) {
            return new LeafPartitionAwareTotalHitCountCollector(this.earlyTerminatedMap);
        }
        return new TotalHitCountCollector();
    }

    @Override
    @NotNull
    public Integer reduce(@NotNull Collection<TotalHitCountCollector> collectors) throws IOException {
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        boolean condition$iv = this.hasSegmentPartitions || this.earlyTerminatedMap.isEmpty();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (this.hasSegmentPartitions) {
            this.earlyTerminatedMap.clear();
        }
        int totalHits = 0;
        for (TotalHitCountCollector collector2 : collectors) {
            totalHits += collector2.getTotalHits();
        }
        return totalHits;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/search/TotalHitCountCollectorManager$Companion;", "", "<init>", "()V", "hasSegmentPartitions", "", "leafSlices", "", "Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;", "([Lorg/gnit/lucenekmp/search/IndexSearcher$LeafSlice;)Z", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasSegmentPartitions(IndexSearcher.LeafSlice[] leafSlices) {
            for (IndexSearcher.LeafSlice leafSlice : leafSlices) {
                for (IndexSearcher.LeafReaderContextPartition leafPartition : leafSlice.getPartitions()) {
                    if (leafPartition.getMinDocId() <= 0 && leafPartition.getMaxDocId() >= leafPartition.getCtx().reader().maxDoc()) continue;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/search/TotalHitCountCollectorManager$LeafPartitionAwareTotalHitCountCollector;", "Lorg/gnit/lucenekmp/search/TotalHitCountCollector;", "earlyTerminatedMap", "", "", "Lkotlinx/coroutines/CompletableDeferred;", "", "<init>", "(Ljava/util/Map;)V", "getLeafCollector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "core"})
    private static final class LeafPartitionAwareTotalHitCountCollector
    extends TotalHitCountCollector {
        @NotNull
        private final Map<Object, CompletableDeferred<Boolean>> earlyTerminatedMap;

        public LeafPartitionAwareTotalHitCountCollector(@NotNull Map<Object, CompletableDeferred<Boolean>> earlyTerminatedMap) {
            Intrinsics.checkNotNullParameter(earlyTerminatedMap, (String)"earlyTerminatedMap");
            this.earlyTerminatedMap = earlyTerminatedMap;
        }

        @Override
        @NotNull
        public LeafCollector getLeafCollector(@NotNull LeafReaderContext context) throws IOException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Ref.ObjectRef earlyTerminated = new Ref.ObjectRef();
            earlyTerminated.element = this.earlyTerminatedMap.get(context.id());
            if (earlyTerminated.element == null) {
                CompletableDeferred firstEarlyTerminated = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                CompletableDeferred<Boolean> previousEarlyTerminated = this.earlyTerminatedMap.putIfAbsent(context.id(), (CompletableDeferred<Boolean>)firstEarlyTerminated);
                if (previousEarlyTerminated == null) {
                    try {
                        LeafCollector leafCollector = super.getLeafCollector(context);
                        firstEarlyTerminated.complete((Object)false);
                        return leafCollector;
                    }
                    catch (CollectionTerminatedException e) {
                        firstEarlyTerminated.complete((Object)true);
                        throw e;
                    }
                }
                earlyTerminated.element = previousEarlyTerminated;
            }
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<CompletableDeferred<Boolean>>)earlyTerminated, null){
                int label;
                final /* synthetic */ Ref.ObjectRef<CompletableDeferred<Boolean>> $earlyTerminated;
                {
                    this.$earlyTerminated = $earlyTerminated;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            try {
                                if (((Boolean)((CompletableDeferred)this.$earlyTerminated.element).getCompleted()).booleanValue()) {
                                    throw new CollectionTerminatedException();
                                }
                            }
                            catch (CancellationException e) {
                                boolean $i$f$currentCoroutineContext = false;
                                CoroutineContext.Element element = this.getContext().get((CoroutineContext.Key)Job.Key);
                                Intrinsics.checkNotNull((Object)element);
                                Job.DefaultImpls.cancel$default((Job)((Job)element), null, (int)1, null);
                                throw new ThreadInterruptedException(e);
                            }
                            catch (ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            return this.createLeafCollector();
        }
    }
}

