/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.search.BooleanQuery;
import org.gnit.lucenekmp.search.BoostQuery;
import org.gnit.lucenekmp.search.ConstantScoreQuery;
import org.gnit.lucenekmp.search.DisjunctionMaxQuery;
import org.gnit.lucenekmp.search.FieldExistsQuery;
import org.gnit.lucenekmp.search.MatchAllDocsQuery;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.MultiTermQuery;
import org.gnit.lucenekmp.search.MultiTermQueryConstantScoreBlendedWrapper;
import org.gnit.lucenekmp.search.MultiTermQueryConstantScoreWrapper;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryCachingPolicy;
import org.gnit.lucenekmp.search.TermInSetQuery;
import org.gnit.lucenekmp.search.TermQuery;
import org.gnit.lucenekmp.util.FrequencyTrackingRingBuffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/search/UsageTrackingQueryCachingPolicy;", "Lorg/gnit/lucenekmp/search/QueryCachingPolicy;", "historySize", "", "<init>", "(I)V", "recentlyUsedFilters", "Lorg/gnit/lucenekmp/util/FrequencyTrackingRingBuffer;", "minFrequencyToCache", "query", "Lorg/gnit/lucenekmp/search/Query;", "onUse", "", "frequency", "shouldCache", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUsageTrackingQueryCachingPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageTrackingQueryCachingPolicy.kt\norg/gnit/lucenekmp/search/UsageTrackingQueryCachingPolicy\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,166:1\n3#2,8:167\n3#2,8:176\n3#2,8:185\n3#2,8:194\n10#3:175\n10#3:184\n10#3:193\n10#3:202\n*S KotlinDebug\n*F\n+ 1 UsageTrackingQueryCachingPolicy.kt\norg/gnit/lucenekmp/search/UsageTrackingQueryCachingPolicy\n*L\n52#1:167,8\n53#1:176,8\n74#1:185,8\n75#1:194,8\n52#1:175\n53#1:184\n74#1:193\n75#1:202\n*E\n"})
public class UsageTrackingQueryCachingPolicy
implements QueryCachingPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FrequencyTrackingRingBuffer recentlyUsedFilters;
    private static final int SENTINEL = Integer.MIN_VALUE;

    public UsageTrackingQueryCachingPolicy(int historySize) {
        this.recentlyUsedFilters = new FrequencyTrackingRingBuffer(historySize, Integer.MIN_VALUE);
    }

    public /* synthetic */ UsageTrackingQueryCachingPolicy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 256;
        }
        this(n);
    }

    protected final int minFrequencyToCache(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (Companion.isCostly(query)) {
            return 2;
        }
        int minFrequency = 5;
        if (query instanceof BooleanQuery || query instanceof DisjunctionMaxQuery) {
            --minFrequency;
        }
        return minFrequency;
    }

    @Override
    public void onUse(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        boolean condition$iv = !(query instanceof BoostQuery);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = !(query instanceof ConstantScoreQuery);
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (UsageTrackingQueryCachingPolicy.Companion.shouldNeverCache(query)) {
            return;
        }
        int hashCode = query.hashCode();
        this.recentlyUsedFilters.add(hashCode);
    }

    public final int frequency(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        boolean condition$iv = !(query instanceof BoostQuery);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = !(query instanceof ConstantScoreQuery);
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int hashCode = query.hashCode();
        return this.recentlyUsedFilters.frequency(hashCode);
    }

    @Override
    public boolean shouldCache(@NotNull Query query) throws IOException {
        int minFrequency;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (UsageTrackingQueryCachingPolicy.Companion.shouldNeverCache(query)) {
            return false;
        }
        int frequency = this.frequency(query);
        return frequency >= (minFrequency = this.minFrequencyToCache(query));
    }

    public UsageTrackingQueryCachingPolicy() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/search/UsageTrackingQueryCachingPolicy$Companion;", "", "<init>", "()V", "SENTINEL", "", "isPointQuery", "", "query", "Lorg/gnit/lucenekmp/search/Query;", "isCostly", "shouldNeverCache", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isPointQuery(Query query) {
            KClass clazz = Reflection.getOrCreateKotlinClass(query.getClass());
            while (!Intrinsics.areEqual((Object)clazz, (Object)Reflection.getOrCreateKotlinClass(Query.class))) {
                String simpleName;
                Intrinsics.checkNotNull((Object)clazz.getSimpleName());
                if (!StringsKt.startsWith$default((String)simpleName, (String)"Point", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)simpleName, (String)"Query", (boolean)false, (int)2, null)) continue;
                return true;
            }
            return false;
        }

        public final boolean isCostly(@NotNull Query query) {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            return query instanceof MultiTermQuery || query instanceof MultiTermQueryConstantScoreBlendedWrapper || query instanceof MultiTermQueryConstantScoreWrapper || query instanceof TermInSetQuery || this.isPointQuery(query);
        }

        private final boolean shouldNeverCache(Query query) {
            if (query instanceof TermQuery) {
                return true;
            }
            if (query instanceof FieldExistsQuery) {
                return true;
            }
            if (query instanceof MatchAllDocsQuery) {
                return true;
            }
            if (query instanceof MatchNoDocsQuery) {
                return true;
            }
            if (query instanceof BooleanQuery && ((BooleanQuery)query).clauses().isEmpty()) {
                return true;
            }
            return query instanceof DisjunctionMaxQuery && ((DisjunctionMaxQuery)query).getDisjuncts().isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

