/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.search.BulkScorer;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.Explanation;
import org.gnit.lucenekmp.search.LeafCollector;
import org.gnit.lucenekmp.search.Matches;
import org.gnit.lucenekmp.search.MatchesUtils;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.SegmentCacheable;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.util.Bits;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/search/Weight;", "Lorg/gnit/lucenekmp/search/SegmentCacheable;", "query", "Lorg/gnit/lucenekmp/search/Query;", "<init>", "(Lorg/gnit/lucenekmp/search/Query;)V", "getQuery", "()Lorg/gnit/lucenekmp/search/Query;", "matches", "Lorg/gnit/lucenekmp/search/Matches;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "doc", "", "explain", "Lorg/gnit/lucenekmp/search/Explanation;", "scorer", "Lorg/gnit/lucenekmp/search/Scorer;", "scorerSupplier", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "bulkScorer", "Lorg/gnit/lucenekmp/search/BulkScorer;", "count", "DefaultScorerSupplier", "DefaultBulkScorer", "core"})
public abstract class Weight
implements SegmentCacheable {
    @NotNull
    private final Query query;

    protected Weight(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.query = query;
    }

    @NotNull
    public Query getQuery() {
        return this.query;
    }

    @Nullable
    public Matches matches(@NotNull LeafReaderContext context, int doc) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ScorerSupplier scorerSupplier2 = this.scorerSupplier(context);
        if (scorerSupplier2 == null) {
            return null;
        }
        Scorer scorer2 = scorerSupplier2.get(1L);
        TwoPhaseIterator twoPhase = scorer2.twoPhaseIterator();
        if (twoPhase == null ? scorer2.iterator().advance(doc) != doc : twoPhase.approximation().advance(doc) != doc || !twoPhase.matches()) {
            return null;
        }
        return MatchesUtils.INSTANCE.getMATCH_WITH_NO_TERMS();
    }

    @NotNull
    public abstract Explanation explain(@NotNull LeafReaderContext var1, int var2) throws IOException;

    @Nullable
    public final Scorer scorer(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ScorerSupplier scorerSupplier2 = this.scorerSupplier(context);
        if (scorerSupplier2 == null) {
            return null;
        }
        return scorerSupplier2.get(Long.MAX_VALUE);
    }

    @Nullable
    public abstract ScorerSupplier scorerSupplier(@NotNull LeafReaderContext var1) throws IOException;

    @Nullable
    public final BulkScorer bulkScorer(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ScorerSupplier scorerSupplier2 = this.scorerSupplier(context);
        if (scorerSupplier2 == null) {
            return null;
        }
        scorerSupplier2.setTopLevelScoringClause();
        return scorerSupplier2.bulkScorer();
    }

    public int count(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return -1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/search/Weight$DefaultBulkScorer;", "Lorg/gnit/lucenekmp/search/BulkScorer;", "scorer", "Lorg/gnit/lucenekmp/search/Scorer;", "<init>", "(Lorg/gnit/lucenekmp/search/Scorer;)V", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "twoPhase", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "cost", "", "score", "", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "min", "max", "Companion", "core"})
    public static final class DefaultBulkScorer
    extends BulkScorer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Scorer scorer;
        @NotNull
        private DocIdSetIterator iterator;
        @Nullable
        private final TwoPhaseIterator twoPhase;

        public DefaultBulkScorer(@NotNull Scorer scorer2) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            this.scorer = scorer2;
            this.twoPhase = scorer2.twoPhaseIterator();
            this.iterator = this.twoPhase == null ? scorer2.iterator() : this.twoPhase.approximation();
        }

        @Override
        public long cost() {
            DocIdSetIterator docIdSetIterator = this.iterator;
            Intrinsics.checkNotNull((Object)docIdSetIterator);
            return docIdSetIterator.cost();
        }

        @Override
        public int score(@NotNull LeafCollector collector2, @Nullable Bits acceptDocs, int min, int max) throws IOException {
            Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
            int min2 = min;
            collector2.setScorer(this.scorer);
            DocIdSetIterator competitiveIterator2 = collector2.competitiveIterator();
            if (competitiveIterator2 != null && competitiveIterator2.docID() > min2) {
                min2 = competitiveIterator2.docID();
                min2 = Math.min(min2, max);
            }
            if (this.iterator.docID() < min2) {
                int n = this.iterator.docID() == min2 - 1 ? this.iterator.nextDoc() : this.iterator.advance(min2);
            }
            if (this.twoPhase == null && competitiveIterator2 == null) {
                DefaultBulkScorer.Companion.scoreIterator(collector2, acceptDocs, this.iterator, max);
            } else if (competitiveIterator2 == null) {
                TwoPhaseIterator twoPhaseIterator2 = this.twoPhase;
                Intrinsics.checkNotNull((Object)twoPhaseIterator2);
                DefaultBulkScorer.Companion.scoreTwoPhaseIterator(collector2, acceptDocs, this.iterator, twoPhaseIterator2, max);
            } else if (this.twoPhase == null) {
                DefaultBulkScorer.Companion.scoreCompetitiveIterator(collector2, acceptDocs, this.iterator, competitiveIterator2, max);
            } else {
                DefaultBulkScorer.Companion.scoreTwoPhaseOrCompetitiveIterator(collector2, acceptDocs, this.iterator, this.twoPhase, competitiveIterator2, max);
            }
            return this.iterator.docID();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J2\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J:\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/search/Weight$DefaultBulkScorer$Companion;", "", "<init>", "()V", "scoreIterator", "", "collector", "Lorg/gnit/lucenekmp/search/LeafCollector;", "acceptDocs", "Lorg/gnit/lucenekmp/util/Bits;", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "max", "", "scoreTwoPhaseIterator", "twoPhase", "Lorg/gnit/lucenekmp/search/TwoPhaseIterator;", "scoreCompetitiveIterator", "competitiveIterator", "scoreTwoPhaseOrCompetitiveIterator", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final void scoreIterator(LeafCollector collector2, Bits acceptDocs, DocIdSetIterator iterator2, int max) throws IOException {
                int doc = iterator2.docID();
                while (doc < max) {
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        collector2.collect(doc);
                    }
                    doc = iterator2.nextDoc();
                }
            }

            private final void scoreTwoPhaseIterator(LeafCollector collector2, Bits acceptDocs, DocIdSetIterator iterator2, TwoPhaseIterator twoPhase, int max) throws IOException {
                int doc = iterator2.docID();
                while (doc < max) {
                    if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                        collector2.collect(doc);
                    }
                    doc = iterator2.nextDoc();
                }
            }

            private final void scoreCompetitiveIterator(LeafCollector collector2, Bits acceptDocs, DocIdSetIterator iterator2, DocIdSetIterator competitiveIterator2, int max) throws IOException {
                int doc = iterator2.docID();
                while (doc < max) {
                    int competitiveNext;
                    if (!(competitiveIterator2.docID() <= doc)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (competitiveIterator2.docID() < doc && (competitiveNext = competitiveIterator2.advance(doc)) != doc) {
                        doc = iterator2.advance(competitiveNext);
                        continue;
                    }
                    if (acceptDocs == null || acceptDocs.get(doc)) {
                        collector2.collect(doc);
                    }
                    doc = iterator2.nextDoc();
                }
            }

            private final void scoreTwoPhaseOrCompetitiveIterator(LeafCollector collector2, Bits acceptDocs, DocIdSetIterator iterator2, TwoPhaseIterator twoPhase, DocIdSetIterator competitiveIterator2, int max) throws IOException {
                int doc = iterator2.docID();
                while (doc < max) {
                    int competitiveNext;
                    if (!(competitiveIterator2.docID() <= doc)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (competitiveIterator2.docID() < doc && (competitiveNext = competitiveIterator2.advance(doc)) != doc) {
                        doc = iterator2.advance(competitiveNext);
                        continue;
                    }
                    if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                        collector2.collect(doc);
                    }
                    doc = iterator2.nextDoc();
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/search/Weight$DefaultScorerSupplier;", "Lorg/gnit/lucenekmp/search/ScorerSupplier;", "scorer", "Lorg/gnit/lucenekmp/search/Scorer;", "<init>", "(Lorg/gnit/lucenekmp/search/Scorer;)V", "get", "leadCost", "", "cost", "core"})
    @SourceDebugExtension(value={"SMAP\nWeight.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Weight.kt\norg/gnit/lucenekmp/search/Weight$DefaultScorerSupplier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n1#2:374\n*E\n"})
    protected static final class DefaultScorerSupplier
    extends ScorerSupplier {
        @NotNull
        private final Scorer scorer;

        public DefaultScorerSupplier(@NotNull Scorer scorer2) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            this.scorer = scorer2;
        }

        @Override
        @NotNull
        public Scorer get(long leadCost) throws IOException {
            return this.scorer;
        }

        @Override
        public long cost() {
            return this.scorer.iterator().cost();
        }
    }
}

