/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.search.comparators;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.comparators.NumericComparator;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0015\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0017\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/search/comparators/IntComparator;", "Lorg/gnit/lucenekmp/search/comparators/NumericComparator;", "", "numHits", "field", "", "missingValue", "reverse", "", "pruning", "Lorg/gnit/lucenekmp/search/Pruning;", "<init>", "(ILjava/lang/String;Ljava/lang/Integer;ZLorg/gnit/lucenekmp/search/Pruning;)V", "values", "", "topValue", "getTopValue", "()I", "setTopValue", "(I)V", "bottom", "getBottom", "setBottom", "compare", "slot1", "slot2", "", "value", "setTopValueKt", "slot", "(I)Ljava/lang/Integer;", "missingValueAsComparableLong", "", "sortableBytesToLong", "bytes", "", "getLeafComparator", "Lorg/gnit/lucenekmp/search/LeafFieldComparator;", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "IntLeafComparator", "core"})
public final class IntComparator
extends NumericComparator<Integer> {
    @NotNull
    private final int[] values;
    private int topValue;
    private int bottom;

    public IntComparator(int numHits, @NotNull String field, @Nullable Integer missingValue, boolean reverse, @NotNull Pruning pruning) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)pruning), (String)"pruning");
        Integer n = missingValue;
        super(field, n != null ? n : 0, reverse, pruning, 4);
        this.values = new int[numHits];
    }

    protected final int getTopValue() {
        return this.topValue;
    }

    @Override
    protected final void setTopValue(int n) {
        this.topValue = n;
    }

    protected final int getBottom() {
        return this.bottom;
    }

    protected final void setBottom(int n) {
        this.bottom = n;
    }

    @Override
    public int compare(int slot1, int slot2) {
        return IntExtKt.compare(IntCompanionObject.INSTANCE, this.values[slot1], this.values[slot2]);
    }

    @JvmName(name="setTopValueKt")
    public void setTopValueKt(int value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    @NotNull
    public Integer value(int slot) {
        return this.values[slot];
    }

    @Override
    protected long missingValueAsComparableLong() {
        return ((Number)this.getMissingValue()).intValue();
    }

    @Override
    protected long sortableBytesToLong(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return NumericUtils.INSTANCE.sortableBytesToInt(bytes, 0);
    }

    @Override
    @NotNull
    public LeafFieldComparator getLeafComparator(@NotNull LeafReaderContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new IntLeafComparator(context);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/search/comparators/IntComparator$IntLeafComparator;", "Lorg/gnit/lucenekmp/search/comparators/NumericComparator$NumericLeafComparator;", "Lorg/gnit/lucenekmp/search/comparators/NumericComparator;", "", "context", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "<init>", "(Lorg/gnit/lucenekmp/search/comparators/IntComparator;Lorg/gnit/lucenekmp/index/LeafReaderContext;)V", "getValueForDoc", "doc", "setBottom", "", "slot", "compareBottom", "compareTop", "copy", "bottomAsComparableLong", "", "topAsComparableLong", "core"})
    public final class IntLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public IntLeafComparator(LeafReaderContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(IntComparator.this, context);
        }

        private final int getValueForDoc(int doc) throws IOException {
            if (this.getDocValues().advanceExact(doc)) {
                return (int)this.getDocValues().longValue();
            }
            return ((Number)IntComparator.this.getMissingValue()).intValue();
        }

        @Override
        public void setBottom(int slot) throws IOException {
            IntComparator.this.setBottom(IntComparator.this.values[slot]);
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return IntExtKt.compare(IntCompanionObject.INSTANCE, IntComparator.this.getBottom(), this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return IntExtKt.compare(IntCompanionObject.INSTANCE, IntComparator.this.getTopValue(), this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            ((IntComparator)IntComparator.this).values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected long bottomAsComparableLong() {
            return IntComparator.this.getBottom();
        }

        @Override
        protected long topAsComparableLong() {
            return IntComparator.this.getTopValue();
        }
    }
}

